/*
 * Decompiled with CFR 0.152.
 */
package com.cricketcraft.chisel.client.render.tile;

import com.cricketcraft.chisel.block.tileentity.TileEntityPresent;
import com.cricketcraft.chisel.init.ChiselBlocks;
import com.google.common.collect.Maps;
import cpw.mods.fml.client.FMLClientHandler;
import java.util.HashMap;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.model.ModelLargeChest;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderPresent
extends TileEntitySpecialRenderer
implements IItemRenderer {
    private ModelChest smallChest = new ModelChest();
    private ModelChest largeChest = new ModelLargeChest();
    private HashMap<Integer, ResourceLocation> textureCache = Maps.newHashMap();

    public void renderTileEntityAt(TileEntityPresent present, double x, double y, double z, float partialTicks) {
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)((float)x), (float)((float)y + 1.0f), (float)((float)z + 1.0f));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        int rotation = present.getRotation();
        this.bindTexture(present);
        if (!present.isConnected()) {
            GL11.glRotatef((float)(90 * rotation + 180), (float)0.0f, (float)1.0f, (float)0.0f);
            switch (rotation) {
                case 0: {
                    GL11.glTranslatef((float)-1.0f, (float)0.0f, (float)-1.0f);
                    break;
                }
                case 1: {
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-1.0f);
                    break;
                }
                case 3: {
                    GL11.glTranslatef((float)-1.0f, (float)0.0f, (float)0.0f);
                }
            }
            this.smallChest.func_78231_a();
        } else if (present.isParent()) {
            ForgeDirection dir = present.getConnectionDir();
            switch (dir) {
                case NORTH: {
                    GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-1.0f);
                    break;
                }
                case SOUTH: {
                    GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glTranslatef((float)-1.0f, (float)0.0f, (float)-1.0f);
                    break;
                }
                case WEST: {
                    GL11.glTranslatef((float)-1.0f, (float)0.0f, (float)0.0f);
                    break;
                }
            }
            if (rotation == 0 || rotation == 3) {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)-2.0f, (float)0.0f, (float)-1.0f);
            }
            this.largeChest.func_78231_a();
        }
        GL11.glPopMatrix();
    }

    private void bindTexture(TileEntityPresent present) {
        int idx = present.func_145831_w().func_72805_g(present.field_145851_c, present.field_145848_d, present.field_145849_e) + (present.isConnected() ? 0 : 16);
        ResourceLocation rl = this.textureCache.get(idx);
        if (rl == null) {
            String res = ChiselBlocks.present.getModelTexture(idx % 16);
            res = res + (present.isConnected() ? "_double.png" : ".png");
            rl = new ResourceLocation("chisel", res);
            this.textureCache.put(idx, rl);
        }
        this.func_147499_a(rl);
    }

    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float partialTicks) {
        this.renderTileEntityAt((TileEntityPresent)tileEntity, x, y, z, partialTicks);
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type != IItemRenderer.ItemRenderType.FIRST_PERSON_MAP;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(new ResourceLocation("chisel", ChiselBlocks.present.getModelTexture(item.func_77960_j()) + ".png"));
        switch (type) {
            case ENTITY: {
                this.renderBlock(0.0f, 1.0f, 0.0f);
                break;
            }
            case EQUIPPED: {
                this.renderBlock(0.5f, 1.5f, 0.5f);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                this.renderBlock(0.5f, 1.0f, 0.5f);
                break;
            }
            case INVENTORY: {
                this.renderInventory(1.0f, 1.0f, 1.0f);
                break;
            }
        }
    }

    private void renderBlock(float x, float y, float z) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
        GL11.glScaled((double)-1.0, (double)-1.0, (double)1.0);
        this.smallChest.func_78231_a();
        GL11.glPopMatrix();
    }

    private void renderInventory(float x, float y, float z) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
        this.smallChest.func_78231_a();
        GL11.glPopMatrix();
    }
}

