/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftBuilders;
import buildcraft.api.core.ISerializable;
import buildcraft.api.core.Position;
import buildcraft.api.tiles.ITileAreaProvider;
import buildcraft.core.DefaultProps;
import buildcraft.core.LaserKind;
import buildcraft.core.lib.EntityBlock;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.utils.Utils;
import buildcraft.core.proxy.CoreProxy;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileMarker
extends TileBuildCraft
implements ITileAreaProvider {
    public Origin origin = new Origin();
    public boolean showSignals = false;
    private Position initVectO;
    private Position[] initVect;
    private EntityBlock[] lasers;
    private EntityBlock[] signals;

    public void updateSignals() {
        if (!this.field_145850_b.field_72995_K) {
            this.showSignals = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.sendNetworkUpdate();
        }
    }

    private void switchSignals() {
        if (this.signals != null) {
            for (EntityBlock b : this.signals) {
                if (b == null) continue;
                CoreProxy.proxy.removeEntity(b);
            }
            this.signals = null;
        }
        if (this.showSignals) {
            this.signals = new EntityBlock[6];
            if (!this.origin.isSet() || !this.origin.vect[0].isSet()) {
                this.signals[0] = Utils.createLaser(this.field_145850_b, new Position(this.field_145851_c, this.field_145848_d, this.field_145849_e), new Position(this.field_145851_c + DefaultProps.MARKER_RANGE - 1, this.field_145848_d, this.field_145849_e), LaserKind.Blue);
                this.signals[1] = Utils.createLaser(this.field_145850_b, new Position(this.field_145851_c - DefaultProps.MARKER_RANGE + 1, this.field_145848_d, this.field_145849_e), new Position(this.field_145851_c, this.field_145848_d, this.field_145849_e), LaserKind.Blue);
            }
            if (!this.origin.isSet() || !this.origin.vect[1].isSet()) {
                this.signals[2] = Utils.createLaser(this.field_145850_b, new Position(this.field_145851_c, this.field_145848_d, this.field_145849_e), new Position(this.field_145851_c, this.field_145848_d + DefaultProps.MARKER_RANGE - 1, this.field_145849_e), LaserKind.Blue);
                this.signals[3] = Utils.createLaser(this.field_145850_b, new Position(this.field_145851_c, this.field_145848_d - DefaultProps.MARKER_RANGE + 1, this.field_145849_e), new Position(this.field_145851_c, this.field_145848_d, this.field_145849_e), LaserKind.Blue);
            }
            if (!this.origin.isSet() || !this.origin.vect[2].isSet()) {
                this.signals[4] = Utils.createLaser(this.field_145850_b, new Position(this.field_145851_c, this.field_145848_d, this.field_145849_e), new Position(this.field_145851_c, this.field_145848_d, this.field_145849_e + DefaultProps.MARKER_RANGE - 1), LaserKind.Blue);
                this.signals[5] = Utils.createLaser(this.field_145850_b, new Position(this.field_145851_c, this.field_145848_d, this.field_145849_e - DefaultProps.MARKER_RANGE + 1), new Position(this.field_145851_c, this.field_145848_d, this.field_145849_e), LaserKind.Blue);
            }
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.updateSignals();
        if (this.initVectO != null) {
            this.origin = new Origin();
            this.origin.vectO = new TileWrapper((int)this.initVectO.x, (int)this.initVectO.y, (int)this.initVectO.z);
            for (int i = 0; i < 3; ++i) {
                if (this.initVect[i] == null) continue;
                this.linkTo((TileMarker)this.field_145850_b.func_147438_o((int)this.initVect[i].x, (int)this.initVect[i].y, (int)this.initVect[i].z), i);
            }
        }
    }

    public void tryConnection() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (int j = 0; j < 3; ++j) {
            if (this.origin.isSet() && this.origin.vect[j].isSet()) continue;
            this.setVect(j);
        }
        this.sendNetworkUpdate();
    }

    void setVect(int n) {
        int[] coords = new int[]{this.field_145851_c, this.field_145848_d, this.field_145849_e};
        if (!this.origin.isSet() || !this.origin.vect[n].isSet()) {
            for (int j = 1; j < DefaultProps.MARKER_RANGE; ++j) {
                TileMarker marker;
                int n2 = n;
                coords[n2] = coords[n2] + j;
                Block block = this.field_145850_b.func_147439_a(coords[0], coords[1], coords[2]);
                if (block == BuildCraftBuilders.markerBlock && this.linkTo(marker = (TileMarker)this.field_145850_b.func_147438_o(coords[0], coords[1], coords[2]), n)) break;
                int n3 = n;
                coords[n3] = coords[n3] - j;
                int n4 = n;
                coords[n4] = coords[n4] - j;
                block = this.field_145850_b.func_147439_a(coords[0], coords[1], coords[2]);
                if (block == BuildCraftBuilders.markerBlock && this.linkTo(marker = (TileMarker)this.field_145850_b.func_147438_o(coords[0], coords[1], coords[2]), n)) break;
                int n5 = n;
                coords[n5] = coords[n5] + j;
            }
        }
    }

    private boolean linkTo(TileMarker marker, int n) {
        if (marker == null) {
            return false;
        }
        if (this.origin.isSet() && marker.origin.isSet()) {
            return false;
        }
        if (!this.origin.isSet() && !marker.origin.isSet()) {
            marker.origin = this.origin = new Origin();
            this.origin.vectO = new TileWrapper(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.origin.vect[n] = new TileWrapper(marker.field_145851_c, marker.field_145848_d, marker.field_145849_e);
        } else if (!this.origin.isSet()) {
            this.origin = marker.origin;
            this.origin.vect[n] = new TileWrapper(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else {
            marker.origin = this.origin;
            this.origin.vect[n] = new TileWrapper(marker.field_145851_c, marker.field_145848_d, marker.field_145849_e);
        }
        this.origin.vectO.getMarker(this.field_145850_b).createLasers();
        this.updateSignals();
        marker.updateSignals();
        return true;
    }

    private void createLasers() {
        if (this.lasers != null) {
            for (EntityBlock entity : this.lasers) {
                if (entity == null) continue;
                CoreProxy.proxy.removeEntity(entity);
            }
        }
        this.lasers = new EntityBlock[12];
        Origin o = this.origin;
        if (!this.origin.vect[0].isSet()) {
            o.xMin = this.origin.vectO.x;
            o.xMax = this.origin.vectO.x;
        } else if (this.origin.vect[0].x < this.field_145851_c) {
            o.xMin = this.origin.vect[0].x;
            o.xMax = this.field_145851_c;
        } else {
            o.xMin = this.field_145851_c;
            o.xMax = this.origin.vect[0].x;
        }
        if (!this.origin.vect[1].isSet()) {
            o.yMin = this.origin.vectO.y;
            o.yMax = this.origin.vectO.y;
        } else if (this.origin.vect[1].y < this.field_145848_d) {
            o.yMin = this.origin.vect[1].y;
            o.yMax = this.field_145848_d;
        } else {
            o.yMin = this.field_145848_d;
            o.yMax = this.origin.vect[1].y;
        }
        if (!this.origin.vect[2].isSet()) {
            o.zMin = this.origin.vectO.z;
            o.zMax = this.origin.vectO.z;
        } else if (this.origin.vect[2].z < this.field_145849_e) {
            o.zMin = this.origin.vect[2].z;
            o.zMax = this.field_145849_e;
        } else {
            o.zMin = this.field_145849_e;
            o.zMax = this.origin.vect[2].z;
        }
        this.lasers = Utils.createLaserBox(this.field_145850_b, o.xMin, o.yMin, o.zMin, o.xMax, o.yMax, o.zMax, LaserKind.Red);
    }

    @Override
    public int xMin() {
        if (this.origin.isSet()) {
            return this.origin.xMin;
        }
        return this.field_145851_c;
    }

    @Override
    public int yMin() {
        if (this.origin.isSet()) {
            return this.origin.yMin;
        }
        return this.field_145848_d;
    }

    @Override
    public int zMin() {
        if (this.origin.isSet()) {
            return this.origin.zMin;
        }
        return this.field_145849_e;
    }

    @Override
    public int xMax() {
        if (this.origin.isSet()) {
            return this.origin.xMax;
        }
        return this.field_145851_c;
    }

    @Override
    public int yMax() {
        if (this.origin.isSet()) {
            return this.origin.yMax;
        }
        return this.field_145848_d;
    }

    @Override
    public int zMax() {
        if (this.origin.isSet()) {
            return this.origin.zMax;
        }
        return this.field_145849_e;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.destroy();
    }

    @Override
    public void destroy() {
        TileMarker markerOrigin = null;
        if (this.origin.isSet()) {
            TileMarker mark;
            markerOrigin = this.origin.vectO.getMarker(this.field_145850_b);
            Origin o = this.origin;
            if (markerOrigin != null && markerOrigin.lasers != null) {
                for (EntityBlock entityBlock : markerOrigin.lasers) {
                    if (entityBlock == null) continue;
                    entityBlock.func_70106_y();
                }
                markerOrigin.lasers = null;
            }
            for (TileWrapper tileWrapper : o.vect) {
                mark = tileWrapper.getMarker(this.field_145850_b);
                if (mark == null) continue;
                if (mark.lasers != null) {
                    for (EntityBlock entity : mark.lasers) {
                        if (entity == null) continue;
                        entity.func_70106_y();
                    }
                    mark.lasers = null;
                }
                if (mark == this) continue;
                mark.origin = new Origin();
            }
            if (markerOrigin != this && markerOrigin != null) {
                markerOrigin.origin = new Origin();
            }
            TileWrapper[] tileWrapperArray = o.vect;
            int n = tileWrapperArray.length;
            for (int i = 0; i < n; ++i) {
                TileWrapper tileWrapper = tileWrapperArray[i];
                mark = tileWrapper.getMarker(this.field_145850_b);
                if (mark == null) continue;
                mark.updateSignals();
            }
            if (markerOrigin != null) {
                markerOrigin.updateSignals();
            }
        }
        if (this.signals != null) {
            for (EntityBlock block : this.signals) {
                if (block == null) continue;
                block.func_70106_y();
            }
        }
        this.signals = null;
        if (!this.field_145850_b.field_72995_K && markerOrigin != null && markerOrigin != this) {
            markerOrigin.sendNetworkUpdate();
        }
    }

    @Override
    public void removeFromWorld() {
        if (!this.origin.isSet()) {
            return;
        }
        Origin o = this.origin;
        for (TileWrapper m : (TileWrapper[])o.vect.clone()) {
            if (!m.isSet()) continue;
            this.field_145850_b.func_147468_f(m.x, m.y, m.z);
            BuildCraftBuilders.markerBlock.func_149697_b(this.field_145850_b, m.x, m.y, m.z, 0, 0);
        }
        this.field_145850_b.func_147468_f(o.vectO.x, o.vectO.y, o.vectO.z);
        BuildCraftBuilders.markerBlock.func_149697_b(this.field_145850_b, o.vectO.x, o.vectO.y, o.vectO.z, 0, 0);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("vectO")) {
            this.initVectO = new Position(nbttagcompound.func_74775_l("vectO"));
            this.initVect = new Position[3];
            for (int i = 0; i < 3; ++i) {
                if (!nbttagcompound.func_74764_b("vect" + i)) continue;
                this.initVect[i] = new Position(nbttagcompound.func_74775_l("vect" + i));
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        if (this.origin.isSet() && this.origin.vectO.getMarker(this.field_145850_b) == this) {
            NBTTagCompound vectO = new NBTTagCompound();
            new Position(this.origin.vectO.getMarker(this.field_145850_b)).writeToNBT(vectO);
            nbttagcompound.func_74782_a("vectO", (NBTBase)vectO);
            for (int i = 0; i < 3; ++i) {
                if (!this.origin.vect[i].isSet()) continue;
                NBTTagCompound vect = new NBTTagCompound();
                new Position(this.origin.vect[i].x, this.origin.vect[i].y, this.origin.vect[i].z).writeToNBT(vect);
                nbttagcompound.func_74782_a("vect" + i, (NBTBase)vect);
            }
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
        this.origin.writeData(stream);
        stream.writeBoolean(this.showSignals);
    }

    @Override
    public void readData(ByteBuf stream) {
        this.origin.readData(stream);
        this.showSignals = stream.readBoolean();
        this.switchSignals();
        if (this.origin.vectO.isSet() && this.origin.vectO.getMarker(this.field_145850_b) != null) {
            this.origin.vectO.getMarker(this.field_145850_b).updateSignals();
            for (TileWrapper w : this.origin.vect) {
                TileMarker m = w.getMarker(this.field_145850_b);
                if (m == null) continue;
                m.updateSignals();
            }
        }
        this.createLasers();
    }

    @Override
    public boolean isValidFromLocation(int x, int y, int z) {
        int equal = (x == this.field_145851_c ? 1 : 0) + (y == this.field_145848_d ? 1 : 0) + (z == this.field_145849_e ? 1 : 0);
        int touching = 0;
        if (equal == 0 || equal == 3) {
            return false;
        }
        if (x < this.xMin() - 1 || x > this.xMax() + 1 || y < this.yMin() - 1 || y > this.yMax() + 1 || z < this.zMin() - 1 || z > this.zMax() + 1) {
            return false;
        }
        if (x >= this.xMin() && x <= this.xMax() && y >= this.yMin() && y <= this.yMax() && z >= this.zMin() && z <= this.zMax()) {
            return false;
        }
        if (this.xMin() - x == 1 || x - this.xMax() == 1) {
            ++touching;
        }
        if (this.yMin() - y == 1 || y - this.yMax() == 1) {
            ++touching;
        }
        if (this.zMin() - z == 1 || z - this.zMax() == 1) {
            ++touching;
        }
        return touching == 1;
    }

    public static class Origin
    implements ISerializable {
        public TileWrapper vectO = new TileWrapper();
        public TileWrapper[] vect = new TileWrapper[]{new TileWrapper(), new TileWrapper(), new TileWrapper()};
        public int xMin;
        public int yMin;
        public int zMin;
        public int xMax;
        public int yMax;
        public int zMax;

        public boolean isSet() {
            return this.vectO.isSet();
        }

        @Override
        public void writeData(ByteBuf stream) {
            this.vectO.writeData(stream);
            for (TileWrapper tw : this.vect) {
                tw.writeData(stream);
            }
            stream.writeInt(this.xMin);
            stream.writeShort(this.yMin);
            stream.writeInt(this.zMin);
            stream.writeInt(this.xMax);
            stream.writeShort(this.yMax);
            stream.writeInt(this.zMax);
        }

        @Override
        public void readData(ByteBuf stream) {
            this.vectO.readData(stream);
            for (TileWrapper tw : this.vect) {
                tw.readData(stream);
            }
            this.xMin = stream.readInt();
            this.yMin = stream.readShort();
            this.zMin = stream.readInt();
            this.xMax = stream.readInt();
            this.yMax = stream.readShort();
            this.zMax = stream.readInt();
        }
    }

    public static class TileWrapper
    implements ISerializable {
        public int x;
        public int y;
        public int z;
        private TileMarker marker;

        public TileWrapper() {
            this.x = Integer.MAX_VALUE;
            this.y = Integer.MAX_VALUE;
            this.z = Integer.MAX_VALUE;
        }

        public TileWrapper(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public boolean isSet() {
            return this.x != Integer.MAX_VALUE;
        }

        public TileMarker getMarker(World world) {
            TileEntity tile;
            if (!this.isSet()) {
                return null;
            }
            if (this.marker == null && (tile = world.func_147438_o(this.x, this.y, this.z)) instanceof TileMarker) {
                this.marker = (TileMarker)tile;
            }
            return this.marker;
        }

        public void reset() {
            this.x = Integer.MAX_VALUE;
            this.y = Integer.MAX_VALUE;
            this.z = Integer.MAX_VALUE;
        }

        @Override
        public void readData(ByteBuf stream) {
            this.x = stream.readInt();
            if (this.isSet()) {
                this.y = stream.readShort();
                this.z = stream.readInt();
            }
        }

        @Override
        public void writeData(ByteBuf stream) {
            stream.writeInt(this.x);
            if (this.isSet()) {
                stream.writeShort(this.y);
                stream.writeInt(this.z);
            }
        }
    }
}

