/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.ISerializable;
import buildcraft.api.transport.IPipeTile;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportFluids;
import buildcraft.transport.pipes.PipeLogicWood;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class PipeFluidsWood
extends Pipe<PipeTransportFluids>
implements IEnergyHandler,
ISerializable {
    private static final int ENERGY_MULTIPLIER = 50;
    public int liquidToExtract;
    protected int standardIconIndex = PipeIconProvider.TYPE.PipeFluidsWood_Standard.ordinal();
    protected int solidIconIndex = PipeIconProvider.TYPE.PipeAllWood_Solid.ordinal();
    private PipeLogicWood logic = new PipeLogicWood(this){

        @Override
        protected boolean isValidConnectingTile(TileEntity tile) {
            if (tile instanceof IPipeTile) {
                return false;
            }
            return tile instanceof IFluidHandler;
        }
    };

    public PipeFluidsWood(Item item) {
        super(new PipeTransportFluids(), item);
        ((PipeTransportFluids)this.transport).initFromPipe(this.getClass());
    }

    @Override
    public boolean blockActivated(EntityPlayer entityplayer, ForgeDirection side) {
        return this.logic.blockActivated(entityplayer, side);
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        this.logic.onNeighborBlockChange();
        super.onNeighborBlockChange(blockId);
    }

    @Override
    public void initialize() {
        this.logic.initialize();
        super.initialize();
    }

    private TileEntity getConnectingTile() {
        int meta = this.container.func_145832_p();
        return meta >= 6 ? null : this.container.getTile(ForgeDirection.getOrientation((int)meta));
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.liquidToExtract <= 0) {
            return;
        }
        TileEntity tile = this.getConnectingTile();
        if (tile == null || !(tile instanceof IFluidHandler)) {
            this.liquidToExtract = 0;
        } else {
            this.extractFluid((IFluidHandler)tile, ForgeDirection.getOrientation((int)this.container.func_145832_p()));
            this.liquidToExtract -= ((PipeTransportFluids)this.transport).getFlowRate();
            if (this.liquidToExtract < 0) {
                this.liquidToExtract = 0;
            }
        }
    }

    public int extractFluid(IFluidHandler fluidHandler, ForgeDirection side) {
        int amount = this.liquidToExtract > ((PipeTransportFluids)this.transport).getFlowRate() ? ((PipeTransportFluids)this.transport).getFlowRate() : this.liquidToExtract;
        FluidTankInfo tankInfo = ((PipeTransportFluids)this.transport).getTankInfo(side)[0];
        FluidStack extracted = tankInfo.fluid != null ? fluidHandler.drain(side.getOpposite(), new FluidStack(tankInfo.fluid, amount), false) : fluidHandler.drain(side.getOpposite(), amount, false);
        int inserted = 0;
        if (extracted != null && (inserted = ((PipeTransportFluids)this.transport).fill(side, extracted, true)) > 0) {
            extracted.amount = inserted;
            fluidHandler.drain(side.getOpposite(), extracted, true);
        }
        return inserted;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return this.standardIconIndex;
        }
        int metadata = this.container.func_145832_p();
        if (metadata == direction.ordinal()) {
            return this.solidIconIndex;
        }
        return this.standardIconIndex;
    }

    @Override
    public boolean outputOpen(ForgeDirection to) {
        int meta = this.container.func_145832_p();
        return super.outputOpen(to) && meta != to.ordinal();
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        TileEntity tile = this.getConnectingTile();
        if (tile == null || !(tile instanceof IFluidHandler)) {
            return 0;
        }
        int maxToReceive = (1000 - this.liquidToExtract) / 50;
        int received = Math.min(maxReceive, maxToReceive);
        if (!simulate) {
            this.liquidToExtract += 50 * received;
        }
        return received;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return 0;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return 20;
    }

    @Override
    public void writeData(ByteBuf data) {
        data.writeShort(this.liquidToExtract);
    }

    @Override
    public void readData(ByteBuf data) {
        this.liquidToExtract = data.readShort();
    }
}

