/*
 * Decompiled with CFR 0.152.
 */
package ttftcuts.atg.gen;

import java.util.Random;
import net.minecraft.world.World;
import ttftcuts.atg.api.IGenMod;

public class ATGGenModPlateau
implements IGenMod {
    public int minHeight = 64;
    public int maxHeight = 128;
    public int plateauHeight = 96;
    public double heightExponent = 3.0;
    public boolean limit = false;

    public ATGGenModPlateau() {
    }

    public ATGGenModPlateau(int min, int height, int max, boolean limit, double exponent) {
        this.minHeight = min;
        this.maxHeight = max;
        this.plateauHeight = height;
        this.heightExponent = exponent;
    }

    @Override
    public int modify(World world, int height, Random random, double rawHeight, int x, int z) {
        return ATGGenModPlateau.plateau(height, random, rawHeight, this.minHeight, this.plateauHeight, this.maxHeight, this.heightExponent, this.limit);
    }

    public static int plateau(int height, Random random, double rawHeight, int minHeight, int plateauHeight, int maxHeight, double heightExponent, boolean limit) {
        int out = height;
        if (height >= minHeight && height <= plateauHeight) {
            int range = plateauHeight - minHeight;
            int diff = plateauHeight - height;
            double rdiff = (double)plateauHeight - rawHeight * 255.0;
            double factor = diff / range;
            factor = Math.pow(factor, heightExponent);
            double rfactor = rdiff / (double)range;
            rfactor = Math.pow(rfactor, heightExponent);
            double ffactor = Math.min(1.0, factor * 0.25 + rfactor * 0.75);
            out = (int)Math.round((double)plateauHeight - ffactor * (double)range);
        } else if (height <= maxHeight && height > plateauHeight) {
            int range = maxHeight - plateauHeight;
            int diff = height - plateauHeight;
            double rdiff = rawHeight * 255.0 - (double)plateauHeight;
            double factor = diff / range;
            factor = Math.pow(factor, heightExponent);
            double rfactor = rdiff / (double)range;
            rfactor = Math.pow(rfactor, heightExponent);
            double ffactor = Math.min(1.0, factor * 0.25 + rfactor * 0.75);
            out = (int)Math.round((double)plateauHeight + ffactor * (double)range);
        }
        if (out < minHeight && limit) {
            out = minHeight;
        } else if (out > maxHeight && limit) {
            out = maxHeight;
        }
        return out;
    }

    @Override
    public double noiseFactor() {
        return 1.0;
    }
}

