/*
 * Decompiled with CFR 0.152.
 */
package ttftcuts.atg.gen;

import java.util.Random;
import net.minecraft.world.World;
import ttftcuts.atg.api.IGenMod;

public class ATGGenModSquash
implements IGenMod {
    private int startHeight = 62;
    private int deltaHeight = 9;
    private double heightExponent = 3.0;

    public ATGGenModSquash() {
    }

    public ATGGenModSquash(int start, int height, double exponent) {
        this.startHeight = start;
        this.deltaHeight = height;
        this.heightExponent = exponent;
    }

    @Override
    public int modify(World world, int height, Random random, double rawHeight, int x, int z) {
        if (height > this.startHeight) {
            int aheight = height - this.startHeight;
            double rheight = rawHeight * 255.0 - (double)this.startHeight;
            double dfactor = rheight / (double)this.deltaHeight;
            dfactor = Math.pow(dfactor, this.heightExponent);
            double afactor = (double)aheight / (double)this.deltaHeight;
            afactor = Math.pow(afactor, this.heightExponent);
            double factor = Math.min(1.0, afactor * 0.75 + dfactor * 0.25);
            return (int)Math.floor((double)this.startHeight + factor * (double)this.deltaHeight);
        }
        return height;
    }

    @Override
    public double noiseFactor() {
        return 1.0;
    }
}

