/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.compat.immibis;

import buildcraft.api.blueprints.BuildingPermission;
import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.MappingRegistry;
import buildcraft.api.blueprints.Schematic;
import buildcraft.api.blueprints.SchematicTile;
import buildcraft.api.blueprints.Translation;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.IInvSlot;
import buildcraft.api.core.JavaTools;
import buildcraft.core.blueprints.SchematicRegistry;
import buildcraft.core.proxy.CoreProxy;
import java.util.ArrayList;
import java.util.LinkedList;
import mods.immibis.microblocks.api.EnumPosition;
import mods.immibis.microblocks.api.Part;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.WorldServer;

public class SchematicTileMicroblocks
extends SchematicTile {
    private final SchematicTile wrapped;
    private static final EnumPosition[] shiftMatrix = new EnumPosition[]{EnumPosition.Centre, EnumPosition.FaceNZ, EnumPosition.FacePZ, EnumPosition.FaceNY, EnumPosition.FacePY, EnumPosition.FacePX, EnumPosition.FaceNX, EnumPosition.EdgeNYNZ, EnumPosition.EdgePYNZ, EnumPosition.EdgeNYPZ, EnumPosition.EdgePYPZ, EnumPosition.EdgePXNZ, EnumPosition.EdgeNXNZ, EnumPosition.EdgePXPZ, EnumPosition.EdgeNXPZ, EnumPosition.EdgePXNY, EnumPosition.EdgeNXNY, EnumPosition.EdgePXPY, EnumPosition.EdgeNXPY, EnumPosition.CornerPXNYNZ, EnumPosition.CornerNXNYNZ, EnumPosition.CornerPXPYNZ, EnumPosition.CornerNXPYNZ, EnumPosition.CornerPXNYPZ, EnumPosition.CornerNXNYPZ, EnumPosition.CornerPXPYPZ, EnumPosition.CornerNXPYPZ, EnumPosition.PostZ, EnumPosition.PostY, EnumPosition.PostX};

    public SchematicTileMicroblocks(SchematicRegistry.SchematicConstructor c) {
        SchematicTile t = null;
        try {
            t = (SchematicTile)c.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.wrapped = t;
    }

    public ItemStack useItem(IBuilderContext context, ItemStack req, IInvSlot slot) {
        return this.wrapped.useItem(context, req, slot);
    }

    public void translateToBlueprint(Translation transform) {
        this.wrapped.translateToBlueprint(transform);
        this.tileNBT = this.wrapped.tileNBT;
    }

    public void translateToWorld(Translation transform) {
        this.wrapped.translateToWorld(transform);
        this.tileNBT = this.wrapped.tileNBT;
    }

    public void idsToBlueprint(MappingRegistry registry) {
        this.wrapped.idsToBlueprint(registry);
    }

    public void idsToWorld(MappingRegistry registry) {
        this.wrapped.idsToWorld(registry);
    }

    public void initializeFromObjectAt(IBuilderContext context, int x, int y, int z) {
        this.wrapped.block = this.block;
        this.wrapped.meta = this.meta;
        this.wrapped.defaultPermission = this.defaultPermission;
        this.wrapped.storedRequirements = this.storedRequirements;
        this.wrapped.tileNBT = this.tileNBT;
        this.wrapped.initializeFromObjectAt(context, x, y, z);
        this.block = this.wrapped.block;
        this.meta = this.wrapped.meta;
        this.defaultPermission = this.wrapped.defaultPermission;
        this.storedRequirements = this.wrapped.storedRequirements;
        this.tileNBT = this.wrapped.tileNBT;
    }

    public void placeInWorld(IBuilderContext context, int x, int y, int z, LinkedList<ItemStack> stacks) {
        this.wrapped.placeInWorld(context, x, y, z, stacks);
    }

    public void getRequirementsForPlacement(IBuilderContext context, LinkedList<ItemStack> requirements) {
        this.wrapped.getRequirementsForPlacement(context, requirements);
    }

    public int getEnergyRequirement(LinkedList<ItemStack> stacksUsed) {
        return this.wrapped.getEnergyRequirement(stacksUsed);
    }

    public LinkedList<ItemStack> getStacksToDisplay(LinkedList<ItemStack> stackConsumed) {
        return this.wrapped.getStacksToDisplay(stackConsumed);
    }

    public Schematic.BuildingStage getBuildStage() {
        return this.wrapped.getBuildStage();
    }

    public boolean isAlreadyBuilt(IBuilderContext context, int x, int y, int z) {
        return this.wrapped.isAlreadyBuilt(context, x, y, z);
    }

    public boolean doNotBuild() {
        return this.wrapped.doNotBuild();
    }

    public boolean doNotUse() {
        return this.wrapped.doNotUse();
    }

    public BuildingPermission getBuildingPermission() {
        return this.wrapped.getBuildingPermission();
    }

    public void postProcessing(IBuilderContext context, int x, int y, int z) {
        this.wrapped.postProcessing(context, x, y, z);
    }

    public void writeSchematicToNBT(NBTTagCompound nbt, MappingRegistry registry) {
        this.wrapped.writeSchematicToNBT(nbt, registry);
    }

    public void readSchematicFromNBT(NBTTagCompound nbt, MappingRegistry registry) {
        this.wrapped.readSchematicFromNBT(nbt, registry);
        this.block = this.wrapped.block;
        this.meta = this.wrapped.meta;
        this.defaultPermission = this.wrapped.defaultPermission;
        this.storedRequirements = this.wrapped.storedRequirements;
        this.tileNBT = this.wrapped.tileNBT;
    }

    public int buildTime() {
        return this.wrapped.buildTime();
    }

    public void storeRequirements(IBuilderContext context, int x, int y, int z) {
        this.wrapped.storeRequirements(context, x, y, z);
        this.storeMicroblockRequirements(context, x, y, z);
        this.storedRequirements = this.wrapped.storedRequirements;
    }

    protected void storeMicroblockRequirements(IBuilderContext context, int x, int y, int z) {
        NBTTagList list = this.getICMP(this.wrapped.tileNBT);
        if (list != null) {
            ArrayList<ItemStack> rqs = new ArrayList<ItemStack>();
            EntityPlayer fakePlayer = (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)context.world()).get();
            for (int i = 0; i < list.func_74745_c(); ++i) {
                Part part = Part.readFromNBT((NBTBase)list.func_150305_b(i));
                rqs.add(part.type.getDroppedStack(part, fakePlayer));
                System.out.println(part.type.getDroppedStack(part, fakePlayer).toString());
            }
            this.wrapped.storedRequirements = (ItemStack[])JavaTools.concat((Object[])this.wrapped.storedRequirements, (Object[])rqs.toArray(new ItemStack[rqs.size()]));
        }
    }

    public void rotateLeft(IBuilderContext context) {
        this.wrapped.rotateLeft(context);
        this.block = this.wrapped.block;
        this.meta = this.wrapped.meta;
        this.tileNBT = this.wrapped.tileNBT;
        NBTTagList list = this.getICMP(this.tileNBT);
        if (list != null) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound part = list.func_150305_b(i);
                part.func_74774_a("pos", (byte)shiftMatrix[part.func_74771_c("pos")].ordinal());
            }
        }
    }

    private NBTTagList getICMP(NBTTagCompound nbtInit) {
        if (nbtInit == null) {
            return null;
        }
        NBTTagCompound nbt = nbtInit;
        if (nbt.func_74764_b("ImmibisCoreMicroblocks")) {
            nbt = nbt.func_74775_l("ImmibisCoreMicroblocks");
        }
        return nbt.func_150295_c("ICMP", 10);
    }

    static {
        for (int a = 0; a < shiftMatrix.length; ++a) {
            int b = a;
            for (int i = 0; i < 4; ++i) {
                b = shiftMatrix[b].ordinal();
            }
            if (a == b) continue;
            BCLog.logger.error("[IMB Rotation Mapping] Location " + a + " returns to " + b + " instead! This should NOT happen!");
        }
    }
}

