/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.item;

import java.util.List;
import mekanism.api.EnumColor;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasItem;
import mekanism.common.item.ItemMekanism;
import mekanism.common.util.LangUtils;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ItemHohlraum
extends ItemMekanism
implements IGasItem {
    public static final int MAX_GAS = 10;
    public static final int TRANSFER_RATE = 1;

    public ItemHohlraum() {
        this.func_77625_d(1);
        this.func_77656_e(100);
        this.setNoRepair();
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        GasStack gasStack = this.getGas(itemstack);
        if (gasStack == null) {
            list.add(LangUtils.localize((String)"tooltip.noGas") + ".");
            list.add(EnumColor.DARK_RED + LangUtils.localize((String)"tooltip.insufficientFuel"));
        } else {
            list.add(LangUtils.localize((String)"tooltip.stored") + " " + gasStack.getGas().getLocalizedName() + ": " + gasStack.amount);
            if (gasStack.amount == this.getMaxGas(itemstack)) {
                list.add(EnumColor.DARK_GREEN + LangUtils.localize((String)"tooltip.readyForReaction") + "!");
            } else {
                list.add(EnumColor.DARK_RED + LangUtils.localize((String)"tooltip.insufficientFuel"));
            }
        }
    }

    public int getMaxGas(ItemStack itemstack) {
        return 10;
    }

    public int getRate(ItemStack itemstack) {
        return 1;
    }

    public int addGas(ItemStack itemstack, GasStack stack) {
        if (this.getGas(itemstack) != null && this.getGas(itemstack).getGas() != stack.getGas()) {
            return 0;
        }
        if (stack.getGas() != GasRegistry.getGas((String)"fusionFuelDT")) {
            return 0;
        }
        int toUse = Math.min(this.getMaxGas(itemstack) - this.getStored(itemstack), Math.min(this.getRate(itemstack), stack.amount));
        this.setGas(itemstack, new GasStack(stack.getGas(), this.getStored(itemstack) + toUse));
        return toUse;
    }

    public GasStack removeGas(ItemStack itemstack, int amount) {
        return null;
    }

    public int getStored(ItemStack itemstack) {
        return this.getGas(itemstack) != null ? this.getGas((ItemStack)itemstack).amount : 0;
    }

    public boolean canReceiveGas(ItemStack itemstack, Gas type) {
        return type == GasRegistry.getGas((String)"fusionFuelDT");
    }

    public boolean canProvideGas(ItemStack itemstack, Gas type) {
        return false;
    }

    public GasStack getGas(ItemStack itemstack) {
        if (itemstack.field_77990_d == null) {
            return null;
        }
        GasStack stored = GasStack.readFromNBT((NBTTagCompound)itemstack.field_77990_d.func_74775_l("stored"));
        if (stored == null) {
            itemstack.func_77964_b(100);
        } else {
            itemstack.func_77964_b((int)Math.max(1.0f, Math.abs((float)stored.amount / (float)this.getMaxGas(itemstack) * 100.0f - 100.0f)));
        }
        return stored;
    }

    public boolean isMetadataSpecific(ItemStack itemStack) {
        return false;
    }

    public void setGas(ItemStack itemstack, GasStack stack) {
        if (itemstack.field_77990_d == null) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        if (stack == null || stack.amount == 0) {
            itemstack.func_77964_b(100);
            itemstack.field_77990_d.func_82580_o("stored");
        } else {
            int amount = Math.max(0, Math.min(stack.amount, this.getMaxGas(itemstack)));
            GasStack gasStack = new GasStack(stack.getGas(), amount);
            itemstack.func_77964_b((int)Math.max(1.0f, Math.abs((float)amount / (float)this.getMaxGas(itemstack) * 100.0f - 100.0f)));
            itemstack.field_77990_d.func_74782_a("stored", (NBTBase)gasStack.write(new NBTTagCompound()));
        }
    }

    public ItemStack getEmptyItem() {
        ItemStack stack = new ItemStack((Item)this);
        this.setGas(stack, null);
        stack.func_77964_b(100);
        return stack;
    }

    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        ItemStack empty = new ItemStack((Item)this);
        this.setGas(empty, null);
        empty.func_77964_b(100);
        list.add(empty);
        ItemStack filled = new ItemStack((Item)this);
        this.setGas(filled, new GasStack(GasRegistry.getGas((String)"fusionFuelDT"), ((IGasItem)filled.func_77973_b()).getMaxGas(filled)));
        list.add(filled);
    }
}

