/*
 * Decompiled with CFR 0.152.
 */
package extracells.gui;

import appeng.api.AEApi;
import appeng.api.config.RedstoneMode;
import extracells.container.ContainerBusFluidIO;
import extracells.gui.widget.WidgetRedstoneModes;
import extracells.gui.widget.fluid.WidgetFluidSlot;
import extracells.integration.Integration;
import extracells.network.packet.other.IFluidSlotGui;
import extracells.network.packet.part.PacketBusFluidIO;
import extracells.part.PartFluidIO;
import extracells.part.PartGasImport;
import extracells.util.FluidUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class GuiBusFluidIO
extends GuiContainer
implements WidgetFluidSlot.IConfigurable,
IFluidSlotGui {
    private static final ResourceLocation guiTexture = new ResourceLocation("extracells", "textures/gui/busiofluid.png");
    private PartFluidIO part;
    private EntityPlayer player;
    private byte filterSize;
    private List<WidgetFluidSlot> fluidSlotList = new ArrayList<WidgetFluidSlot>();
    private boolean redstoneControlled;
    private boolean hasNetworkTool;

    public GuiBusFluidIO(PartFluidIO _terminal, EntityPlayer _player) {
        super((Container)new ContainerBusFluidIO(_terminal, _player));
        ((ContainerBusFluidIO)this.field_147002_h).setGui(this);
        this.part = _terminal;
        this.player = _player;
        this.fluidSlotList.add(new WidgetFluidSlot(this.player, this.part, 0, 61, 21, this, 2));
        this.fluidSlotList.add(new WidgetFluidSlot(this.player, this.part, 1, 79, 21, this, 1));
        this.fluidSlotList.add(new WidgetFluidSlot(this.player, this.part, 2, 97, 21, this, 2));
        this.fluidSlotList.add(new WidgetFluidSlot(this.player, this.part, 3, 61, 39, this, 1));
        this.fluidSlotList.add(new WidgetFluidSlot(this.player, this.part, 4, 79, 39, this, 0));
        this.fluidSlotList.add(new WidgetFluidSlot(this.player, this.part, 5, 97, 39, this, 1));
        this.fluidSlotList.add(new WidgetFluidSlot(this.player, this.part, 6, 61, 57, this, 2));
        this.fluidSlotList.add(new WidgetFluidSlot(this.player, this.part, 7, 79, 57, this, 1));
        this.fluidSlotList.add(new WidgetFluidSlot(this.player, this.part, 8, 97, 57, this, 2));
        new PacketBusFluidIO(this.player, this.part).sendPacketToServer();
        this.hasNetworkTool = this.field_147002_h.func_75138_a().size() > 40;
        this.field_146999_f = this.hasNetworkTool ? 246 : 211;
        this.field_147000_g = 184;
    }

    public void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        new PacketBusFluidIO(this.player, (byte)button.field_146127_k, this.part).sendPacketToServer();
    }

    public void changeConfig(byte _filterSize) {
        this.filterSize = _filterSize;
    }

    protected void func_146976_a(float alpha, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(guiTexture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, 176, 184);
        this.func_73729_b(this.field_147003_i + 179, this.field_147009_r, 179, 0, 32, 86);
        if (this.hasNetworkTool) {
            this.func_73729_b(this.field_147003_i + 179, this.field_147009_r + 93, 178, 93, 68, 68);
        }
        for (Object s : this.field_147002_h.field_75151_b) {
            this.renderBackground((Slot)s);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        boolean overlayRendered = false;
        for (int i = 0; i < 9; i = (int)((byte)(i + 1))) {
            this.fluidSlotList.get(i).drawWidget();
            if (overlayRendered || !this.fluidSlotList.get(i).canRender()) continue;
            overlayRendered = this.renderOverlay(this.fluidSlotList.get(i), mouseX, mouseY);
        }
        for (Object button : this.field_146292_n) {
            if (!(button instanceof WidgetRedstoneModes)) continue;
            ((WidgetRedstoneModes)((Object)button)).drawTooltip(mouseX, mouseY, (this.field_146294_l - this.field_146999_f) / 2, (this.field_146295_m - this.field_147000_g) / 2);
        }
    }

    @Override
    public byte getConfigState() {
        return this.filterSize;
    }

    protected Slot func_146975_c(int p_146975_1_, int p_146975_2_) {
        for (int k = 0; k < this.field_147002_h.field_75151_b.size(); ++k) {
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(k);
            if (!this.isMouseOverSlot(slot, p_146975_1_, p_146975_2_)) continue;
            return slot;
        }
        return null;
    }

    private boolean isMouseOverSlot(Slot p_146981_1_, int p_146981_2_, int p_146981_3_) {
        return this.func_146978_c(p_146981_1_.field_75223_e, p_146981_1_.field_75221_f, 16, 16, p_146981_2_, p_146981_3_);
    }

    protected boolean isPointInRegion(int top, int left, int height, int width, int pointX, int pointY) {
        int k1 = this.field_147003_i;
        int l1 = this.field_147009_r;
        return (pointX -= k1) >= top - 1 && pointX < top + height + 1 && (pointY -= l1) >= left - 1 && pointY < left + width + 1;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseBtn) {
        Slot slot = this.func_146975_c(mouseX, mouseY);
        if (slot != null && slot.func_75211_c() != null && slot.func_75211_c().func_77969_a((ItemStack)AEApi.instance().definitions().items().networkTool().maybeStack(1).get())) {
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseBtn);
        for (WidgetFluidSlot fluidSlot : this.fluidSlotList) {
            if (!this.isPointInRegion(fluidSlot.getPosX(), fluidSlot.getPosY(), 18, 18, mouseX, mouseY)) continue;
            if (this.part instanceof PartGasImport && Integration.Mods.MEKANISMGAS.isEnabled()) {
                fluidSlot.mouseClickedGas(this.player.field_71071_by.func_70445_o());
                break;
            }
            fluidSlot.mouseClicked(this.player.field_71071_by.func_70445_o());
            break;
        }
    }

    private void renderBackground(Slot slot) {
        if (slot.func_75211_c() == null && (slot.field_75222_d < 4 || slot.field_75222_d > 39)) {
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("appliedenergistics2", "textures/guis/states.png"));
            this.func_73729_b(this.field_147003_i + slot.field_75223_e, this.field_147009_r + slot.field_75221_f, 240, 208, 16, 16);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2896);
        }
    }

    public boolean renderOverlay(WidgetFluidSlot fluidSlot, int mouseX, int mouseY) {
        if (this.isPointInRegion(fluidSlot.getPosX(), fluidSlot.getPosY(), 18, 18, mouseX, mouseY)) {
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            this.func_73733_a(fluidSlot.getPosX() + 1, fluidSlot.getPosY() + 1, fluidSlot.getPosX() + 17, fluidSlot.getPosY() + 17, -2130706433, -2130706433);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            return true;
        }
        return false;
    }

    public void setRedstoneControlled(boolean _redstoneControlled) {
        this.redstoneControlled = _redstoneControlled;
        this.field_146292_n.clear();
        if (this.redstoneControlled) {
            this.field_146292_n.add(new WidgetRedstoneModes(0, this.field_147003_i - 18, this.field_147009_r, 16, 16, this.part.getRedstoneMode()));
        }
    }

    public boolean shiftClick(ItemStack itemStack) {
        FluidStack containerFluid = FluidUtil.getFluidFromContainer(itemStack);
        Fluid fluid = containerFluid == null ? null : containerFluid.getFluid();
        for (WidgetFluidSlot fluidSlot : this.fluidSlotList) {
            if (!fluidSlot.canRender() || fluid == null || fluidSlot.getFluid() != null && fluidSlot.getFluid() != fluid) continue;
            fluidSlot.mouseClicked(itemStack);
            return true;
        }
        return false;
    }

    @Override
    public void updateFluids(List<Fluid> fluidList) {
        for (int i = 0; i < this.fluidSlotList.size() && i < fluidList.size(); ++i) {
            this.fluidSlotList.get(i).setFluid(fluidList.get(i));
        }
    }

    public void updateRedstoneMode(RedstoneMode mode) {
        if (this.redstoneControlled && this.field_146292_n.size() > 0) {
            ((WidgetRedstoneModes)((Object)this.field_146292_n.get(0))).setRedstoneMode(mode);
        }
    }
}

