/*
 * Decompiled with CFR 0.152.
 */
package extracells.network.packet.part;

import appeng.api.AEApi;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import extracells.container.ContainerFluidTerminal;
import extracells.gui.GuiFluidTerminal;
import extracells.network.AbstractPacket;
import extracells.part.PartFluidTerminal;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class PacketFluidTerminal
extends AbstractPacket {
    IItemList<IAEFluidStack> fluidStackList;
    Fluid currentFluid;
    PartFluidTerminal terminalFluid;

    public PacketFluidTerminal() {
    }

    public PacketFluidTerminal(EntityPlayer _player, Fluid _currentFluid) {
        super(_player);
        this.mode = (byte)2;
        this.currentFluid = _currentFluid;
    }

    public PacketFluidTerminal(EntityPlayer _player, Fluid _currentFluid, PartFluidTerminal _terminalFluid) {
        super(_player);
        this.mode = 1;
        this.currentFluid = _currentFluid;
        this.terminalFluid = _terminalFluid;
    }

    public PacketFluidTerminal(EntityPlayer _player, IItemList<IAEFluidStack> _list) {
        super(_player);
        this.mode = 0;
        this.fluidStackList = _list;
    }

    public PacketFluidTerminal(EntityPlayer _player, PartFluidTerminal _terminalFluid) {
        super(_player);
        this.mode = (byte)3;
        this.terminalFluid = _terminalFluid;
    }

    @Override
    public void execute() {
        switch (this.mode) {
            case 0: {
                GuiScreen gui;
                if (this.player == null || !this.player.func_70613_aW() || !((gui = Minecraft.func_71410_x().field_71462_r) instanceof GuiFluidTerminal)) break;
                ContainerFluidTerminal container = (ContainerFluidTerminal)((GuiFluidTerminal)gui).field_147002_h;
                container.updateFluidList(this.fluidStackList);
                break;
            }
            case 1: {
                this.terminalFluid.setCurrentFluid(this.currentFluid);
                break;
            }
            case 2: {
                if (this.player == null || !(Minecraft.func_71410_x().field_71462_r instanceof GuiFluidTerminal)) break;
                GuiFluidTerminal gui = (GuiFluidTerminal)Minecraft.func_71410_x().field_71462_r;
                ((ContainerFluidTerminal)gui.getContainer()).receiveSelectedFluid(this.currentFluid);
                break;
            }
            case 3: {
                if (this.player == null || !(this.player.field_71070_bA instanceof ContainerFluidTerminal)) break;
                ContainerFluidTerminal fluidContainer = (ContainerFluidTerminal)this.player.field_71070_bA;
                fluidContainer.forceFluidUpdate();
                this.terminalFluid.sendCurrentFluid(fluidContainer);
            }
        }
    }

    @Override
    public void readData(ByteBuf in) {
        switch (this.mode) {
            case 0: {
                this.fluidStackList = AEApi.instance().storage().createFluidList();
                while (in.readableBytes() > 0) {
                    Fluid fluid = PacketFluidTerminal.readFluid(in);
                    long fluidAmount = in.readLong();
                    if (fluid == null || fluidAmount <= 0L) continue;
                    IAEFluidStack stack = AEApi.instance().storage().createFluidStack(new FluidStack(fluid, 1));
                    stack.setStackSize(fluidAmount);
                    this.fluidStackList.add((IAEStack)stack);
                }
                break;
            }
            case 1: {
                this.terminalFluid = (PartFluidTerminal)PacketFluidTerminal.readPart(in);
                this.currentFluid = PacketFluidTerminal.readFluid(in);
                break;
            }
            case 2: {
                this.currentFluid = PacketFluidTerminal.readFluid(in);
                break;
            }
            case 3: {
                this.terminalFluid = (PartFluidTerminal)PacketFluidTerminal.readPart(in);
            }
        }
    }

    @Override
    public void writeData(ByteBuf out) {
        switch (this.mode) {
            case 0: {
                for (IAEFluidStack stack : this.fluidStackList) {
                    FluidStack fluidStack = stack.getFluidStack();
                    PacketFluidTerminal.writeFluid(fluidStack.getFluid(), out);
                    out.writeLong((long)fluidStack.amount);
                }
                break;
            }
            case 1: {
                PacketFluidTerminal.writePart(this.terminalFluid, out);
                PacketFluidTerminal.writeFluid(this.currentFluid, out);
                break;
            }
            case 2: {
                PacketFluidTerminal.writeFluid(this.currentFluid, out);
                break;
            }
            case 3: {
                PacketFluidTerminal.writePart(this.terminalFluid, out);
            }
        }
    }
}

