/*
 * Decompiled with CFR 0.152.
 */
package extracells.util;

import appeng.api.AEApi;
import appeng.api.storage.data.IAEFluidStack;
import extracells.integration.mekanism.Mekanism;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.apache.commons.lang3.tuple.MutablePair;

public class GasUtil {
    public static IAEFluidStack createAEFluidStack(Gas gas) {
        return GasUtil.createAEFluidStack(new FluidStack(Mekanism.getFluidGasMap().get(gas), 1000));
    }

    public static IAEFluidStack createAEFluidStack(FluidStack fluid) {
        return AEApi.instance().storage().createFluidStack(fluid);
    }

    public static IAEFluidStack createAEFluidStack(Gas gas, long amount) {
        return (IAEFluidStack)GasUtil.createAEFluidStack(new FluidStack(Mekanism.getFluidGasMap().get(gas), 1)).setStackSize(amount);
    }

    public static MutablePair<Integer, ItemStack> drainStack(ItemStack itemStack, GasStack gas) {
        if (itemStack == null) {
            return null;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof IGasItem) {
            GasStack drained = ((IGasItem)item).removeGas(itemStack, gas.amount);
            int amountDrained = drained != null && drained.getGas() == gas.getGas() ? drained.amount : 0;
            return new MutablePair((Object)amountDrained, (Object)itemStack);
        }
        return null;
    }

    public static MutablePair<Integer, ItemStack> fillStack(ItemStack itemStack, GasStack gas) {
        if (itemStack == null) {
            return null;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof IGasItem) {
            int filled = ((IGasItem)item).addGas(itemStack, gas);
            return new MutablePair((Object)filled, (Object)itemStack);
        }
        return null;
    }

    public static int getCapacity(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            return ((IFluidContainerItem)item).getCapacity(itemStack);
        }
        if (FluidContainerRegistry.isEmptyContainer((ItemStack)itemStack)) {
            for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
                if (data == null || !data.emptyContainer.func_77969_a(itemStack)) continue;
                FluidStack interior = data.fluid;
                return interior != null ? interior.amount : 0;
            }
        }
        return 0;
    }

    public static GasStack getGasFromContainer(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        ItemStack container = itemStack.func_77946_l();
        Item item = container.func_77973_b();
        if (item instanceof IGasItem) {
            return ((IGasItem)item).getGas(itemStack);
        }
        return null;
    }

    public static boolean isEmpty(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof IGasItem) {
            GasStack content = ((IGasItem)item).getGas(itemStack);
            return content == null || content.amount <= 0;
        }
        return false;
    }

    public static boolean isFilled(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            FluidStack content = ((IFluidContainerItem)item).getFluid(itemStack);
            return content != null && content.amount > 0;
        }
        return FluidContainerRegistry.isFilledContainer((ItemStack)itemStack);
    }

    public static boolean isGasContainer(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        Item item = itemStack.func_77973_b();
        return item instanceof IGasItem;
    }

    public static GasStack getGasStack(FluidStack fluidStack) {
        if (fluidStack == null) {
            return null;
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid instanceof Mekanism.GasFluid) {
            return new GasStack(((Mekanism.GasFluid)fluid).getGas(), fluidStack.amount);
        }
        return null;
    }

    public static FluidStack getFluidStack(GasStack gasStack) {
        if (gasStack == null) {
            return null;
        }
        Fluid fluid = Mekanism.getFluidGasMap().get(gasStack.getGas());
        if (fluid == null) {
            return null;
        }
        return new FluidStack(fluid, gasStack.amount);
    }

    public boolean isGas(FluidStack fluidStack) {
        return fluidStack != null && this.isGas(fluidStack.getFluid());
    }

    public boolean isGas(Fluid fluid) {
        return fluid != null && fluid instanceof Mekanism.GasFluid;
    }
}

