/*
 * Decompiled with CFR 0.152.
 */
package toast.specialAI.ai;

import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityAIAttackOnCollidePassive
extends EntityAIAttackOnCollide {
    private final EntityCreature attacker;
    private final World worldObj;
    private final boolean avoidsWater;
    private final double speedTowardsTarget;
    private final boolean longMemory;
    private final Class classTarget;
    private int attackTick;
    private PathEntity entityPath;
    private int pathDelay;
    private int failedPathPenalty;

    public EntityAIAttackOnCollidePassive(EntityCreature entity, double speed, boolean mem) {
        this(entity, null, speed, mem);
    }

    public EntityAIAttackOnCollidePassive(EntityCreature entity, Class targetType, double speed, boolean mem) {
        super(entity, targetType, speed, mem);
        this.attacker = entity;
        this.worldObj = entity.field_70170_p;
        this.avoidsWater = entity.func_70661_as().func_75486_a();
        this.speedTowardsTarget = speed;
        this.longMemory = mem;
        this.classTarget = targetType;
    }

    public boolean func_75250_a() {
        EntityLivingBase target = this.attacker.func_70638_az();
        if (target == null) {
            return false;
        }
        if (!target.func_70089_S()) {
            return false;
        }
        if (this.classTarget != null && !this.classTarget.isAssignableFrom(target.getClass())) {
            return false;
        }
        if (--this.pathDelay <= 0) {
            this.entityPath = this.attacker.func_70661_as().func_75494_a((Entity)target);
            this.pathDelay = 4 + this.attacker.func_70681_au().nextInt(7);
            return this.entityPath != null;
        }
        return true;
    }

    public void func_75249_e() {
        super.func_75249_e();
        this.attacker.func_70661_as().func_75491_a(false);
        this.pathDelay = 0;
    }

    public void func_75246_d() {
        EntityLivingBase target = this.attacker.func_70638_az();
        this.attacker.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
        if ((this.longMemory || this.attacker.func_70635_at().func_75522_a((Entity)target)) && --this.pathDelay <= 0) {
            this.pathDelay = this.failedPathPenalty + 4 + this.attacker.func_70681_au().nextInt(7);
            this.attacker.func_70661_as().func_75497_a((Entity)target, this.speedTowardsTarget);
            if (this.attacker.func_70661_as().func_75505_d() != null) {
                PathPoint finalPathPoint = this.attacker.func_70661_as().func_75505_d().func_75870_c();
                float minDistance = this.attacker.field_70130_N + target.field_70130_N;
                this.failedPathPenalty = finalPathPoint != null && target.func_70092_e((double)finalPathPoint.field_75839_a, (double)finalPathPoint.field_75837_b, (double)finalPathPoint.field_75838_c) < (double)(minDistance * minDistance) ? 0 : (this.failedPathPenalty += 10);
            } else {
                this.failedPathPenalty += 10;
            }
        }
        this.attackTick = Math.max(this.attackTick - 1, 0);
        double range = this.attacker.field_70130_N * 2.0f * this.attacker.field_70130_N * 2.0f + target.field_70130_N;
        if (this.attacker.func_70092_e(target.field_70165_t, target.field_70121_D.field_72338_b, target.field_70161_v) <= range && this.attackTick <= 0) {
            this.attackTick = 20;
            this.attackEntityAsMob(target);
        }
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.attacker.func_70661_as().func_75491_a(this.avoidsWater);
    }

    private boolean attackEntityAsMob(EntityLivingBase target) {
        float damage;
        try {
            damage = (float)this.attacker.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        }
        catch (Exception ex) {
            damage = this.attacker instanceof EntitySheep ? 2.0f : (this.attacker instanceof EntityChicken ? 1.0f : (this.attacker instanceof EntityCow ? 4.0f : 3.0f));
        }
        int knockback = EnchantmentHelper.func_77507_b((EntityLivingBase)this.attacker, (EntityLivingBase)target);
        if (target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.attacker), damage += EnchantmentHelper.func_77512_a((EntityLivingBase)this.attacker, (EntityLivingBase)target))) {
            if (knockback > 0) {
                target.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.attacker.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.attacker.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f));
                this.attacker.field_70159_w *= 0.6;
                this.attacker.field_70179_y *= 0.6;
            }
            int fire = EnchantmentHelper.func_90036_a((EntityLivingBase)this.attacker) << 2;
            if (this.attacker.func_70027_ad()) {
                fire += 2;
            }
            if (fire > 0) {
                target.func_70015_d(fire);
            }
            EnchantmentHelper.func_151384_a((EntityLivingBase)target, (Entity)this.attacker);
            EnchantmentHelper.func_151385_b((EntityLivingBase)this.attacker, (Entity)target);
            return true;
        }
        return false;
    }
}

