/*
 * Decompiled with CFR 0.152.
 */
package toast.specialAI.ai;

import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockOre;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.init.Blocks;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import toast.specialAI.Properties;
import toast.specialAI.ai.GriefSearch;
import toast.specialAI.ai.SearchHandler;
import toast.specialAI.util.BlockHelper;
import toast.specialAI.util.TargetBlock;

public class EntityAIGriefBlocks
extends EntityAIBase {
    private static final boolean NEEDS_TOOL = Properties.getBoolean("passive_griefing", "requires_tools");
    private static final boolean BREAK_LIGHTS = Properties.getBoolean("passive_griefing", "break_lights");
    private static final boolean BREAK_SOUND = Properties.getBoolean("passive_griefing", "break_sound");
    private static final HashSet<TargetBlock> TARGET_BLOCKS = BlockHelper.newBlockSet(Properties.getString("passive_griefing", "target_blocks"));
    private static final HashSet<TargetBlock> BLACKLIST = BlockHelper.newBlockSet(Properties.getString("passive_griefing", "target_blacklist"));
    private static final boolean LEAVE_DROPS = Properties.getBoolean("passive_griefing", "leave_drops");
    private static final boolean MAD_CREEPERS = Properties.getBoolean("passive_griefing", "mad_creepers");
    private static final float REACH = (float)(Properties.getDouble("passive_griefing", "grief_range") * Properties.getDouble("passive_griefing", "grief_range"));
    private static final int DELAY = Math.max(1, Properties.getInt("passive_griefing", "grief_delay"));
    protected EntityLiving theEntity;
    public boolean needsTool;
    public boolean breakLights;
    private HashSet<TargetBlock> targetBlocks;
    private HashSet<TargetBlock> blacklist;
    private boolean canSee;
    private int sightCounter;
    private int giveUpDelay;
    private int blockX;
    private int blockY;
    private int blockZ;
    private Block targetBlock;
    private int hitCounter;
    private float blockDamage;
    private GriefSearch search;

    public EntityAIGriefBlocks(EntityLiving entity, byte tool, byte lights, String nbtTargetBlocks, String nbtBlacklist) {
        this.theEntity = entity;
        this.needsTool = tool >= 0 ? tool > 0 : NEEDS_TOOL;
        this.breakLights = lights >= 0 ? lights > 0 : BREAK_LIGHTS;
        if (nbtTargetBlocks != null) {
            this.targetBlocks = BlockHelper.newBlockSet(nbtTargetBlocks);
        }
        if (nbtBlacklist != null) {
            this.blacklist = BlockHelper.newBlockSet(nbtBlacklist);
        }
        this.func_75248_a(3);
    }

    public HashSet<TargetBlock> getTargetBlocks() {
        if (this.targetBlocks == null) {
            return TARGET_BLOCKS;
        }
        return this.targetBlocks;
    }

    public HashSet<TargetBlock> getBlacklist() {
        if (this.blacklist == null) {
            return BLACKLIST;
        }
        return this.blacklist;
    }

    public boolean func_75250_a() {
        if (this.theEntity.field_70154_o == null && this.theEntity.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
            if (this.targetBlock != null) {
                if (this.theEntity.field_70170_p.func_147439_a(this.blockX, this.blockY, this.blockZ) == this.targetBlock) {
                    return true;
                }
                this.targetBlock = null;
            }
            if (this.search == null) {
                if (this.theEntity.func_70681_au().nextInt(DELAY) == 0) {
                    this.search = SearchHandler.addScanner(new GriefSearch(this, this.theEntity));
                }
            } else if (!this.search.isValid()) {
                SearchHandler.removeScanner(this.search);
                this.cancelSearch();
            }
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.theEntity.field_70154_o == null && (this.blockDamage > 0.0f || this.giveUpDelay < 400) && this.theEntity.field_70170_p.func_147439_a(this.blockX, this.blockY, this.blockZ) == this.targetBlock;
    }

    public boolean func_75252_g() {
        return !MAD_CREEPERS || !(this.theEntity instanceof EntityCreeper) || this.blockDamage == 0.0f;
    }

    public void func_75249_e() {
        this.canSee = false;
        this.blockDamage = 0.0f;
        this.hitCounter = 0;
        this.theEntity.func_70661_as().func_75492_a((double)this.blockX, (double)this.blockY, (double)this.blockZ, 1.0);
    }

    public void func_75246_d() {
        super.func_75246_d();
        this.theEntity.func_70671_ap().func_75650_a((double)this.blockX, (double)this.blockY, (double)this.blockZ, 30.0f, 30.0f);
        if (this.canSee) {
            if (MAD_CREEPERS && this.theEntity instanceof EntityCreeper) {
                ((EntityCreeper)this.theEntity).func_70829_a(1);
                this.blockDamage = 1.0f;
            } else {
                if (this.hitCounter == 0) {
                    this.theEntity.func_71038_i();
                    this.theEntity.field_70170_p.func_72956_a((Entity)this.theEntity, this.targetBlock.field_149762_H.func_150495_a(), this.targetBlock.field_149762_H.func_150497_c(), this.targetBlock.field_149762_H.func_150494_d() * 0.8f);
                }
                if (++this.hitCounter >= 5) {
                    this.hitCounter = 0;
                }
                this.theEntity.func_70661_as().func_75499_g();
                this.blockDamage += BlockHelper.getDamageAmount(this.targetBlock, this.theEntity, this.theEntity.field_70170_p, this.blockX, this.blockY, this.blockZ);
                if (this.blockDamage >= 1.0f) {
                    if (this.targetBlock == Blocks.field_150458_ak) {
                        this.theEntity.field_70170_p.func_147465_d(this.blockX, this.blockY, this.blockZ, Blocks.field_150346_d, 0, 3);
                    } else {
                        if (LEAVE_DROPS) {
                            Block block = this.theEntity.field_70170_p.func_147439_a(this.blockX, this.blockY, this.blockZ);
                            int meta = this.theEntity.field_70170_p.func_72805_g(this.blockX, this.blockY, this.blockZ);
                            block.func_149697_b(this.theEntity.field_70170_p, this.blockX, this.blockY, this.blockZ, meta, 0);
                        }
                        this.theEntity.field_70170_p.func_147468_f(this.blockX, this.blockY, this.blockZ);
                        if (BREAK_SOUND) {
                            this.theEntity.field_70170_p.func_72926_e(1012, this.blockX, this.blockY, this.blockZ, 0);
                        }
                        this.theEntity.field_70170_p.func_72926_e(2001, this.blockX, this.blockY, this.blockZ, Block.func_149682_b((Block)this.targetBlock));
                        this.theEntity.func_71038_i();
                    }
                    this.blockDamage = 0.0f;
                }
                this.theEntity.field_70170_p.func_147443_d(this.theEntity.func_145782_y(), this.blockX, this.blockY, this.blockZ, (int)(this.blockDamage * 10.0f) - 1);
            }
        } else {
            if (this.sightCounter-- <= 0 && this.checkSight()) {
                this.sightCounter = 10;
            }
            if (++this.giveUpDelay > 400) {
                this.theEntity.func_70661_as().func_75499_g();
            } else if (this.theEntity.func_70661_as().func_75500_f()) {
                this.theEntity.func_70661_as().func_75492_a((double)this.blockX, (double)this.blockY, (double)this.blockZ, 1.0);
            }
        }
    }

    private boolean checkSight() {
        double x = (double)this.blockX + 0.5;
        double y = (double)this.blockY + 0.5;
        double z = (double)this.blockZ + 0.5;
        if (this.theEntity.func_70092_e(x, y - (double)this.theEntity.func_70047_e(), z) <= (double)REACH) {
            Vec3 posVec = Vec3.func_72443_a((double)this.theEntity.field_70165_t, (double)(this.theEntity.field_70163_u + (double)this.theEntity.func_70047_e()), (double)this.theEntity.field_70161_v);
            if (this.checkSight(posVec, x, y + (this.theEntity.field_70163_u > y ? 0.5 : -0.5), z) || this.checkSight(posVec, x + (this.theEntity.field_70165_t > x ? 0.5 : -0.5), y, z) || this.checkSight(posVec, x, y, z + (this.theEntity.field_70161_v > z ? 0.5 : -0.5))) {
                this.canSee = true;
            }
            return true;
        }
        return false;
    }

    private boolean checkSight(Vec3 posVec, double x, double y, double z) {
        Vec3 targetVec = Vec3.func_72443_a((double)x, (double)y, (double)z);
        MovingObjectPosition target = this.theEntity.field_70170_p.func_72933_a(posVec, targetVec);
        return target == null || this.blockY == target.field_72312_c && this.blockX == target.field_72311_b && this.blockZ == target.field_72309_d || this.checkCollided(target.field_72311_b, target.field_72312_c, target.field_72309_d);
    }

    private boolean checkCollided(int x, int y, int z) {
        Block block = this.theEntity.field_70170_p.func_147439_a(x, y, z);
        if (this.isValidTarget(block, x, y, z)) {
            this.targetBlock(block, x, y, z);
            return true;
        }
        return false;
    }

    private boolean isValidTarget(Block block, int x, int y, int z) {
        TargetBlock targetBlock = new TargetBlock(block, this.theEntity.field_70170_p.func_72805_g(x, y, z));
        if (block != null && block != Blocks.field_150350_a && !this.getBlacklist().contains(targetBlock) && (this.breakLights && block.func_149750_m() > 1 && !(block instanceof BlockLiquid) && !(block instanceof BlockFire) && block != Blocks.field_150439_ay && !(block instanceof BlockOre) || this.getTargetBlocks().contains(targetBlock))) {
            return BlockHelper.shouldDamage(block, this.theEntity, this.needsTool, this.theEntity.field_70170_p, x, y, z);
        }
        return false;
    }

    public void func_75251_c() {
        this.blockDamage = 0.0f;
        this.giveUpDelay = 0;
        this.targetBlock = null;
        this.theEntity.func_70661_as().func_75499_g();
        if (MAD_CREEPERS && this.theEntity instanceof EntityCreeper) {
            ((EntityCreeper)this.theEntity).func_70829_a(-1);
        } else {
            this.theEntity.field_70170_p.func_147443_d(this.theEntity.func_145782_y(), this.blockX, this.blockY, this.blockZ, -1);
        }
    }

    public void cancelSearch() {
        this.search = null;
    }

    public void targetBlock(Block block, int x, int y, int z) {
        this.blockX = x;
        this.blockY = y;
        this.blockZ = z;
        this.targetBlock = block;
    }
}

