/*
 * Decompiled with CFR 0.152.
 */
package toast.specialAI.ai;

import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockOre;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import toast.specialAI.Properties;
import toast.specialAI.ai.EntityAIGriefBlocks;
import toast.specialAI.ai.SearchHandler;
import toast.specialAI.util.BlockHelper;
import toast.specialAI.util.TargetBlock;

public class GriefSearch {
    private static final int SCAN_RANGE = Math.max(0, Properties.getInt("passive_griefing", "grief_scan_range"));
    private static final double RESCAN_LIMIT = (double)(SCAN_RANGE * SCAN_RANGE) / 4.0;
    private final EntityAIGriefBlocks AI;
    private final EntityLiving ENTITY;
    private final int POS_X;
    private final int POS_Y;
    private final int POS_Z;
    private final byte DIRECTION;
    private final int START_HEIGHT;
    private final int END_HEIGHT;
    public boolean complete;
    private int blockX;
    private int blockY;
    private int blockZ;
    private Block targetBlock;
    private int radius;
    private int offset;
    private byte position;
    private int height;

    public GriefSearch(EntityAIGriefBlocks ai, EntityLiving entity) {
        this.AI = ai;
        this.ENTITY = entity;
        this.POS_X = (int)Math.floor(entity.field_70165_t);
        this.POS_Y = (int)Math.floor(entity.field_70163_u);
        this.POS_Z = (int)Math.floor(entity.field_70161_v);
        this.DIRECTION = (byte)(this.ENTITY.func_70681_au().nextBoolean() ? -1 : 1);
        this.START_HEIGHT = Math.max(0, Math.min(255, this.POS_Y - SCAN_RANGE * this.DIRECTION));
        this.END_HEIGHT = Math.max(0, Math.min(255, this.POS_Y + (SCAN_RANGE + 1) * this.DIRECTION));
        this.height = this.START_HEIGHT;
    }

    public boolean isValid() {
        return this.ENTITY.func_70089_S() && this.ENTITY.func_70092_e((double)this.POS_X + 0.5, (double)this.POS_Y + 0.5, (double)this.POS_Z + 0.5) <= RESCAN_LIMIT;
    }

    public void clear() {
        this.AI.cancelSearch();
    }

    public void runSearch() {
        do {
            this.checkNext();
        } while (!this.complete && --SearchHandler.scansLeft > 0);
        if (this.complete && this.targetBlock != null) {
            this.AI.targetBlock(this.targetBlock, this.blockX, this.blockY, this.blockZ);
        }
    }

    private void checkNext() {
        if (this.radius == 0) {
            if (this.checkCoords(this.POS_X, this.POS_Z)) {
                return;
            }
            ++this.radius;
            this.offset = -this.radius;
        }
        while (this.radius <= SCAN_RANGE) {
            while (this.offset <= this.radius) {
                while (this.position < 4) {
                    if (this.position < 2) {
                        if (this.checkCoords(this.POS_X + (this.position == 1 ? this.radius : -this.radius), this.POS_Z + this.offset)) {
                            return;
                        }
                    } else {
                        if (this.offset == -this.radius || this.offset == this.radius) break;
                        if (this.checkCoords(this.POS_X + this.offset, this.POS_Z + (this.position == 3 ? this.radius : -this.radius))) {
                            return;
                        }
                    }
                    this.position = (byte)(this.position + 1);
                }
                ++this.offset;
                this.position = 0;
            }
            ++this.radius;
            this.offset = -this.radius;
        }
        this.complete = true;
    }

    private boolean checkCoords(int x, int z) {
        while (this.height != this.END_HEIGHT) {
            Block block = this.ENTITY.field_70170_p.func_147439_a(x, this.height, z);
            if (this.tryTargetBlock(block, x, this.height, z)) {
                this.height += this.DIRECTION;
                return true;
            }
            this.height += this.DIRECTION;
        }
        this.height = this.START_HEIGHT;
        return false;
    }

    private boolean tryTargetBlock(Block block, int x, int y, int z) {
        if (block == null || block instanceof BlockLiquid || !BlockHelper.shouldDamage(block, this.ENTITY, this.AI.needsTool, this.ENTITY.field_70170_p, x, y, z)) {
            return false;
        }
        TargetBlock targetBlock = new TargetBlock(block, this.ENTITY.field_70170_p.func_72805_g(x, y, z));
        if (this.AI.getBlacklist().contains(targetBlock)) {
            return false;
        }
        if (this.AI.breakLights && block.func_149750_m() > 1 && !(block instanceof BlockFire) && block != Blocks.field_150439_ay && !(block instanceof BlockOre)) {
            this.targetBlock(block, x, y, z);
            return true;
        }
        if (this.AI.getTargetBlocks().contains(targetBlock)) {
            this.targetBlock(block, x, y, z);
        }
        return true;
    }

    private void targetBlock(Block block, int x, int y, int z) {
        this.complete = true;
        this.blockX = x;
        this.blockY = y;
        this.blockZ = z;
        this.targetBlock = block;
    }
}

