/*
 * Decompiled with CFR 0.152.
 */
package com.temportalist.origin.internal.common.network.handler;

import com.temportalist.origin.foundation.common.network.IPacket;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLIndexedMessageToMessageCodec;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;

public class Network
extends FMLIndexedMessageToMessageCodec<IPacket> {
    private static final Map<String, Network> TRACKER = new HashMap<String, Network>();
    private static final Map<Class<? extends IPacket>, String> packetToChannel = new HashMap<Class<? extends IPacket>, String>();
    public final String channel;
    public EnumMap<Side, FMLEmbeddedChannel> channels;

    public static boolean registerHandler(String modid, List<Class<? extends IPacket>> packetClasses) {
        return Network.registerHandler(modid, packetClasses.toArray(new Class[0]));
    }

    public static boolean registerHandler(String modid, Class<? extends IPacket> ... packetClasses) {
        if (!TRACKER.containsKey(modid.toLowerCase())) {
            Network handler = new Network(modid, packetClasses);
            for (Class<? extends IPacket> packet : packetClasses) {
                packetToChannel.put(packet, modid);
            }
            handler.channels = NetworkRegistry.INSTANCE.newChannel(modid.toLowerCase(), new ChannelHandler[]{handler});
            PacketExecuter executer = new PacketExecuter();
            for (Map.Entry<Side, FMLEmbeddedChannel> e : handler.channels.entrySet()) {
                FMLEmbeddedChannel channel = e.getValue();
                String codec = channel.findChannelHandlerNameForType(Network.class);
                channel.pipeline().addAfter(codec, "PacketExecuter", (ChannelHandler)executer);
            }
            TRACKER.put(modid.toLowerCase(), handler);
            return true;
        }
        throw new UnsupportedOperationException("There is already a channel/handler for key/channel " + modid.toLowerCase());
    }

    public static boolean sendToClients(IPacket packet) {
        String channel = Network.getChannel(packet.getClass());
        if (TRACKER.containsKey(channel.toLowerCase())) {
            EnumMap<Side, FMLEmbeddedChannel> channels = Network.TRACKER.get((Object)channel.toLowerCase()).channels;
            channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
            channels.get(Side.SERVER).writeAndFlush((Object)packet);
            return true;
        }
        return false;
    }

    public static boolean sendToPlayer(IPacket packet, EntityPlayer player) {
        String channel = Network.getChannel(packet.getClass());
        if (TRACKER.containsKey(channel.toLowerCase())) {
            EnumMap<Side, FMLEmbeddedChannel> channels = Network.TRACKER.get((Object)channel.toLowerCase()).channels;
            channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
            channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
            channels.get(Side.SERVER).writeAndFlush((Object)packet);
            return true;
        }
        return false;
    }

    public static boolean sendToAllAround(IPacket packet, NetworkRegistry.TargetPoint point) {
        String channel = Network.getChannel(packet.getClass());
        if (TRACKER.containsKey(channel.toLowerCase())) {
            EnumMap<Side, FMLEmbeddedChannel> channels = Network.TRACKER.get((Object)channel.toLowerCase()).channels;
            channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
            channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
            channels.get(Side.SERVER).writeAndFlush((Object)packet);
            return true;
        }
        return false;
    }

    public static boolean sendToDimension(IPacket packet, int dimension) {
        String channel = Network.getChannel(packet.getClass());
        if (TRACKER.containsKey(channel.toLowerCase())) {
            EnumMap<Side, FMLEmbeddedChannel> channels = Network.TRACKER.get((Object)channel.toLowerCase()).channels;
            channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
            channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimension);
            channels.get(Side.SERVER).writeAndFlush((Object)packet);
            return true;
        }
        return false;
    }

    public static boolean sendToServer(IPacket packet) {
        String channel = Network.getChannel(packet.getClass());
        if (TRACKER.containsKey(channel.toLowerCase())) {
            EnumMap<Side, FMLEmbeddedChannel> channels = Network.TRACKER.get((Object)channel.toLowerCase()).channels;
            channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
            channels.get(Side.CLIENT).writeAndFlush((Object)packet);
            return true;
        }
        return false;
    }

    public static void sendToServerAndClients(IPacket packet) {
        Network.sendToServer(packet);
        Network.sendToClients(packet);
    }

    public static String getChannel(Class<? extends IPacket> packet) {
        if (!packetToChannel.containsKey(packet)) {
            throw new NoSuchElementException("Packet type " + packet.getCanonicalName() + " is not registered! This is an issue!");
        }
        return packetToChannel.get(packet);
    }

    private Network(String pluginID, Class<? extends IPacket> ... packetClasses) {
        this.channel = pluginID.toLowerCase();
        ArrayList<Class<? extends IPacket>> list = new ArrayList<Class<? extends IPacket>>();
        for (int i = 0; i < packetClasses.length; ++i) {
            if (!list.contains(packetClasses[i])) {
                list.add(packetClasses[i]);
            } else {
                System.out.println("Channel " + this.channel + " has already registered message/packet class " + packetClasses[i].getSimpleName());
            }
            this.addDiscriminator(i, packetClasses[i]);
        }
    }

    public void encodeInto(ChannelHandlerContext ctx, IPacket msg, ByteBuf target) throws Exception {
        try {
            msg.toBytes(target);
        }
        catch (Exception e) {
            System.out.println("Error writing to packet for channel: " + this.channel);
            e.printStackTrace();
        }
    }

    public void decodeInto(ChannelHandlerContext ctx, ByteBuf source, IPacket msg) {
        try {
            msg.fromBytes(source);
        }
        catch (Exception e) {
            System.out.println("Error reading from packet for channel: " + this.channel);
            e.printStackTrace();
        }
    }

    @ChannelHandler.Sharable
    private static class PacketExecuter
    extends SimpleChannelInboundHandler<IPacket> {
        private PacketExecuter() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, IPacket msg) throws Exception {
            EntityPlayer player;
            Side side = FMLCommonHandler.instance().getEffectiveSide();
            if (side.isServer()) {
                INetHandler netHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
                player = ((NetHandlerPlayServer)netHandler).field_147369_b;
            } else {
                player = this.getClientPlayer();
            }
            if (side.isClient()) {
                msg.handleOnClient(player);
            } else if (side.isServer()) {
                msg.handleOnServer(player);
            }
        }

        @SideOnly(value=Side.CLIENT)
        public EntityPlayer getClientPlayer() {
            return Minecraft.func_71410_x().field_71439_g;
        }
    }
}

