/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.soundfilters;

import com.tmtravlr.soundfilters.SoundFiltersMod;
import com.tmtravlr.soundfilters.SoundTickHandler;
import com.tmtravlr.soundfilters.filters.BaseFilter;
import com.tmtravlr.soundfilters.filters.FilterException;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.sound.sampled.AudioFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.crash.CrashReport;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ReportedException;
import paulscode.sound.FilenameURL;
import paulscode.sound.SoundBuffer;
import paulscode.sound.Source;
import paulscode.sound.libraries.ChannelLWJGLOpenAL;
import paulscode.sound.libraries.SourceLWJGLOpenAL;

public class ModifiedLWJGLOpenALSource
extends SourceLWJGLOpenAL {
    public ModifiedLWJGLOpenALSource(FloatBuffer listenerPosition, IntBuffer myBuffer, Source old, SoundBuffer soundBuffer) {
        super(listenerPosition, myBuffer, old, soundBuffer);
    }

    public ModifiedLWJGLOpenALSource(FloatBuffer listenerPosition, IntBuffer myBuffer, boolean priority, boolean toStream, boolean toLoop, String sourcename, FilenameURL filenameURL, SoundBuffer soundBuffer, float x, float y, float z, int attModel, float distOrRoll, boolean temporary) {
        super(listenerPosition, myBuffer, priority, toStream, toLoop, sourcename, filenameURL, soundBuffer, x, y, z, attModel, distOrRoll, temporary);
    }

    public ModifiedLWJGLOpenALSource(FloatBuffer listenerPosition, AudioFormat audioFormat, boolean priority, String sourcename, float x, float y, float z, int attModel, float distOrRoll) {
        super(listenerPosition, audioFormat, priority, sourcename, x, y, z, attModel, distOrRoll);
    }

    public boolean stopped() {
        boolean stopped = super.stopped();
        if (this.channel != null && this.channel.attachedSource == this && !stopped && !this.paused()) {
            this.updateFilters();
        }
        return stopped;
    }

    private void updateFilters() {
        ChannelLWJGLOpenAL alChannel = (ChannelLWJGLOpenAL)this.channel;
        if (alChannel != null && alChannel.ALSource != null && this.position != null) {
            boolean isMusic;
            Minecraft mc = Minecraft.func_71410_x();
            boolean bl = isMusic = this.toStream && this.position.x == 0.0f && this.position.y == 0.0f && this.position.z == 0.0f && this.attModel == 0;
            if (!isMusic && mc != null && mc.field_71441_e != null) {
                boolean isOccluded = false;
                SoundTickHandler.DoubleWithTimeout sAndD = new SoundTickHandler.DoubleWithTimeout(null, 0.0, 10);
                if (SoundFiltersMod.doOcclusion && this.position != null) {
                    SoundTickHandler.ComparablePosition sourcePosition = new SoundTickHandler.ComparablePosition(this.position.x, this.position.y, this.position.z);
                    if (SoundTickHandler.sourceOcclusionMap.containsKey(sourcePosition)) {
                        sAndD = SoundTickHandler.sourceOcclusionMap.get(sourcePosition);
                        sAndD.timeout = 10;
                        sAndD.source = this;
                    } else {
                        SoundTickHandler.sourceOcclusionMap.put(sourcePosition, sAndD);
                    }
                    isOccluded = sAndD.amount > 0.05;
                }
                SoundFiltersMod.lowPassFilter.gain = SoundTickHandler.baseLowPassGain;
                SoundFiltersMod.lowPassFilter.gainHF = SoundTickHandler.baseLowPassGainHF;
                if (isOccluded && this.attModel != 0) {
                    SoundFiltersMod.lowPassFilter.gain = (float)((double)SoundFiltersMod.lowPassFilter.gain * (1.0 - 1.0 * sAndD.amount));
                    SoundFiltersMod.lowPassFilter.gainHF = (float)((double)SoundFiltersMod.lowPassFilter.gainHF * (1.0 - 1.0 * (double)MathHelper.func_76133_a((double)sAndD.amount)));
                }
                if (SoundFiltersMod.lowPassFilter.gain >= 1.0f && SoundFiltersMod.lowPassFilter.gainHF >= 1.0f) {
                    SoundFiltersMod.lowPassFilter.disable();
                } else {
                    SoundFiltersMod.lowPassFilter.enable();
                    SoundFiltersMod.lowPassFilter.loadParameters();
                }
                if (SoundFiltersMod.reverbFilter.reflectionsDelay <= 0.0f && SoundFiltersMod.reverbFilter.lateReverbDelay <= 0.0f) {
                    SoundFiltersMod.reverbFilter.disable();
                } else {
                    SoundFiltersMod.reverbFilter.enable();
                    SoundFiltersMod.reverbFilter.loadParameters();
                }
                try {
                    BaseFilter.loadSourceFilter(alChannel.ALSource.get(0), 131077, SoundFiltersMod.lowPassFilter);
                    BaseFilter.load3SourceFilters(alChannel.ALSource.get(0), 131078, SoundFiltersMod.reverbFilter, null, SoundFiltersMod.lowPassFilter);
                }
                catch (FilterException e) {
                    CrashReport crashreport = CrashReport.func_85055_a((Throwable)e, (String)"Updating Sound Filters");
                    throw new ReportedException(crashreport);
                }
            }
            SoundFiltersMod.lowPassFilter.disable();
            SoundFiltersMod.reverbFilter.disable();
            try {
                BaseFilter.loadSourceFilter(alChannel.ALSource.get(0), 131077, null);
                BaseFilter.load3SourceFilters(alChannel.ALSource.get(0), 131078, null, null, null);
            }
            catch (FilterException e) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)e, (String)"Updating Sound Filters");
                throw new ReportedException(crashreport);
            }
        }
    }
}

