/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.blocks;

import com.InfinityRaider.AgriCraft.AgriCraft;
import com.InfinityRaider.AgriCraft.blocks.BlockModPlant;
import com.InfinityRaider.AgriCraft.compatibility.ModIntegration;
import com.InfinityRaider.AgriCraft.compatibility.applecore.AppleCoreHelper;
import com.InfinityRaider.AgriCraft.farming.GrowthRequirements;
import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import com.InfinityRaider.AgriCraft.items.ItemDebugger;
import com.InfinityRaider.AgriCraft.tileentity.TileEntityCrop;
import com.InfinityRaider.AgriCraft.utility.SeedHelper;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tconstruct.items.tools.Scythe;
import tconstruct.library.tools.AbilityHelper;
import vazkii.botania.api.item.IGrassHornExcempt;

@Optional.Interface(modid="Botania", iface="vazkii.botania.api.item.IGrassHornExcempt")
public class BlockCrop
extends BlockModPlant
implements ITileEntityProvider,
IGrowable,
IGrassHornExcempt {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] weedIcons;

    public BlockCrop() {
        super(Blocks.field_150458_ak, null, null, 0, 0, 6);
        this.field_149758_A = true;
        this.field_149755_E = 0.875;
        this.field_149759_B = 0.125;
        this.field_149757_G = this.field_149755_E;
        this.field_149754_D = this.field_149759_B;
        this.field_149756_F = 0.8125;
        this.field_149760_C = 0.0;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityCrop();
    }

    @Override
    public void func_149674_a(World world, int x, int y, int z, Random rnd) {
        TileEntityCrop crop = (TileEntityCrop)world.func_147438_o(x, y, z);
        if (crop.hasPlant()) {
            int meta;
            Event.Result allowGrowthResult = AppleCoreHelper.validateGrowthTick((Block)this, world, x, y, z, rnd);
            if (allowGrowthResult != Event.Result.DENY && (meta = this.getPlantMetadata((IBlockAccess)world, x, y, z)) < 7 && crop.isFertile()) {
                boolean shouldGrow;
                double multiplier = 1.0 + ((double)crop.growth + 0.0) / 10.0;
                float growthRate = SeedHelper.getBaseGrowth(crop.seed, crop.seedMeta);
                boolean bl = shouldGrow = rnd.nextDouble() <= (double)growthRate * multiplier / 100.0;
                if (shouldGrow) {
                    world.func_72921_c(x, y, z, ++meta, 2);
                    AppleCoreHelper.announceGrowthTick((Block)this, world, x, y, z);
                }
            }
        } else if (crop.weed) {
            Event.Result allowGrowthResult = AppleCoreHelper.validateGrowthTick((Block)this, world, x, y, z, rnd);
            if (allowGrowthResult != Event.Result.DENY) {
                int meta = this.getPlantMetadata((IBlockAccess)world, x, y, z);
                if (meta < 7) {
                    boolean shouldGrow;
                    double multiplier = 2.0;
                    float growthRate = 50.0f;
                    boolean bl = shouldGrow = rnd.nextDouble() <= (double)growthRate * multiplier / 100.0;
                    if (shouldGrow) {
                        world.func_72921_c(x, y, z, ++meta, 2);
                        AppleCoreHelper.announceGrowthTick((Block)this, world, x, y, z);
                    }
                } else if (ConfigurationHandler.enableWeeds) {
                    crop.spreadWeed();
                }
            }
        } else if (ConfigurationHandler.enableWeeds && Math.random() < 0.1) {
            crop.spawnWeed();
        } else if (crop.crossCrop) {
            crop.crossOver();
        }
    }

    public boolean harvest(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            boolean update = false;
            TileEntityCrop crop = (TileEntityCrop)world.func_147438_o(x, y, z);
            if (crop.weed) {
                crop.clearWeed();
            } else if (crop.crossCrop) {
                crop.crossCrop = false;
                this.func_149642_a(world, x, y, z, new ItemStack((Item)com.InfinityRaider.AgriCraft.init.Items.crops, 1));
                update = true;
            } else if (crop.isMature()) {
                crop.func_145831_w().func_72921_c(crop.field_145851_c, crop.field_145848_d, crop.field_145849_e, 2, 2);
                update = true;
                ArrayList<ItemStack> drops = SeedHelper.getPlantFruits(crop.seed, world, x, y, z, crop.gain, crop.seedMeta);
                for (ItemStack drop : drops) {
                    this.func_149642_a(world, x, y, z, drop);
                }
            }
            if (update) {
                crop.markForUpdate();
            }
            return update;
        }
        return false;
    }

    public void setCrossCrop(World world, int x, int y, int z, EntityPlayer player) {
        if (!world.field_72995_K) {
            boolean update = false;
            TileEntityCrop crop = (TileEntityCrop)world.func_147438_o(x, y, z);
            if (crop.weed) {
                return;
            }
            if (!crop.crossCrop && !crop.hasPlant()) {
                crop.crossCrop = true;
                player.func_71045_bC().field_77994_a = player.field_71075_bZ.field_75098_d ? player.func_71045_bC().field_77994_a : player.func_71045_bC().field_77994_a - 1;
                update = true;
            } else {
                this.harvest(world, x, y, z);
            }
            if (update) {
                crop.markForUpdate();
            }
        }
    }

    public void plantSeed(World world, int x, int y, int z, EntityPlayer player) {
        if (!world.field_72995_K) {
            TileEntityCrop crop = (TileEntityCrop)world.func_147438_o(x, y, z);
            if (crop.crossCrop || crop.hasPlant() || !(player.func_71045_bC().func_77973_b() instanceof ItemSeeds)) {
                return;
            }
            ItemStack stack = player.func_71045_bC();
            if (!SeedHelper.isValidSeed((ItemSeeds)stack.func_77973_b(), stack.func_77960_j()) || !GrowthRequirements.getGrowthRequirement((ItemSeeds)stack.func_77973_b(), stack.func_77960_j()).isValidSoil(world, x, y - 1, z)) {
                return;
            }
            if (player.func_71045_bC().field_77990_d != null && player.func_71045_bC().field_77990_d.func_74764_b("growth")) {
                crop.setPlant(stack.field_77990_d.func_74762_e("growth"), stack.field_77990_d.func_74762_e("gain"), stack.field_77990_d.func_74762_e("strength"), stack.field_77990_d.func_74767_n("analyzed"), (ItemSeeds)stack.func_77973_b(), stack.func_77960_j());
            } else {
                crop.setPlant(1, 1, 1, false, (ItemSeeds)stack.func_77973_b(), stack.func_77960_j());
            }
            player.func_71045_bC().field_77994_a = player.field_71075_bZ.field_75098_d ? player.func_71045_bC().field_77994_a : player.func_71045_bC().field_77994_a - 1;
            crop.markForUpdate();
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float fX, float fY, float fZ) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_147438_o(x, y, z)) != null && te instanceof TileEntityCrop) {
            TileEntityCrop crop = (TileEntityCrop)te;
            if (ConfigurationHandler.enableHandRake && crop.weed) {
                return false;
            }
            if (player.func_70093_af()) {
                this.harvest(world, x, y, z);
            } else if (player.func_71045_bC() == null) {
                this.harvest(world, x, y, z);
            } else {
                if (player.func_71045_bC().func_77973_b() == com.InfinityRaider.AgriCraft.init.Items.debugItem) {
                    return false;
                }
                if (player.func_71045_bC().func_77973_b() == com.InfinityRaider.AgriCraft.init.Items.crops) {
                    this.setCrossCrop(world, x, y, z, player);
                } else {
                    if (player.func_71045_bC().func_77973_b() == Items.field_151100_aR && player.func_71045_bC().func_77960_j() == 15) {
                        return false;
                    }
                    if (ModIntegration.LoadedMods.magicalCrops && ConfigurationHandler.integration_allowMagicFertiliser && player.func_71045_bC().func_77973_b() == Item.field_150901_e.func_82594_a("magicalcrops:magicalcrops_MagicalCropFertilizer")) {
                        return this.applyMagicalFertiliser(world, x, y, z, player);
                    }
                    if (player.func_71045_bC().func_77973_b() instanceof ItemDebugger) {
                        return false;
                    }
                    if (ModIntegration.LoadedMods.tconstruct && player.func_71045_bC().func_77973_b() instanceof Scythe) {
                        NBTTagCompound tag = player.func_71045_bC().field_77990_d;
                        if (tag == null || !tag.func_74764_b("InfiTool")) {
                            return true;
                        }
                        NBTTagCompound toolTag = tag.func_74775_l("InfiTool");
                        for (int xPos = x - 1; xPos <= x + 1; ++xPos) {
                            for (int zPos = z - 1; zPos <= z + 1 && !toolTag.func_74767_n("Broken"); ++zPos) {
                                if (!(world.func_147439_a(xPos, y, zPos) instanceof BlockCrop) || !this.harvest(world, xPos, y, zPos)) continue;
                                AbilityHelper.damageTool((ItemStack)player.func_71045_bC(), (int)1, (EntityLivingBase)player, (boolean)false);
                            }
                        }
                    } else {
                        this.harvest(world, x, y, z);
                        if (player.func_71045_bC().func_77973_b() instanceof ItemSeeds) {
                            this.plantSeed(world, x, y, z, player);
                        }
                    }
                }
            }
        }
        return true;
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        if (!world.field_72995_K) {
            if (!player.field_71075_bZ.field_75098_d) {
                this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            }
            world.func_147468_f(x, y, z);
            world.func_147475_p(x, y, z);
        }
    }

    public void func_149681_a(World world, int x, int y, int z, int meta, EntityPlayer player) {
        this.func_149699_a(world, x, y, z, player);
    }

    @Override
    public void func_149690_a(World world, int x, int y, int z, int meta, float f, int i) {
        TileEntityCrop crop;
        if (!world.field_72995_K && (crop = (TileEntityCrop)world.func_147438_o(x, y, z)) != null) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            if (crop.crossCrop) {
                drops.add(new ItemStack((Item)com.InfinityRaider.AgriCraft.init.Items.crops, 2));
            } else {
                drops.add(new ItemStack((Item)com.InfinityRaider.AgriCraft.init.Items.crops, 1));
                if (crop.hasPlant()) {
                    drops.add(crop.getSeedStack());
                    if (this.isMature(world, x, y, z)) {
                        drops.addAll(SeedHelper.getPlantFruits(crop.seed, world, x, y, z, crop.gain, crop.seedMeta));
                    }
                }
            }
            for (ItemStack drop : drops) {
                this.func_149642_a(world, x, y, z, drop);
            }
        }
    }

    public boolean func_149852_a(World world, Random rand, int x, int y, int z) {
        TileEntityCrop crop = (TileEntityCrop)world.func_147438_o(x, y, z);
        if (crop.crossCrop) {
            return ConfigurationHandler.bonemealMutation;
        }
        if (crop.hasPlant() && SeedHelper.getSeedTier(crop.seed, crop.seedMeta) < 4) {
            return !this.isMature(world, x, y, z);
        }
        return false;
    }

    public void func_149853_b(World world, Random rand, int x, int y, int z) {
        TileEntityCrop crop = (TileEntityCrop)world.func_147438_o(x, y, z);
        if (crop.hasPlant() && this.isFertile(world, x, y, z)) {
            super.func_149853_b(world, rand, x, y, z);
            crop.markForUpdate();
        } else if (crop.crossCrop && ConfigurationHandler.bonemealMutation) {
            crop.crossOver();
        }
    }

    private boolean applyMagicalFertiliser(World world, int x, int y, int z, EntityPlayer player) {
        boolean allow;
        TileEntityCrop crop = (TileEntityCrop)world.func_147438_o(x, y, z);
        boolean bl = allow = crop.hasPlant() && !crop.isMature() && crop.isFertile();
        if (allow) {
            if (ConfigurationHandler.integration_instantMagicFertiliser) {
                world.func_72921_c(x, y, z, 7, 2);
            } else {
                this.func_149853_b(world, world.field_73012_v, x, y, z);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                --player.func_71045_bC().field_77994_a;
            }
        }
        return allow;
    }

    @Override
    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
            world.func_147475_p(x, y, z);
        }
    }

    @Override
    public boolean func_149718_j(World world, int x, int y, int z) {
        return GrowthRequirements.isSoilValid(world, x, y - 1, z);
    }

    @Override
    public boolean isFertile(World world, int x, int y, int z) {
        return world.func_147438_o(x, y, z) != null && world.func_147438_o(x, y, z) instanceof TileEntityCrop && ((TileEntityCrop)world.func_147438_o(x, y, z)).isFertile();
    }

    @Override
    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (world.func_147438_o(x, y, z) != null && world.func_147438_o(x, y, z) instanceof TileEntityCrop) {
            TileEntityCrop crop = (TileEntityCrop)world.func_147438_o(x, y, z);
            if (crop.crossCrop) {
                items.add(new ItemStack((Item)com.InfinityRaider.AgriCraft.init.Items.crops, 2));
            } else {
                items.add(new ItemStack((Item)com.InfinityRaider.AgriCraft.init.Items.crops, 1));
            }
            if (crop.hasPlant()) {
                ItemStack seedStack = crop.getSeedStack().func_77946_l();
                items.add(seedStack);
                if (crop.isMature()) {
                    items.addAll(SeedHelper.getPlantFruits(crop.seed, crop.func_145831_w(), crop.field_145851_c, crop.field_145848_d, crop.field_145849_e, crop.gain, crop.seedMeta));
                }
            }
        }
        return items;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        super.func_149749_a(world, x, y, z, block, meta);
        world.func_147475_p(x, y, z);
    }

    public boolean canUproot(World world, int x, int y, int z) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_147438_o(x, y, z)) != null && te instanceof TileEntityCrop) {
            TileEntityCrop crop = (TileEntityCrop)te;
            if (crop.hasPlant()) {
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                if (crop.isMature()) {
                    drops.addAll(SeedHelper.getPlantFruits(crop.seed, world, x, y, z, crop.gain, crop.seedMeta));
                }
                drops.add(crop.getSeedStack());
                for (ItemStack drop : drops) {
                    this.func_149642_a(world, x, y, z, drop);
                }
            }
            crop.clearPlant();
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return com.InfinityRaider.AgriCraft.init.Items.crops;
    }

    @Override
    public int func_149645_b() {
        return AgriCraft.proxy.getRenderId(0);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int i) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.field_149761_L = reg.func_94245_a(this.func_149739_a().substring(this.func_149739_a().indexOf(46) + 1));
        this.weedIcons = new IIcon[4];
        for (int i = 0; i < this.weedIcons.length; ++i) {
            this.weedIcons[i] = reg.func_94245_a(this.func_149739_a().substring(this.func_149739_a().indexOf(46) + 1) + "WeedTexture" + (i + 1));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getWeedIcon(int meta) {
        int index = 0;
        switch (meta) {
            case 0: {
                index = 0;
                break;
            }
            case 1: {
                index = 0;
                break;
            }
            case 2: {
                index = 1;
                break;
            }
            case 3: {
                index = 1;
                break;
            }
            case 4: {
                index = 1;
                break;
            }
            case 5: {
                index = 2;
                break;
            }
            case 6: {
                index = 2;
                break;
            }
            case 7: {
                index = 3;
            }
        }
        return this.weedIcons[index];
    }

    public boolean func_149696_a(World world, int x, int y, int z, int id, int data) {
        super.func_149696_a(world, x, y, z, id, data);
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        return tileEntity != null && tileEntity.func_145842_c(id, data);
    }
}

