/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.compatibility.minetweaker;

import com.InfinityRaider.AgriCraft.blocks.BlockModPlant;
import com.InfinityRaider.AgriCraft.items.ItemModSeed;
import com.InfinityRaider.AgriCraft.utility.LogHelper;
import com.InfinityRaider.AgriCraft.utility.OreDictHelper;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.mc1710.item.MCItemStack;
import minetweaker.mc1710.oredict.MCOreDictEntry;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.agricraft.CropProduct")
public class CropProduct {
    @ZenMethod
    public static void add(IItemStack seed, IItemStack fruit, int weight) {
        boolean success;
        ItemStack seedToChange = MineTweakerMC.getItemStack((IItemStack)seed);
        ItemStack fruitToAdd = MineTweakerMC.getItemStack((IItemStack)fruit);
        String error = "Invalid Seed";
        boolean bl = success = seedToChange != null && seedToChange.func_77973_b() != null && seedToChange.func_77973_b() instanceof ItemModSeed;
        if (success) {
            BlockModPlant crop = ((ItemModSeed)seedToChange.func_77973_b()).getPlant();
            error = "This crop's fruits can't be changed";
            success = crop.canEdit();
            if (success) {
                MineTweakerAPI.apply((IUndoableAction)new AddAction(crop, fruitToAdd, weight));
            }
        }
        if (!success) {
            MineTweakerAPI.logError((String)("Adding fruit: '" + fruitToAdd.func_82833_r() + "' to '" + seedToChange.func_82833_r() + "' failed: " + error));
        }
    }

    @ZenMethod
    public static void remove(IItemStack seed, IItemStack fruit) {
        boolean success;
        ItemStack seedToChange = MineTweakerMC.getItemStack((IItemStack)seed);
        ItemStack fruitToRemove = MineTweakerMC.getItemStack((IItemStack)fruit);
        String error = "Invalid Seed";
        boolean bl = success = seedToChange != null && seedToChange.func_77973_b() != null && seedToChange.func_77973_b() instanceof ItemModSeed;
        if (success) {
            BlockModPlant crop = ((ItemModSeed)seedToChange.func_77973_b()).getPlant();
            error = "This crop's fruits can't be changed";
            success = crop.canEdit();
            if (success) {
                MineTweakerAPI.apply((IUndoableAction)new RemoveAction(crop, fruitToRemove));
            }
        }
        if (!success) {
            MineTweakerAPI.logError((String)("Removing fruit: '" + fruitToRemove.func_82833_r() + "' from '" + seedToChange.func_82833_r() + "' failed: " + error));
        }
    }

    private static class RemoveAction
    implements IUndoableAction {
        private BlockModPlant crop;
        private ItemStack fruit;
        private int weight;

        public RemoveAction(BlockModPlant crop, ItemStack fruit) {
            this.crop = crop;
            this.fruit = fruit.func_77946_l();
            this.fruit.field_77994_a = 1;
            this.weight = crop.products.getWeight(this.fruit);
        }

        public void apply() {
            this.crop.products.removeProduce(this.fruit);
            MCOreDictEntry ore = new MCOreDictEntry(this.fruitTag());
            ore.remove((IItemStack)new MCItemStack(this.fruit));
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            this.crop.products.addProduce(this.fruit, this.weight);
            String oreDictTag = this.fruitTag();
            LogHelper.debug("Registering " + this.fruit.func_82833_r() + " to the ore dictionary as " + oreDictTag);
            if (!OreDictHelper.hasOreId(this.fruit, oreDictTag)) {
                OreDictionary.registerOre((String)oreDictTag, (ItemStack)this.fruit);
            }
        }

        public String describe() {
            return "Removing fruit '" + this.fruit.func_82833_r() + "' from '" + this.crop.func_149739_a() + "'";
        }

        public String describeUndo() {
            return "Adding previously removed fruit'" + this.fruit.func_82833_r() + "' from '" + this.crop.func_149739_a() + "'";
        }

        public Object getOverrideKey() {
            return null;
        }

        private String fruitTag() {
            return this.crop.func_149739_a().substring(this.crop.func_149739_a().indexOf(58));
        }
    }

    private static class AddAction
    implements IUndoableAction {
        private BlockModPlant crop;
        private ItemStack fruit;
        private int weight;

        public AddAction(BlockModPlant crop, ItemStack fruitToAdd, int weight) {
            this.crop = crop;
            this.fruit = fruitToAdd.func_77946_l();
            this.fruit.field_77994_a = 1;
            this.weight = weight > 0 ? weight : 100;
        }

        public void apply() {
            this.crop.products.addProduce(this.fruit, this.weight);
            String oreDictTag = this.fruitTag();
            LogHelper.debug("Registering " + this.fruit.func_82833_r() + " to the ore dictionary as " + oreDictTag);
            if (!OreDictHelper.hasOreId(this.fruit, oreDictTag)) {
                OreDictionary.registerOre((String)oreDictTag, (ItemStack)this.fruit);
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            this.crop.products.removeProduce(this.fruit);
            MCOreDictEntry ore = new MCOreDictEntry(this.fruitTag());
            ore.remove((IItemStack)new MCItemStack(this.fruit));
        }

        public String describe() {
            return "Adding fruit: '" + this.fruit.func_82833_r() + "' to '" + this.crop.func_149739_a() + "' with weight " + this.weight;
        }

        public String describeUndo() {
            return "Removing previously added fruit'" + this.fruit.func_82833_r() + "' from '" + this.crop.func_149739_a() + "'";
        }

        public Object getOverrideKey() {
            return null;
        }

        private String fruitTag() {
            return this.crop.func_149739_a().substring(this.crop.func_149739_a().indexOf(58));
        }
    }
}

