/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.compatibility.minetweaker;

import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import com.InfinityRaider.AgriCraft.init.Recipes;
import com.InfinityRaider.AgriCraft.items.ItemBlockCustomWood;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.agricraft.CustomWood")
public class CustomWood {
    @ZenMethod
    public static void addShaped(IItemStack output, IItemStack[][] inputs) {
        CustomWood.addRecipe(output, inputs, true);
    }

    @ZenMethod
    public static void addShapeless(IItemStack output, IItemStack[] inputs) {
        CustomWood.addRecipe(output, new IItemStack[][]{inputs}, false);
    }

    private static void addRecipe(IItemStack output, IItemStack[][] inputs, boolean shaped) {
        if (ConfigurationHandler.disableIrrigation) {
            MineTweakerAPI.logError((String)"Irrigation system disabled. Modifications to CustomWood recipes pointless.");
            return;
        }
        ItemStack outputStack = MineTweakerMC.getItemStack((IItemStack)output);
        if (outputStack.func_77973_b() instanceof ItemBlockCustomWood) {
            if (shaped && inputs.length != 3) {
                MineTweakerAPI.logError((String)"Unable to add recipe with input rows other than 3");
                return;
            }
            ArrayList<ItemStack> inputsConverted = new ArrayList<ItemStack>();
            IItemStack[][] arr$ = inputs;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                IItemStack[] input;
                for (IItemStack stack : input = arr$[i$]) {
                    inputsConverted.add(MineTweakerMC.getItemStack((IItemStack)stack));
                }
            }
            MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(outputStack, inputsConverted.toArray(new ItemStack[0]), shaped));
        } else {
            MineTweakerAPI.logError((String)(outputStack.func_82833_r() + " is not of type ItemBlockCustomWood."));
        }
    }

    @ZenMethod
    public static void remove(IItemStack output) {
        ItemStack itemStack = MineTweakerMC.getItemStack((IItemStack)output);
        if (itemStack.func_77973_b() instanceof ItemBlockCustomWood) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveRecipeAction(itemStack));
        } else {
            MineTweakerAPI.logError((String)(itemStack.func_82833_r() + " is not of type ItemBlockCustomWood."));
        }
    }

    private static class RemoveRecipeAction
    implements IUndoableAction {
        private final ItemStack output;
        private final List<IRecipe> removedRecipes = new ArrayList<IRecipe>();

        public RemoveRecipeAction(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            List recipes = CraftingManager.func_77594_a().func_77592_b();
            Iterator iter = recipes.iterator();
            while (iter.hasNext()) {
                IRecipe recipe = (IRecipe)iter.next();
                if (recipe.func_77571_b() == null || !this.output.func_77969_a(recipe.func_77571_b())) continue;
                this.removedRecipes.add(recipe);
                iter.remove();
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            CraftingManager.func_77594_a().func_77592_b().addAll(this.removedRecipes);
        }

        public String describe() {
            return "Removing CustomWood recipe for " + this.output.func_82833_r();
        }

        public String describeUndo() {
            return "Undoing removal of CustomWood recipe for " + this.output.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddRecipeAction
    implements IUndoableAction {
        private final ItemStack outputStack;
        private final ItemStack[] inputs;
        private final boolean shaped;

        public AddRecipeAction(ItemStack outputStack, ItemStack[] inputs, boolean shaped) {
            this.outputStack = outputStack;
            this.inputs = inputs;
            this.shaped = shaped;
        }

        public void apply() {
            ShapedRecipes recipe = this.shaped ? new ShapedRecipes(3, 3, this.inputs, this.outputStack) : new ShapelessRecipes(this.outputStack, Arrays.asList(this.inputs));
            Recipes.registerCustomWoodRecipe((IRecipe)recipe);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            List recipes = CraftingManager.func_77594_a().func_77592_b();
            Iterator iter = recipes.iterator();
            while (iter.hasNext()) {
                IRecipe recipe = (IRecipe)iter.next();
                if (recipe.func_77571_b() == null || !this.outputStack.func_77969_a(recipe.func_77571_b())) continue;
                iter.remove();
            }
        }

        public String describe() {
            return "Adding CustomWood recipe for " + this.outputStack.func_82833_r();
        }

        public String describeUndo() {
            return "Undoing adding of CustomWood recipe for " + this.outputStack.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

