/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.farming;

import com.InfinityRaider.AgriCraft.blocks.BlockModPlant;
import com.InfinityRaider.AgriCraft.compatibility.ModIntegration;
import com.InfinityRaider.AgriCraft.compatibility.gardenstuff.GardenStuffHelper;
import com.InfinityRaider.AgriCraft.farming.GrowthRequirement;
import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import com.InfinityRaider.AgriCraft.utility.BlockWithMeta;
import com.InfinityRaider.AgriCraft.utility.IOHelper;
import com.InfinityRaider.AgriCraft.utility.ItemWithMeta;
import com.InfinityRaider.AgriCraft.utility.LogHelper;
import com.InfinityRaider.AgriCraft.utility.SeedHelper;
import com.jaquadro.minecraft.gardencontainers.block.BlockLargePot;
import com.jaquadro.minecraft.gardencore.block.tile.TileEntityGarden;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class GrowthRequirements {
    private static Map<ItemWithMeta, GrowthRequirement> overrides = new HashMap<ItemWithMeta, GrowthRequirement>();
    public static List<BlockWithMeta> defaultSoils = new ArrayList<BlockWithMeta>();
    static List<BlockWithMeta> soils = new ArrayList<BlockWithMeta>();

    public static boolean isSoilValid(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        BlockWithMeta soil = ModIntegration.LoadedMods.gardenStuff && block instanceof BlockLargePot ? GardenStuffHelper.getSoil((TileEntityGarden)world.func_147438_o(x, y, z)) : new BlockWithMeta(block, meta);
        return soils.contains(soil) || defaultSoils.contains(soil);
    }

    public static void init() {
        GrowthRequirements.registerSoils();
        GrowthRequirements.registerOverrides();
        GrowthRequirements.registerCustomEntries();
    }

    private static void registerSoils() {
        GrowthRequirements.addDefaultSoil(new BlockWithMeta(Blocks.field_150458_ak));
        if (ModIntegration.LoadedMods.forestry) {
            GrowthRequirements.addDefaultSoil(new BlockWithMeta((Block)Block.field_149771_c.func_82594_a("Forestry:soil"), 0));
        }
        if (ModIntegration.LoadedMods.gardenStuff) {
            GrowthRequirements.addDefaultSoil(new BlockWithMeta((Block)Block.field_149771_c.func_82594_a("GardenCore:garden_farmland"), 0));
        }
    }

    private static void registerOverrides() {
        GrowthRequirement netherWartReq = new GrowthRequirement.Builder().soil(new BlockWithMeta(Blocks.field_150425_aM)).brightnessRange(0, 8).build();
        overrides.put(new ItemWithMeta(Items.field_151075_bm, 0), netherWartReq);
    }

    private static void registerCustomEntries() {
        String[] data;
        for (String line : data = IOHelper.getLinesArrayFromData(ConfigurationHandler.readSoils())) {
            LogHelper.debug("parsing " + line);
            ItemStack stack = IOHelper.getStack(line);
            Block block = stack != null && stack.func_77973_b() instanceof ItemBlock ? ((ItemBlock)stack.func_77973_b()).field_150939_a : null;
            boolean success = block != null;
            String errorMsg = "Invalid block";
            if (success) {
                GrowthRequirements.addDefaultSoil(new BlockWithMeta(block, stack.func_77960_j()));
                continue;
            }
            LogHelper.info("Error when adding block to soil whitelist: " + errorMsg + " (line: " + line + ")");
        }
        LogHelper.info("Registered soil whitelist:");
        for (BlockWithMeta soil : soils) {
            LogHelper.info(" - " + Block.field_149771_c.func_148750_c((Object)soil.getBlock()) + ":" + soil.getMeta());
        }
    }

    public static void addAllToSoilWhitelist(Collection<? extends BlockWithMeta> list) {
        for (BlockWithMeta blockWithMeta : list) {
            GrowthRequirements.addDefaultSoil(blockWithMeta);
        }
    }

    public static void removeAllFromSoilWhitelist(Collection<? extends BlockWithMeta> list) {
        defaultSoils.removeAll(list);
    }

    public static GrowthRequirement getGrowthRequirement(ItemSeeds seed, int meta) {
        if (SeedHelper.getPlant(seed) instanceof BlockModPlant) {
            return ((BlockModPlant)SeedHelper.getPlant(seed)).getGrowthRequirement();
        }
        GrowthRequirement growthRequirement = overrides.get(new ItemWithMeta((Item)seed, meta));
        if (growthRequirement == null) {
            growthRequirement = new GrowthRequirement.Builder().build();
            overrides.put(new ItemWithMeta((Item)seed, meta), growthRequirement);
        }
        return growthRequirement;
    }

    public static void addSoil(BlockWithMeta block) {
        if (!soils.contains(block)) {
            soils.add(block);
        }
    }

    public static void addDefaultSoil(BlockWithMeta block) {
        if (!defaultSoils.contains(block)) {
            defaultSoils.add(block);
        }
    }
}

