/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.gui;

import com.InfinityRaider.AgriCraft.farming.GrowthRequirements;
import com.InfinityRaider.AgriCraft.farming.mutation.Mutation;
import com.InfinityRaider.AgriCraft.farming.mutation.MutationHandler;
import com.InfinityRaider.AgriCraft.items.ItemJournal;
import com.InfinityRaider.AgriCraft.utility.BlockWithMeta;
import com.InfinityRaider.AgriCraft.utility.IOHelper;
import com.InfinityRaider.AgriCraft.utility.RenderHelper;
import com.InfinityRaider.AgriCraft.utility.SeedHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class GuiJournal
extends GuiScreen {
    public static final ResourceLocation textureBackground = new ResourceLocation("AgriCraft".toLowerCase(), "textures/gui/journal/GuiJournalBackground.png");
    public static final ResourceLocation textureFrontPage = new ResourceLocation("AgriCraft".toLowerCase(), "textures/gui/journal/GuiJournalFrontPage.png");
    public static final ResourceLocation textureTableOfContents = new ResourceLocation("AgriCraft".toLowerCase(), "textures/gui/journal/GuiJournalTableOfContents.png");
    public static final ResourceLocation textureIntroduction = new ResourceLocation("AgriCraft".toLowerCase(), "textures/gui/journal/GuiJournalIntroduction.png");
    public static final ResourceLocation textureSeedPage = new ResourceLocation("AgriCraft".toLowerCase(), "textures/gui/journal/GuiJournalSeedPage.png");
    protected EntityPlayer player;
    protected ItemStack[] discoveredSeeds;
    protected ItemStack[][] discoveredParents;
    protected ItemStack[] discoveredCoParents;
    protected ItemStack[] discoveredMutations;
    protected ItemStack[] fruits;
    protected int currentPage = 0;
    protected final int standardPages = 2;
    private int xSize;
    private int ySize;
    private int guiLeft;
    private int guiTop;
    private final int black = 0x191616;
    private int textStart;
    protected IIcon[] plantIcons;
    protected IIcon seedIcon;
    protected IIcon[][] parentsIcons;
    protected IIcon[] coParentsIcons;
    protected IIcon[] mutationIcons;
    protected IIcon[] fruitIcons;
    protected List field_146292_n = new ArrayList();
    private static final String introduction = "Welcome to Agricultural farming, today I will teach you the basics of farming with crops. To start you will need to put 4 sticks in a crafting grid, this will make crops. These can be put on farmland and seeds can then be planted in them. You can also apply a second set of crops to an existing crop, this will create a cross-crop. If you plant two or more plants in crops adjacent to a cross-crop, there is a chance for a mutation to occur. \nIn this journal you can keep track of all your discovered crop mutations. To register a discovered seed, put the journal in a seed-analyser and then analyse the seed. This will reveal to you the properties of the seed as well as registering it in this journal. If you ever wish to copy the journal, put it in a crafting grid together with a blank book and quill.";

    public GuiJournal(EntityPlayer player) {
        this.player = player;
        int pageWidth = 128;
        this.xSize = pageWidth * 2;
        this.ySize = pageWidth * 3 / 2;
    }

    private void setDataFromNBT() {
        if (this.player.func_71045_bC() != null && this.player.func_71045_bC().field_77994_a > 0 && this.player.func_71045_bC().func_77973_b() instanceof ItemJournal && this.player.func_71045_bC().func_77942_o()) {
            NBTTagCompound tag = this.player.func_71045_bC().func_77978_p();
            if (tag.func_74764_b("discoveredSeeds")) {
                NBTTagList tagList = tag.func_150295_c("discoveredSeeds", 10);
                this.discoveredSeeds = new ItemStack[tagList.func_74745_c()];
                for (int i = 0; i < this.discoveredSeeds.length; ++i) {
                    this.discoveredSeeds[i] = ItemStack.func_77949_a((NBTTagCompound)tagList.func_150305_b(i));
                }
            } else {
                this.discoveredSeeds = new ItemStack[0];
            }
            if (tag.func_74764_b("currentPage")) {
                this.currentPage = tag.func_74765_d("currentPage");
            }
        }
    }

    protected void func_73864_a(int x, int y, int rightClick) {
        boolean flipPage = false;
        if (y > this.guiTop + 172 && y <= this.guiTop + 172 + 16 && rightClick == 0) {
            if (x > this.guiLeft + 221 && x <= this.guiLeft + 221 + 16) {
                if (this.currentPage < this.standardPages - 1) {
                    ++this.currentPage;
                    flipPage = true;
                } else if (this.discoveredSeeds != null && this.currentPage < this.discoveredSeeds.length + this.standardPages - 1) {
                    ++this.currentPage;
                    flipPage = true;
                }
            } else if (x > this.guiLeft + 19 && x <= this.guiLeft + 19 + 16 && this.currentPage > 0) {
                --this.currentPage;
                flipPage = true;
            }
        } else if (this.getSeedAtCoordinates(x, y) != null && this.getSeedAtCoordinates(x, y).func_77973_b() != null) {
            ItemStack seed = this.getSeedAtCoordinates(x, y);
            int page = this.getPage(seed);
            this.currentPage = page >= 0 ? page : this.currentPage;
            flipPage = true;
        }
        if (flipPage) {
            this.initPage(this.currentPage - 2);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - 16 - this.ySize) / 2;
        this.textStart = this.guiLeft + 29;
        this.setDataFromNBT();
    }

    private void initPage(int index) {
        this.field_146292_n = new ArrayList();
        if (this.currentPage >= 2) {
            this.getSeedTextures(index);
        }
    }

    public void func_73863_a(int x, int y, float opacity) {
        this.func_146278_c(0);
        switch (this.currentPage) {
            case 0: {
                this.drawTitleScreen();
                break;
            }
            case 1: {
                this.drawIntroduction();
                break;
            }
            default: {
                this.drawSeedPage(this.currentPage - 2);
            }
        }
        if (y > this.guiTop + 172 && y <= this.guiTop + 172 + 16) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(textureBackground);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            if (x > this.guiLeft + 221 && x <= this.guiLeft + 221 + 16) {
                this.func_73729_b(this.guiLeft + 223, this.guiTop + 178, 224, 239, 32, 17);
            } else if (x > this.guiLeft + 19 && x <= this.guiLeft + 19 + 16 && this.currentPage > 0) {
                this.func_73729_b(this.guiLeft + 1, this.guiTop + 178, 0, 239, 32, 17);
            }
            GL11.glEnable((int)2896);
        }
        this.drawTooltip(x, y);
    }

    private void drawTooltip(int x, int y) {
        String[] tooltip = new String[1];
        if (this.currentPage >= this.standardPages) {
            int xOffset;
            int index;
            ItemStack seed = this.getSeedAtCoordinates(x, y);
            if (seed != null && seed.func_77973_b() != null) {
                tooltip[0] = seed.func_82833_r();
            } else if (y > this.guiTop + 91 && y <= this.guiTop + 91 + 16 && (index = (int)Math.floor((float)(xOffset = x - this.guiLeft - 30) / 24.0f)) >= 0 && index < this.fruits.length && this.fruits[index] != null && this.fruits[index].func_77973_b() != null) {
                tooltip[0] = this.fruits[index].func_82833_r();
            }
        }
        if (tooltip[0] != null && !tooltip[0].equals("")) {
            List<String> list = Arrays.asList(tooltip);
            this.drawHoveringText(list, x, y, this.field_146289_q);
        }
    }

    private int getPage(ItemStack seed) {
        if (this.isSeedDiscovered(seed)) {
            for (int i = 0; i < this.discoveredSeeds.length; ++i) {
                if (this.discoveredSeeds[i].func_77973_b() != seed.func_77973_b() || this.discoveredSeeds[i].func_77960_j() != seed.func_77960_j()) continue;
                return i + 2;
            }
        }
        return -1;
    }

    private ItemStack getSeedAtCoordinates(int x, int y) {
        ItemStack output = null;
        if (this.currentPage >= this.standardPages) {
            int xOffset = this.guiLeft + 132;
            int yOffset = 20;
            int column = 0;
            if (x > xOffset && x <= xOffset + 16) {
                column = 1;
            } else if (x > xOffset + 35 && x <= xOffset + 35 + 16) {
                column = 2;
            } else if (x > xOffset + 69 && x <= xOffset + 69 + 16) {
                column = 3;
            }
            if (column > 0) {
                int correctedY = y - 1 - this.guiTop - yOffset;
                int arrayIndex = (int)Math.floor((float)correctedY / 20.0f);
                if (arrayIndex >= 0 && arrayIndex < this.discoveredParents.length) {
                    output = column == 3 ? this.discoveredSeeds[this.currentPage - 2] : this.discoveredParents[arrayIndex][column - 1];
                } else if (arrayIndex >= this.discoveredParents.length && arrayIndex < this.discoveredParents.length + this.discoveredCoParents.length) {
                    switch (column) {
                        case 1: {
                            output = this.discoveredSeeds[this.currentPage - 2];
                            break;
                        }
                        case 2: {
                            output = this.discoveredCoParents[arrayIndex - this.discoveredParents.length];
                            break;
                        }
                        case 3: {
                            output = this.discoveredMutations[arrayIndex - this.discoveredParents.length];
                        }
                    }
                }
            }
        }
        return output;
    }

    private void drawTitleScreen() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(textureFrontPage);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
    }

    private void drawTableOfContents() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(textureTableOfContents);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
    }

    private void drawIntroduction() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(textureIntroduction);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        int xOffset = this.guiLeft + 24;
        int yOffset = this.guiTop + 28;
        float scale = 0.5f;
        String[] introduction = IOHelper.getLinesArrayFromData(StatCollector.func_74838_a((String)"agricraft_journal.introduction"));
        int yRenderPos = (int)((float)yOffset / scale);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        for (String paragraph : introduction) {
            String[] write;
            for (String line : write = IOHelper.getLinesArrayFromData(this.splitInLines(paragraph, scale))) {
                this.field_146289_q.func_78276_b(line, (int)((float)xOffset / scale), yRenderPos, this.black);
                yRenderPos += this.field_146289_q.field_78288_b;
            }
            yRenderPos += (int)((float)this.field_146289_q.field_78288_b / scale);
        }
        GL11.glScalef((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
    }

    private void drawSeedPage(int index) {
        if (this.discoveredSeeds != null && this.discoveredSeeds.length > index) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(textureSeedPage);
            this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
            this.drawSeedTitle(index);
            this.writeSeedInformation(index);
            this.writeSeedTier(index);
            this.drawSeedFruits();
            this.drawSeedGrowthStages();
            this.drawSeedMutations();
        }
    }

    private void getSeedTextures(int index) {
        int i;
        ItemStack seed = this.discoveredSeeds[index];
        this.seedIcon = RenderHelper.getIcon(seed.func_77973_b(), seed.func_77960_j());
        ArrayList<ItemStack> fruitDrops = SeedHelper.getAllPlantFruits((ItemSeeds)seed.func_77973_b(), this.player.func_130014_f_(), this.player.field_70118_ct, this.player.field_70117_cu, this.player.field_70116_cv, 1, seed.func_77960_j());
        this.fruitIcons = new IIcon[fruitDrops.size()];
        this.fruits = new ItemStack[fruitDrops.size()];
        for (i = 0; i < this.fruitIcons.length; ++i) {
            this.fruits[i] = fruitDrops.get(i);
            if (this.fruits[i] == null || this.fruits[i].func_77973_b() == null) continue;
            this.fruitIcons[i] = RenderHelper.getIcon(fruitDrops.get(i).func_77973_b(), fruitDrops.get(i).func_77960_j());
        }
        this.plantIcons = new IIcon[8];
        for (i = 0; i < this.plantIcons.length; ++i) {
            this.plantIcons[i] = RenderHelper.getIcon(SeedHelper.getPlant((ItemSeeds)seed.func_77973_b()), RenderHelper.plantIconIndex((ItemSeeds)seed.func_77973_b(), seed.func_77960_j(), i));
        }
        Mutation[] parents = MutationHandler.getParentMutations(seed);
        ArrayList<IIcon> iconList0 = new ArrayList<IIcon>();
        ArrayList<IIcon> IconList1 = new ArrayList<IIcon>();
        ArrayList<ItemStack> list0 = new ArrayList<ItemStack>();
        ArrayList<ItemStack> list1 = new ArrayList<ItemStack>();
        for (Mutation parentCouple : parents) {
            if (!this.isSeedDiscovered(parentCouple.parent1) || !this.isSeedDiscovered(parentCouple.parent2)) continue;
            iconList0.add(RenderHelper.getIcon(parentCouple.parent1.func_77973_b(), parentCouple.parent1.func_77960_j()));
            IconList1.add(RenderHelper.getIcon(parentCouple.parent2.func_77973_b(), parentCouple.parent2.func_77960_j()));
            list0.add(parentCouple.parent1);
            list1.add(parentCouple.parent2);
        }
        this.parentsIcons = new IIcon[iconList0.size()][2];
        this.discoveredParents = new ItemStack[list0.size()][2];
        for (int i2 = 0; i2 < iconList0.size(); ++i2) {
            this.parentsIcons[i2][0] = (IIcon)iconList0.get(i2);
            this.parentsIcons[i2][1] = (IIcon)IconList1.get(i2);
            this.discoveredParents[i2][0] = (ItemStack)list0.get(i2);
            this.discoveredParents[i2][1] = (ItemStack)list1.get(i2);
        }
        Mutation[] mutations = MutationHandler.getMutations(seed);
        ArrayList<IIcon> coParentsIconList = new ArrayList<IIcon>();
        ArrayList<IIcon> mutationsIconList = new ArrayList<IIcon>();
        ArrayList<ItemStack> coParentsList = new ArrayList<ItemStack>();
        ArrayList<ItemStack> mutationsList = new ArrayList<ItemStack>();
        for (Mutation mutation : mutations) {
            ItemStack coParent;
            ItemStack itemStack = coParent = mutation.parent1.func_77973_b() == seed.func_77973_b() && mutation.parent1.func_77960_j() == seed.func_77960_j() ? mutation.parent2 : mutation.parent1;
            if (!this.isSeedDiscovered(coParent) || !this.isSeedDiscovered(mutation.result)) continue;
            coParentsIconList.add(RenderHelper.getIcon(coParent.func_77973_b(), coParent.func_77960_j()));
            mutationsIconList.add(RenderHelper.getIcon(mutation.result.func_77973_b(), mutation.result.func_77960_j()));
            coParentsList.add(coParent);
            mutationsList.add(mutation.result);
        }
        this.coParentsIcons = coParentsIconList.toArray(new IIcon[coParentsIconList.size()]);
        this.mutationIcons = mutationsIconList.toArray(new IIcon[mutationsIconList.size()]);
        this.discoveredCoParents = coParentsList.toArray(new ItemStack[coParentsList.size()]);
        this.discoveredMutations = mutationsList.toArray(new ItemStack[mutationsList.size()]);
    }

    private void drawSeedTitle(int index) {
        ItemStack seed = this.discoveredSeeds[index];
        String title = seed.func_82833_r();
        BlockWithMeta soil = GrowthRequirements.getGrowthRequirement((ItemSeeds)seed.func_77973_b(), seed.func_77960_j()).getSoil();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(RenderHelper.getItemResource(this.seedIcon));
        if (soil != null) {
            this.renderIconInGui(this.guiLeft + 26, this.guiTop + 11, RenderHelper.getBlockResource(soil.getBlock().func_149691_a(1, soil.getMeta())));
        }
        GuiScreen.field_146296_j.func_77015_a(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().func_110434_K(), seed, this.guiLeft + 25, this.guiTop + 11);
        float scale = 0.8f;
        while ((float)this.field_146289_q.func_78256_a(title) * scale > 74.0f) {
            scale -= 0.1f;
        }
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        this.field_146289_q.func_78276_b(title, (int)((float)(this.guiLeft + 46 + 36) / scale) - this.field_146289_q.func_78256_a(title) / 2, (int)((float)(this.guiTop + 17) / scale), this.black);
        GL11.glScalef((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
    }

    private void writeSeedInformation(int index) {
        float scale = 0.5f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"agricraft_journal.information") + ": ", (int)((float)this.textStart / scale), (int)((float)(this.guiTop + 31) / scale), this.black);
        String seedData = this.splitInLines(SeedHelper.getSeedInformation(this.discoveredSeeds[index]), scale);
        if (seedData != null && !seedData.equals("")) {
            String[] write = IOHelper.getLinesArrayFromData(seedData);
            for (int i = 0; i < write.length; ++i) {
                if (write[i] == null || write[i].equals("")) continue;
                this.field_146289_q.func_78276_b(write[i], (int)((float)this.textStart / scale), (int)((float)(this.guiTop + 38) / scale + (float)(i * this.field_146289_q.field_78288_b)), this.black);
            }
        }
        GL11.glScalef((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
    }

    private void writeSeedTier(int index) {
        int tier = SeedHelper.getSeedTier((ItemSeeds)this.discoveredSeeds[index].func_77973_b(), this.discoveredSeeds[index].func_77960_j());
        String write = StatCollector.func_74838_a((String)"agricraft_journal.tier") + ": " + tier;
        float scale = 0.5f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        this.field_146289_q.func_78276_b(write, (int)((float)this.textStart / scale), (int)((float)(this.guiTop + 70) / scale), this.black);
        GL11.glScalef((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
    }

    private void drawSeedFruits() {
        int xOffset = this.guiLeft + 30;
        int yOffset = this.guiTop + 91;
        for (int i = 0; i < this.fruitIcons.length; ++i) {
            if (this.fruitIcons[i] == null) continue;
            GL11.glDisable((int)2896);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(textureSeedPage);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(xOffset - 1 + i * 24, yOffset - 1, 0, 238, 18, 18);
            GL11.glEnable((int)2896);
            GuiScreen.field_146296_j.func_77015_a(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().func_110434_K(), this.fruits[i], xOffset + i * 24, yOffset);
        }
        float scale = 0.5f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"agricraft_journal.fruits") + ": ", (int)((float)this.textStart / scale), (int)((float)(yOffset - 7) / scale), this.black);
        GL11.glScalef((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
    }

    private void drawSeedGrowthStages() {
        int xOffset = this.guiLeft + 30;
        int yOffset = this.guiTop + 124;
        float scale = 1.0f;
        for (int i = 0; i < this.plantIcons.length; ++i) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(RenderHelper.getBlockResource(this.plantIcons[i]));
            this.renderIconInGui((int)((float)(xOffset + 24 * (i % 4)) / scale), (int)((float)(yOffset + 24 * (i / 4)) / scale), RenderHelper.getBlockResource(this.plantIcons[i]));
        }
        scale = 0.5f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"agricraft_journal.growthStages") + ": ", (int)((float)this.textStart / scale), (int)((float)(yOffset - 7) / scale), this.black);
        GL11.glScalef((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
    }

    private void drawSeedMutations() {
        int yPosition;
        int i;
        int xOffset = this.guiLeft + 132;
        int yOffset = 20;
        for (i = 0; i < this.parentsIcons.length; ++i) {
            yPosition = this.guiTop + yOffset + i * 20;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(textureSeedPage);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            this.func_73729_b(xOffset, yPosition, 0, 217, 86, 18);
            GL11.glEnable((int)2896);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(RenderHelper.getItemResource(this.parentsIcons[i][0]));
            this.renderIconInGui(xOffset, yPosition + 1, RenderHelper.getItemResource(this.parentsIcons[i][0]));
            Minecraft.func_71410_x().func_110434_K().func_110577_a(RenderHelper.getItemResource(this.parentsIcons[i][1]));
            this.renderIconInGui(xOffset + 35, yPosition + 1, RenderHelper.getItemResource(this.parentsIcons[i][1]));
            Minecraft.func_71410_x().func_110434_K().func_110577_a(RenderHelper.getItemResource(this.seedIcon));
            this.renderIconInGui(xOffset + 69, yPosition + 1, RenderHelper.getItemResource(this.seedIcon));
        }
        for (i = 0; i < this.coParentsIcons.length; ++i) {
            yPosition = this.guiTop + yOffset + (i + this.parentsIcons.length) * 20;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(textureSeedPage);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            this.func_73729_b(xOffset, yPosition, 0, 217, 86, 18);
            GL11.glEnable((int)2896);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(RenderHelper.getItemResource(this.seedIcon));
            this.renderIconInGui(xOffset, yPosition + 1, RenderHelper.getItemResource(this.seedIcon));
            Minecraft.func_71410_x().func_110434_K().func_110577_a(RenderHelper.getItemResource(this.coParentsIcons[i]));
            this.renderIconInGui(xOffset + 35, yPosition + 1, RenderHelper.getItemResource(this.coParentsIcons[i]));
            Minecraft.func_71410_x().func_110434_K().func_110577_a(RenderHelper.getItemResource(this.mutationIcons[i]));
            this.renderIconInGui(xOffset + 69, yPosition + 1, RenderHelper.getItemResource(this.mutationIcons[i]));
        }
        float scale = 0.5f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"agricraft_journal.mutations") + ": ", (int)((float)xOffset / scale), (int)((float)(this.guiTop + yOffset - 7) / scale), this.black);
        GL11.glScalef((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
    }

    public void func_146278_c(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(textureBackground);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
    }

    public boolean func_73868_f() {
        return false;
    }

    private void renderIconInGui(int x, int y, ResourceLocation resource) {
        int xSize = 16;
        int ySize = 16;
        Tessellator tessellator = Tessellator.field_78398_a;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resource);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + ySize), (double)this.field_73735_i, 0.0, 1.0);
        tessellator.func_78374_a((double)(x + xSize), (double)(y + ySize), (double)this.field_73735_i, 1.0, 1.0);
        tessellator.func_78374_a((double)(x + xSize), (double)y, (double)this.field_73735_i, 1.0, 0.0);
        tessellator.func_78374_a((double)x, (double)y, (double)this.field_73735_i, 0.0, 0.0);
        tessellator.func_78381_a();
        GL11.glEnable((int)2896);
    }

    private String splitInLines(String input, float scale) {
        float maxWidth = 95.0f / scale;
        String notProcessed = input;
        String output = "";
        while ((float)this.field_146289_q.func_78256_a(notProcessed) > maxWidth) {
            int index = 0;
            if (notProcessed == null || notProcessed.equals("")) continue;
            while (notProcessed.length() - 1 > index && (float)this.field_146289_q.func_78256_a(notProcessed.substring(0, index)) < maxWidth) {
                index = index + 1 < notProcessed.length() ? index + 1 : index;
            }
            while (notProcessed.charAt(index) != ' ') {
                --index;
            }
            output = output.equals("") ? output : output + '\n';
            output = output + notProcessed.substring(0, index);
            notProcessed = notProcessed.length() > index + 1 ? notProcessed.substring(index + 1) : notProcessed;
        }
        return output + '\n' + notProcessed;
    }

    private boolean isSeedDiscovered(ItemStack seed) {
        for (ItemStack arrayElement : this.discoveredSeeds) {
            if (seed.func_77973_b() != arrayElement.func_77973_b() || seed.func_77960_j() != arrayElement.func_77960_j()) continue;
            return true;
        }
        return false;
    }
}

