/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.gui;

import com.InfinityRaider.AgriCraft.container.ContainerSeedStorageDummy;
import com.InfinityRaider.AgriCraft.tileentity.storage.SeedStorageSlot;
import com.InfinityRaider.AgriCraft.utility.RenderHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public abstract class GuiSeedStorageDummy
extends GuiContainer {
    public ContainerSeedStorageDummy container;
    ItemSeeds activeSeed;
    int activeMeta;
    private int scrollPositionVertical;
    private int scrollPositionHorizontal;
    private int sortStatId = -1;
    protected static final int buttonIdGrowth = 0;
    protected static final int buttonIdGain = 1;
    protected static final int buttonIdStrength = 2;
    protected static final int buttonIdScrollDown = 3;
    protected static final int buttonIdScrollUp = 4;
    protected static final int buttonIdScrollLeft = 5;
    protected static final int buttonIdScrollRight = 6;
    protected static final int buttonIdDownEnd = 7;
    protected static final int buttonIdUpEnd = 8;
    protected static final int buttonIdLeftEnd = 9;
    protected static final int buttonIdRightEnd = 10;
    private final int maxVertSlots;
    private final int maxHorSlots;
    private final int sortButtonX;
    private final int sortButtonY;
    private int lastButtonId = 10;
    private final int setActiveSeedButtonOffset_X;
    private final int setActiveSeedButtonOffset_Y;
    protected List<ButtonSeedStorage.SetActiveSeed> setActiveSeedButtons;
    private final int seedSlotButtonOffset_X;
    private final int seedSlotButtonOffset_Y;
    protected List<ButtonSeedStorage.SeedSlot> seedSlotButtons;

    public GuiSeedStorageDummy(ContainerSeedStorageDummy container, int maxVertSlots, int maxHorSlots, int sortButtonX, int sortButtonY, int setActiveSeedButtonsX, int setActiveSeedButtonsY, int seedSlotsX, int seedSlotsY) {
        super((Container)container);
        this.container = container;
        this.maxVertSlots = maxVertSlots;
        this.maxHorSlots = maxHorSlots;
        this.sortButtonX = sortButtonX;
        this.sortButtonY = sortButtonY;
        this.setActiveSeedButtonOffset_X = setActiveSeedButtonsX;
        this.setActiveSeedButtonOffset_Y = setActiveSeedButtonsY;
        this.seedSlotButtonOffset_X = this.field_147003_i + seedSlotsX;
        this.seedSlotButtonOffset_Y = this.field_147009_r + seedSlotsY;
    }

    protected void loadButtons() {
        this.field_146292_n.clear();
        int buttonWidth = 60;
        int buttonHeight = 12;
        this.field_146292_n.add(new GuiButton(0, this.field_147003_i + this.sortButtonX, this.field_147009_r + this.sortButtonY, buttonWidth, buttonHeight, "Growth"));
        this.field_146292_n.add(new GuiButton(1, this.field_147003_i + this.sortButtonX, this.field_147009_r + this.sortButtonY + buttonHeight + 1, buttonWidth, buttonHeight, "Gain"));
        this.field_146292_n.add(new GuiButton(2, this.field_147003_i + this.sortButtonX, this.field_147009_r + this.sortButtonY + 2 * (buttonHeight + 1), buttonWidth, buttonHeight, "Strength"));
        this.initSetActiveSeedButtons();
        this.initSeedSlotButtons();
    }

    private void initSetActiveSeedButtons() {
        if (this.setActiveSeedButtonOffset_X < 0 || this.setActiveSeedButtonOffset_Y < 0) {
            return;
        }
        this.setActiveSeedButtons = new ArrayList<ButtonSeedStorage.SetActiveSeed>();
        List<ItemStack> list = this.container.getSeedEntries();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                int xOffset = this.field_147003_i + this.setActiveSeedButtonOffset_X + 16 * i % 64;
                int yOffset = this.field_147009_r + this.setActiveSeedButtonOffset_Y + 16 * (i / 4);
                ++this.lastButtonId;
                this.setActiveSeedButtons.add(new ButtonSeedStorage.SetActiveSeed(this.lastButtonId, xOffset, yOffset, list.get(i)));
            }
            this.field_146292_n.addAll(this.setActiveSeedButtons);
        }
    }

    private void initSeedSlotButtons() {
        if (this.activeSeed == null) {
            return;
        }
        this.seedSlotButtons = new ArrayList<ButtonSeedStorage.SeedSlot>();
        List<SeedStorageSlot> list = this.container.getSeedSlots(this.activeSeed, this.activeMeta);
        if (list != null) {
            this.sortByStat(list);
            for (int i = this.scrollPositionHorizontal; i < Math.min(list.size(), this.scrollPositionHorizontal + this.maxHorSlots); ++i) {
                SeedStorageSlot slot = list.get(i);
                ++this.lastButtonId;
                this.seedSlotButtons.add(new ButtonSeedStorage.SeedSlot(this.lastButtonId, this.seedSlotButtonOffset_X + i * 16, this.seedSlotButtonOffset_Y, slot.getStack((Item)this.activeSeed, this.activeMeta), slot.getId()));
            }
        }
        this.field_146292_n.addAll(this.seedSlotButtons);
    }

    protected void func_146284_a(GuiButton button) {
        if (button instanceof ButtonSeedStorage.SetActiveSeed) {
            this.setActiveSeed((ButtonSeedStorage.SetActiveSeed)button);
        } else if (button instanceof ButtonSeedStorage.SeedSlot) {
            this.container.moveStackFromTileEntityToPlayer(((ButtonSeedStorage.SeedSlot)button).slotId, new ItemStack((Item)this.activeSeed, 1, this.activeMeta));
        } else if (button.field_146127_k <= 2 && this.activeSeed != null) {
            this.sortStatId = button.field_146127_k;
        } else {
            switch (button.field_146127_k) {
                case 3: {
                    this.scrollVertical(-1);
                    break;
                }
                case 4: {
                    this.scrollVertical(1);
                    break;
                }
                case 6: {
                    this.scrollHorizontal(1);
                    break;
                }
                case 5: {
                    this.scrollHorizontal(-1);
                    break;
                }
                case 7: {
                    this.scrollVertical(this.getMaxVerticalScroll());
                    break;
                }
                case 8: {
                    this.scrollVertical(-this.getMaxVerticalScroll());
                    break;
                }
                case 9: {
                    this.scrollHorizontal(-this.getMaxHorizontalScroll());
                    break;
                }
                case 10: {
                    this.scrollHorizontal(this.getMaxHorizontalScroll());
                }
            }
        }
        this.func_73876_c();
    }

    private void sortByStat(List<SeedStorageSlot> list) {
        String stat = null;
        switch (this.sortStatId) {
            case 0: {
                stat = "growth";
                break;
            }
            case 1: {
                stat = "gain";
                break;
            }
            case 2: {
                stat = "strength";
            }
        }
        if (stat != null && this.activeSeed != null) {
            Collections.sort(list, new SeedStorageSlot.SlotComparator(stat));
        }
    }

    private void scrollVertical(int amount) {
        int newPos = this.scrollPositionVertical + amount;
        newPos = newPos < 0 ? 0 : newPos;
        int maxScrollY = this.getMaxVerticalScroll();
        this.scrollPositionVertical = newPos = newPos > maxScrollY ? maxScrollY : newPos;
    }

    private int getMaxVerticalScroll() {
        int nrSeedButtons = this.setActiveSeedButtons.size();
        int nrRows = (nrSeedButtons % 4 > 0 ? 1 : 0) + nrSeedButtons / 4;
        if (nrRows <= this.maxVertSlots) {
            return 0;
        }
        return nrRows - this.maxVertSlots;
    }

    private void scrollHorizontal(int amount) {
        if (this.activeSeed != null) {
            int newPos = this.scrollPositionHorizontal + amount;
            newPos = newPos < 0 ? 0 : newPos;
            int maxScrollX = this.getMaxHorizontalScroll();
            this.scrollPositionHorizontal = newPos = newPos > maxScrollX ? maxScrollX : newPos;
        }
    }

    private int getMaxHorizontalScroll() {
        int nrSlots = this.seedSlotButtons.size();
        if (nrSlots <= this.maxHorSlots) {
            return 0;
        }
        return nrSlots - this.maxHorSlots;
    }

    protected void drawActiveEntries(ResourceLocation texture, int xOffset, int yOffset) {
        int textureSize = 256;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        for (int i = 0; i < this.seedSlotButtons.size(); ++i) {
            ButtonSeedStorage.SeedSlot slot = this.seedSlotButtons.get(i);
            if (slot == null || slot.stack == null) continue;
            int growth = slot.stack.field_77990_d.func_74762_e("growth");
            int gain = slot.stack.field_77990_d.func_74762_e("gain");
            int strength = slot.stack.field_77990_d.func_74762_e("strength");
            this.func_73729_b(xOffset + i * 16 + 1, yOffset - growth, 0, textureSize - growth, 3, growth);
            this.func_73729_b(xOffset + i * 16 + 6, yOffset - gain, 0, textureSize - gain, 3, gain);
            this.func_73729_b(xOffset + i * 16 + 11, yOffset - strength, 0, textureSize - strength, 3, strength);
        }
    }

    protected void setActiveSeed(ButtonSeedStorage.SetActiveSeed button) {
        this.setActiveSeed(button.stack);
    }

    protected void setActiveSeed(ItemStack stack) {
        this.activeSeed = (ItemSeeds)stack.func_77973_b();
        this.activeMeta = stack.func_77960_j();
    }

    public boolean func_73868_f() {
        return false;
    }

    private static abstract class ButtonSeedStorage
    extends GuiButton {
        public ItemStack stack;

        public ButtonSeedStorage(int id, int xPos, int yPos, ItemStack stack) {
            super(id, xPos, yPos, 16, 16, "");
            this.stack = stack;
            this.field_146125_m = true;
        }

        protected ResourceLocation getTexture() {
            return RenderHelper.getItemResource(this.stack.func_77973_b().func_77617_a(this.stack.func_77960_j()));
        }

        protected String getTooltip() {
            return this.stack.func_82833_r();
        }

        protected void drawHoveringText(List list, int x, int y, FontRenderer font) {
            if (!list.isEmpty()) {
                GL11.glDisable((int)32826);
                net.minecraft.client.renderer.RenderHelper.func_74518_a();
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2929);
                int k = 0;
                for (String s : list) {
                    int l = font.func_78256_a(s);
                    if (l <= k) continue;
                    k = l;
                }
                int j2 = x + 12;
                int k2 = y - 12;
                int i1 = 8;
                if (list.size() > 1) {
                    i1 += 2 + (list.size() - 1) * 10;
                }
                if (j2 + k > this.field_146120_f) {
                    j2 -= 28 + k;
                }
                if (k2 + i1 + 6 > this.field_146121_g) {
                    k2 = this.field_146121_g - i1 - 6;
                }
                this.field_73735_i = 300.0f;
                field_146296_j.field_77023_b = 300.0f;
                int j1 = -267386864;
                this.func_73733_a(j2 - 3, k2 - 4, j2 + k + 3, k2 - 3, j1, j1);
                this.func_73733_a(j2 - 3, k2 + i1 + 3, j2 + k + 3, k2 + i1 + 4, j1, j1);
                this.func_73733_a(j2 - 3, k2 - 3, j2 + k + 3, k2 + i1 + 3, j1, j1);
                this.func_73733_a(j2 - 4, k2 - 3, j2 - 3, k2 + i1 + 3, j1, j1);
                this.func_73733_a(j2 + k + 3, k2 - 3, j2 + k + 4, k2 + i1 + 3, j1, j1);
                int k1 = 0x505000FF;
                int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
                this.func_73733_a(j2 - 3, k2 - 3 + 1, j2 - 3 + 1, k2 + i1 + 3 - 1, k1, l1);
                this.func_73733_a(j2 + k + 2, k2 - 3 + 1, j2 + k + 3, k2 + i1 + 3 - 1, k1, l1);
                this.func_73733_a(j2 - 3, k2 - 3, j2 + k + 3, k2 - 3 + 1, k1, k1);
                this.func_73733_a(j2 - 3, k2 + i1 + 2, j2 + k + 3, k2 + i1 + 3, l1, l1);
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    String s1 = (String)list.get(i2);
                    font.func_78261_a(s1, j2, k2, -1);
                    if (i2 == 0) {
                        k2 += 2;
                    }
                    k2 += 10;
                }
                this.field_73735_i = 0.0f;
                field_146296_j.field_77023_b = 0.0f;
                GL11.glEnable((int)2896);
                GL11.glEnable((int)2929);
                net.minecraft.client.renderer.RenderHelper.func_74519_b();
                GL11.glEnable((int)32826);
            }
        }

        public void func_73729_b(int xPos, int yPos, int u, int v, int width, int height) {
            float f = 0.0625f;
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)xPos, (double)(yPos + height), (double)this.field_73735_i, (double)u * (double)f, (double)(v + height) * (double)f);
            tessellator.func_78374_a((double)(xPos + width), (double)(yPos + height), (double)this.field_73735_i, (double)(u + width) * (double)f, (double)(v + height) * (double)f);
            tessellator.func_78374_a((double)(xPos + width), (double)yPos, (double)this.field_73735_i, (double)(u + width) * (double)f, (double)v * (double)f);
            tessellator.func_78374_a((double)xPos, (double)yPos, (double)this.field_73735_i, (double)u * (double)f, (double)v * (double)f);
            tessellator.func_78381_a();
        }

        protected static final class SeedSlot
        extends ButtonSeedStorage {
            public int slotId;

            public SeedSlot(int ButtonId, int xPos, int yPos, ItemStack seedStack, int slotId) {
                super(ButtonId, xPos, yPos, seedStack);
                this.slotId = slotId;
            }

            public void func_146112_a(Minecraft minecraft, int x, int y) {
                if (this.field_146125_m) {
                    FontRenderer fontrenderer = minecraft.field_71466_p;
                    minecraft.func_110434_K().func_110577_a(this.getTexture());
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.field_146123_n = x >= this.field_146128_h && y >= this.field_146129_i && x < this.field_146128_h + this.field_146120_f && y < this.field_146129_i + this.field_146121_g;
                    int k = this.func_146114_a(this.field_146123_n);
                    GL11.glEnable((int)3042);
                    OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                    GL11.glBlendFunc((int)770, (int)771);
                    this.func_73729_b(this.field_146128_h, this.field_146129_i, 0, 16, 16, 16);
                    this.func_146119_b(minecraft, x, y);
                    if (this.func_146114_a(true) == 2) {
                        String[] tooltip = new String[]{this.getTooltip()};
                        this.drawHoveringText(Arrays.asList(tooltip), this.field_146128_h, this.field_146129_i, Minecraft.func_71410_x().field_71466_p);
                    }
                }
            }
        }

        protected static final class SetActiveSeed
        extends ButtonSeedStorage {
            public SetActiveSeed(int id, int xPos, int yPos, ItemStack seedStack) {
                super(id, xPos, yPos, seedStack);
            }

            public void func_146112_a(Minecraft minecraft, int x, int y) {
                if (this.field_146125_m) {
                    FontRenderer fontrenderer = minecraft.field_71466_p;
                    minecraft.func_110434_K().func_110577_a(this.getTexture());
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.field_146123_n = x >= this.field_146128_h && y >= this.field_146129_i && x < this.field_146128_h + this.field_146120_f && y < this.field_146129_i + this.field_146121_g;
                    int k = this.func_146114_a(this.field_146123_n);
                    GL11.glEnable((int)3042);
                    OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                    GL11.glBlendFunc((int)770, (int)771);
                    this.func_73729_b(this.field_146128_h, this.field_146129_i, 0, 16, 16, 16);
                    this.func_146119_b(minecraft, x, y);
                    if (this.func_146114_a(true) == 2) {
                        String[] tooltip = new String[]{this.getTooltip()};
                        this.drawHoveringText(Arrays.asList(tooltip), this.field_146128_h, this.field_146129_i, Minecraft.func_71410_x().field_71466_p);
                    }
                }
            }
        }
    }
}

