/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.renderers;

import com.InfinityRaider.AgriCraft.tileentity.irrigation.TileEntityChannel;
import com.InfinityRaider.AgriCraft.utility.RenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderItemChannel
implements IItemRenderer {
    private TileEntity tileEntity;

    public RenderItemChannel(TileEntity tileEntity) {
        this.tileEntity = tileEntity;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        TileEntityChannel channel = (TileEntityChannel)this.tileEntity;
        channel.setMaterial(item.func_77978_p());
        this.renderModel(channel, 0.0, 0.0, 0.0, item.func_77960_j());
    }

    public void renderModel(TileEntityChannel channel, double x, double y, double z, int meta) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        if (meta == 0) {
            this.drawWoodChannel(channel, tessellator);
        } else if (meta == 1) {
            this.drawIronChannel(channel, tessellator);
        }
        GL11.glPopMatrix();
    }

    private void drawWoodChannel(TileEntityChannel channel, Tessellator tessellator) {
        this.renderBottom(channel, tessellator);
        this.renderSide(channel, tessellator, 'x', -1);
        this.renderSide(channel, tessellator, 'x', 1);
        this.renderSide(channel, tessellator, 'z', -1);
        this.renderSide(channel, tessellator, 'z', 1);
    }

    private void renderBottom(TileEntityChannel channel, Tessellator tessellator) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(RenderHelper.getBlockResource(channel.getIcon()));
        GL11.glDisable((int)2896);
        tessellator.func_78382_b();
        RenderHelper.addScaledVertexWithUV(tessellator, 4.0f, 5.0f, 4.0f, 4.0f, 4.0f);
        RenderHelper.addScaledVertexWithUV(tessellator, 4.0f, 5.0f, 12.0f, 4.0f, 12.0f);
        RenderHelper.addScaledVertexWithUV(tessellator, 12.0f, 5.0f, 12.0f, 12.0f, 12.0f);
        RenderHelper.addScaledVertexWithUV(tessellator, 12.0f, 5.0f, 4.0f, 12.0f, 4.0f);
        RenderHelper.addScaledVertexWithUV(tessellator, 4.0f, 4.0f, 4.0f, 4.0f, 4.0f);
        RenderHelper.addScaledVertexWithUV(tessellator, 12.0f, 4.0f, 4.0f, 12.0f, 4.0f);
        RenderHelper.addScaledVertexWithUV(tessellator, 12.0f, 4.0f, 12.0f, 12.0f, 12.0f);
        RenderHelper.addScaledVertexWithUV(tessellator, 4.0f, 4.0f, 12.0f, 4.0f, 12.0f);
        tessellator.func_78381_a();
        GL11.glEnable((int)2896);
    }

    private void renderSide(TileEntityChannel channel, Tessellator tessellator, char axis, int direction) {
        if (!(axis != 'x' && axis != 'z' || direction != 1 && direction != -1)) {
            boolean x = axis == 'x';
            Minecraft.func_71410_x().field_71446_o.func_110577_a(RenderHelper.getBlockResource(channel.getIcon()));
            GL11.glDisable((int)2896);
            tessellator.func_78382_b();
            RenderHelper.addScaledVertexWithUV(tessellator, x ? 8.5f + 3.5f * (float)direction : 4.0f, 12.0f, x ? 12.0f : 8.5f + 3.5f * (float)direction, 4.0f, 4.0f);
            RenderHelper.addScaledVertexWithUV(tessellator, x ? 8.5f + 3.5f * (float)direction : 4.0f, 4.0f, x ? 12.0f : 8.5f + 3.5f * (float)direction, 4.0f, 12.0f);
            RenderHelper.addScaledVertexWithUV(tessellator, x ? 8.5f + 3.5f * (float)direction : 12.0f, 4.0f, x ? 4.0f : 8.5f + 3.5f * (float)direction, 12.0f, 12.0f);
            RenderHelper.addScaledVertexWithUV(tessellator, x ? 8.5f + 3.5f * (float)direction : 12.0f, 12.0f, x ? 4.0f : 8.5f + 3.5f * (float)direction, 12.0f, 4.0f);
            RenderHelper.addScaledVertexWithUV(tessellator, x ? 7.5f + 3.5f * (float)direction : 4.0f, 12.0f, x ? 4.0f : 7.5f + 3.5f * (float)direction, 4.0f, 4.0f);
            RenderHelper.addScaledVertexWithUV(tessellator, x ? 7.5f + 3.5f * (float)direction : 12.0f, x ? 4.0f : 12.0f, x ? 4.0f : 7.5f + 3.5f * (float)direction, x ? 4.0f : 12.0f, x ? 12.0f : 4.0f);
            RenderHelper.addScaledVertexWithUV(tessellator, x ? 7.5f + 3.5f * (float)direction : 12.0f, 4.0f, x ? 12.0f : 7.5f + 3.5f * (float)direction, 12.0f, 12.0f);
            RenderHelper.addScaledVertexWithUV(tessellator, x ? 7.5f + 3.5f * (float)direction : 4.0f, x ? 12.0f : 4.0f, x ? 12.0f : 7.5f + 3.5f * (float)direction, x ? 12.0f : 4.0f, x ? 4.0f : 12.0f);
            RenderHelper.addScaledVertexWithUV(tessellator, x ? 7.5f + 3.5f * (float)direction : 4.0f, 12.0f, x ? 4.0f : 7.5f + 3.5f * (float)direction, x ? 7.5f + 3.5f * (float)direction : 4.0f, x ? 4.0f : 7.5f + 3.5f * (float)direction);
            RenderHelper.addScaledVertexWithUV(tessellator, x ? 7.5f + 3.5f * (float)direction : 4.0f, 12.0f, x ? 12.0f : 8.5f + 3.5f * (float)direction, x ? 7.5f + 3.5f * (float)direction : 4.0f, x ? 12.0f : 8.5f + 3.5f * (float)direction);
            RenderHelper.addScaledVertexWithUV(tessellator, x ? 8.5f + 3.5f * (float)direction : 12.0f, 12.0f, x ? 12.0f : 8.5f + 3.5f * (float)direction, x ? 8.5f + 3.5f * (float)direction : 12.0f, x ? 12.0f : 8.5f + 3.5f * (float)direction);
            RenderHelper.addScaledVertexWithUV(tessellator, x ? 8.5f + 3.5f * (float)direction : 12.0f, 12.0f, x ? 4.0f : 7.5f + 3.5f * (float)direction, x ? 8.5f + 3.5f * (float)direction : 12.0f, x ? 4.0f : 7.5f + 3.5f * (float)direction);
            tessellator.func_78381_a();
            GL11.glEnable((int)2896);
        }
    }

    private void drawIronChannel(TileEntityChannel channel, Tessellator tessellator) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(RenderHelper.getBlockResource(channel.getIcon()));
    }
}

