/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.tileentity;

import com.InfinityRaider.AgriCraft.blocks.BlockCrop;
import com.InfinityRaider.AgriCraft.farming.GrowthRequirements;
import com.InfinityRaider.AgriCraft.farming.mutation.CrossOverResult;
import com.InfinityRaider.AgriCraft.farming.mutation.MutationEngine;
import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import com.InfinityRaider.AgriCraft.tileentity.TileEntityAgricraft;
import com.InfinityRaider.AgriCraft.utility.RenderHelper;
import com.InfinityRaider.AgriCraft.utility.SeedHelper;
import com.InfinityRaider.AgriCraft.utility.interfaces.IDebuggable;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCrop
extends TileEntityAgricraft
implements IDebuggable {
    public int growth = 0;
    public int gain = 0;
    public int strength = 0;
    public boolean analyzed = false;
    public boolean crossCrop = false;
    public boolean weed = false;
    public ItemSeeds seed = null;
    public int seedMeta = 0;
    private final MutationEngine mutationEngine = new MutationEngine(this);

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74777_a("growth", (short)this.growth);
        tag.func_74777_a("gain", (short)this.gain);
        tag.func_74777_a("strength", (short)this.strength);
        tag.func_74757_a("analyzed", this.analyzed);
        tag.func_74757_a("crossCrop", this.crossCrop);
        tag.func_74757_a("weed", this.weed);
        if (this.seed != null) {
            tag.func_74778_a("seed", this.getSeedString());
            tag.func_74777_a("meta", (short)this.seedMeta);
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.growth = tag.func_74762_e("growth");
        this.gain = tag.func_74762_e("gain");
        this.strength = tag.func_74762_e("strength");
        this.analyzed = tag.func_74764_b("analyzed") && tag.func_74767_n("analyzed");
        this.crossCrop = tag.func_74767_n("crossCrop");
        this.weed = tag.func_74767_n("weed");
        if (tag.func_74764_b("seed") && tag.func_74764_b("meta")) {
            this.setSeed(tag.func_74779_i("seed"));
            this.seedMeta = tag.func_74762_e("meta");
        } else {
            this.seed = null;
            this.seedMeta = 0;
        }
    }

    public void crossOver() {
        this.mutationEngine.executeCrossOver();
    }

    public void applyCrossOverResult(CrossOverResult result) {
        this.crossCrop = false;
        this.setPlant(result.getGrowth(), result.getGain(), result.getStrength(), false, result.getSeed(), result.getMeta());
        this.markForUpdate();
    }

    public List<TileEntityCrop> getNeighbours() {
        ArrayList<TileEntityCrop> neighbours = new ArrayList<TileEntityCrop>();
        this.addNeighbour(neighbours, ForgeDirection.NORTH);
        this.addNeighbour(neighbours, ForgeDirection.SOUTH);
        this.addNeighbour(neighbours, ForgeDirection.EAST);
        this.addNeighbour(neighbours, ForgeDirection.WEST);
        return neighbours;
    }

    private void addNeighbour(List<TileEntityCrop> neighbours, ForgeDirection direction) {
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
        if (te == null || !(te instanceof TileEntityCrop)) {
            return;
        }
        neighbours.add((TileEntityCrop)te);
    }

    public List<TileEntityCrop> getMatureNeighbours() {
        List<TileEntityCrop> neighbours = this.getNeighbours();
        Iterator<TileEntityCrop> iterator = neighbours.iterator();
        while (iterator.hasNext()) {
            TileEntityCrop crop = iterator.next();
            if (crop.isMature()) continue;
            iterator.remove();
        }
        return neighbours;
    }

    public void spawnWeed() {
        this.crossCrop = false;
        this.clearPlant();
        this.weed = true;
        this.markForUpdate();
    }

    public void spreadWeed() {
        List<TileEntityCrop> neighbours = this.getNeighbours();
        for (TileEntityCrop crop : neighbours) {
            if (crop == null || crop.weed || !(Math.random() < crop.getWeedSpawnChance())) continue;
            crop.spawnWeed();
            break;
        }
    }

    public void updateWeed(int growthStage) {
        if (growthStage == 0) {
            this.weed = false;
        }
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, growthStage, 3);
        this.markForUpdate();
    }

    public void clearWeed() {
        this.updateWeed(0);
    }

    private double getWeedSpawnChance() {
        if (this.hasPlant()) {
            return ConfigurationHandler.weedsWipePlants ? (double)(10 - this.strength) / 10.0 : 0.0;
        }
        return this.weed ? 0.0 : 1.0;
    }

    public void setPlant(int growth, int gain, int strength, boolean analyzed, ItemSeeds seed, int seedMeta) {
        if (!this.crossCrop && !this.hasPlant()) {
            this.growth = growth;
            this.gain = gain;
            this.strength = strength;
            this.seed = seed;
            this.analyzed = analyzed;
            this.seedMeta = seedMeta;
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 3);
            this.markForUpdate();
        }
    }

    public void clearPlant() {
        if (!this.crossCrop) {
            this.growth = 0;
            this.gain = 0;
            this.strength = 0;
            this.seed = null;
            this.seedMeta = 0;
            this.analyzed = false;
            this.weed = false;
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 3);
            this.markForUpdate();
        }
    }

    public boolean func_145842_c(int id, int value) {
        if (this.field_145850_b.field_72995_K && id == 1) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147451_t(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            Minecraft.func_71410_x().field_71438_f.func_147586_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    public boolean hasPlant() {
        return this.seed != null && this.seed.getPlant((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e) != null;
    }

    public boolean isFertile() {
        return GrowthRequirements.getGrowthRequirement(this.seed, this.seedMeta).canGrow(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean isMature() {
        return !this.field_145850_b.field_72995_K && this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e) != null && this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e) instanceof BlockCrop && ((BlockCrop)this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e)).isMature(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public ItemStack getSeedStack() {
        ItemStack seed = new ItemStack((Item)this.seed, 1, this.seedMeta);
        NBTTagCompound tag = new NBTTagCompound();
        SeedHelper.setNBT(tag, (short)this.growth, (short)this.gain, (short)this.strength, this.analyzed);
        seed.func_77982_d(tag);
        return seed;
    }

    public String getSeedString() {
        return this.seed == null ? "none" : Item.field_150901_e.func_148750_c((Object)this.seed);
    }

    public void setSeed(String input) {
        this.seed = input.equalsIgnoreCase("none") ? null : (ItemSeeds)Item.field_150901_e.func_82594_a(input);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getPlantIcon() {
        IIcon icon = null;
        if (this.hasPlant()) {
            int meta = RenderHelper.plantIconIndex(this.seed, this.seedMeta, this.func_145832_p());
            icon = SeedHelper.getPlant(this.seed).func_149691_a(0, meta);
        } else if (this.weed) {
            icon = ((BlockCrop)this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e)).getWeedIcon(this.func_145832_p());
        }
        return icon;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderType() {
        int type = -1;
        if (this.hasPlant()) {
            type = RenderHelper.getRenderType(this.seed, this.seedMeta);
        } else if (this.weed) {
            type = 6;
        }
        return type;
    }

    @Override
    public void addDebugInfo(List<String> list) {
        list.add("CROP:");
        if (this.crossCrop) {
            list.add(" - This is a crosscrop");
        } else if (this.hasPlant()) {
            list.add(" - This crop has a plant");
            list.add(" - Seed: " + this.seed.func_77658_a());
            list.add(" - RegisterName: " + Item.field_150901_e.func_148750_c((Object)this.seed) + ':' + this.seedMeta);
            list.add(" - Plant: " + SeedHelper.getPlant(this.seed).func_149739_a());
            list.add(" - Meta: " + this.func_145832_p());
            list.add(" - Growth: " + this.growth);
            list.add(" - Gain: " + this.gain);
            list.add(" - Strength: " + this.strength);
            list.add(" - Fertile: " + this.isFertile());
            list.add(" - Mature: " + this.isMature());
        } else if (this.weed) {
            list.add(" - This crop has weeds");
            list.add(" - Meta: " + this.func_145832_p());
        } else {
            list.add(" - This crop has no plant");
        }
    }
}

