/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.tileentity.irrigation;

import com.InfinityRaider.AgriCraft.tileentity.TileEntityCustomWood;
import com.InfinityRaider.AgriCraft.tileentity.irrigation.TileEntityTank;
import com.InfinityRaider.AgriCraft.tileentity.irrigation.TileEntityValve;
import com.InfinityRaider.AgriCraft.utility.interfaces.IDebuggable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileEntityChannel
extends TileEntityCustomWood
implements IDebuggable {
    private static final int SYNC_WATER_ID = 0;
    protected static final int DISCRETE_MAX = 16;
    protected static final float DISCRETE_FACTOR = 0.032f;
    protected static final float SCALE_FACTOR = 31.25f;
    private int lvl;
    protected int lastDiscreteLevel = 0;

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (this.lvl > 0) {
            tag.func_74768_a("level", this.lvl);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        this.lvl = tag.func_74764_b("level") ? tag.func_74762_e("level") : 0;
        super.func_145839_a(tag);
    }

    public int getFluidLevel() {
        return this.lvl;
    }

    public void setFluidLevel(int lvl) {
        if (lvl >= 0 && lvl <= 500 && lvl != this.lvl) {
            this.lvl = lvl;
            this.syncToClient(false);
        }
    }

    public float getFluidHeight() {
        return this.getFluidHeight(this.lvl);
    }

    public float getDiscreteScaledFluidHeight() {
        return this.getFluidHeight(this.getDiscreteScaledFluidLevel());
    }

    public float getFluidHeight(int lvl) {
        return 5.0f + 7.0f * (float)lvl / 500.0f;
    }

    public boolean hasNeighbour(char axis, int direction) {
        TileEntity tileEntityAt;
        switch (axis) {
            case 'x': {
                tileEntityAt = this.field_145850_b.func_147438_o(this.field_145851_c + direction, this.field_145848_d, this.field_145849_e);
                break;
            }
            case 'z': {
                tileEntityAt = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + direction);
                break;
            }
            default: {
                return false;
            }
        }
        return tileEntityAt != null && tileEntityAt instanceof TileEntityCustomWood && this.isSameMaterial((TileEntityCustomWood)tileEntityAt);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            ArrayList<TileEntityCustomWood> neighbours = new ArrayList<TileEntityCustomWood>();
            if (this.hasNeighbour('x', 1)) {
                neighbours.add((TileEntityCustomWood)this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e));
            }
            if (this.hasNeighbour('x', -1)) {
                neighbours.add((TileEntityCustomWood)this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e));
            }
            if (this.hasNeighbour('z', 1)) {
                neighbours.add((TileEntityCustomWood)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1));
            }
            if (this.hasNeighbour('z', -1)) {
                neighbours.add((TileEntityCustomWood)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1));
            }
            int totalLvl = 0;
            int nr = 1;
            int updatedLevel = this.getFluidLevel();
            for (TileEntityCustomWood te : neighbours) {
                if (te instanceof TileEntityChannel) {
                    if (te instanceof TileEntityValve && ((TileEntityValve)te).isPowered()) continue;
                    totalLvl += ((TileEntityChannel)te).lvl;
                    ++nr;
                    continue;
                }
                TileEntityTank tank = (TileEntityTank)te;
                int Y = tank.getYPosition();
                float y_c = (float)(16 * Y) + this.getDiscreteScaledFluidHeight();
                float y_t = tank.getFluidY();
                float y1 = 5.0f + (float)(16 * Y);
                float y2 = 12.0f + (float)(16 * Y);
                int V_tot = tank.getFluidLevel() + this.lvl;
                if (y_c == y_t) continue;
                if (tank.getFluidY(V_tot) <= y1) {
                    updatedLevel = 0;
                    tank.setFluidLevel(V_tot);
                    continue;
                }
                if (tank.getFluidY(V_tot - 500) >= y2) {
                    updatedLevel = 500;
                    tank.setFluidLevel(V_tot - 500);
                    continue;
                }
                int tankYSize = tank.getYSize();
                int C = tank.getTotalCapacity();
                float enumerator = (float)V_tot + (500.0f * y1 / (y2 - y1) + 2.0f * (float)C / (float)(16 * tankYSize - 2));
                float denominator = 500.0f / (y2 - y1) + (float)C / (float)(16 * tankYSize - 2);
                float y = enumerator / denominator;
                int channelVolume = (int)Math.floor(500.0f * (y - y1) / (y2 - y1));
                int tankVolume = (int)Math.ceil((float)C * (y - 2.0f) / (float)(16 * tankYSize - 2));
                updatedLevel = channelVolume;
                tank.setFluidLevel(tankVolume);
            }
            int rest = (totalLvl += updatedLevel) % nr;
            int newLvl = totalLvl / nr;
            if (nr > 1) {
                for (TileEntityCustomWood te : neighbours) {
                    if (!(te instanceof TileEntityChannel) || te instanceof TileEntityValve && ((TileEntityValve)te).isPowered()) continue;
                    int lvl = rest == 0 ? newLvl : newLvl + 1;
                    rest = rest == 0 ? 0 : rest - 1;
                    ((TileEntityChannel)te).setFluidLevel(lvl);
                }
            }
            this.setFluidLevel(newLvl + rest);
        }
    }

    public void syncToClient(boolean forceUpdate) {
        boolean change;
        boolean bl = change = forceUpdate || this.getDiscreteFluidLevel() != this.lastDiscreteLevel;
        if (change) {
            this.lastDiscreteLevel = this.getDiscreteFluidLevel();
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 0, this.lvl);
        }
    }

    public boolean func_145842_c(int id, int data) {
        if (id == 0) {
            this.lvl = data;
            return true;
        }
        return false;
    }

    public void drainFluid(int amount) {
        this.setFluidLevel(this.lvl - amount);
    }

    public int getDiscreteFluidLevel() {
        int discreteFluidLevel = Math.round(0.032f * (float)this.lvl);
        if (discreteFluidLevel == 0 && this.lvl > 0) {
            discreteFluidLevel = 1;
        }
        return discreteFluidLevel;
    }

    public int getDiscreteScaledFluidLevel() {
        int discreteFluidLevel = this.getDiscreteFluidLevel();
        return Math.round(31.25f * (float)discreteFluidLevel);
    }

    @Override
    public void addDebugInfo(List<String> list) {
        list.add("CHANNEL:");
        super.addDebugInfo(list);
        list.add("  - FluidLevel: " + this.getFluidLevel() + "/" + 500);
        list.add("  - FluidHeight: " + this.getFluidHeight());
    }
}

