/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.tileentity.irrigation;

import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import com.InfinityRaider.AgriCraft.tileentity.TileEntityCustomWood;
import com.InfinityRaider.AgriCraft.utility.interfaces.IDebuggable;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityTank
extends TileEntityCustomWood
implements IFluidHandler,
IDebuggable {
    protected static final int DISCRETE_MAX = 32;
    protected int connectedTanks = 1;
    private int fluidLevel = 0;
    protected int lastDiscreteFluidLevel = 0;

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        tag.func_74768_a("nrTanks", this.connectedTanks);
        if (this.fluidLevel > 0) {
            tag.func_74768_a("level", this.fluidLevel);
        }
        super.func_145841_b(tag);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        this.connectedTanks = tag.func_74762_e("nrTanks");
        this.fluidLevel = tag.func_74764_b("level") ? tag.func_74762_e("level") : 0;
        super.func_145839_a(tag);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            BiomeGenBase biome;
            if (this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d, this.field_145849_e) && this.field_145850_b.func_72896_J() && this.getYPosition() + 1 == this.getYSize() && (biome = this.field_145850_b.func_72807_a(this.field_145851_c, this.field_145849_e)) != BiomeGenBase.field_76769_d && biome != BiomeGenBase.field_76786_s) {
                this.setFluidLevel(this.fluidLevel + 1);
            }
            if (ConfigurationHandler.fillFromFlowingWater && (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) == Blocks.field_150355_j || this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) == Blocks.field_150358_i)) {
                this.setFluidLevel(this.fluidLevel + 5);
            }
        }
    }

    public void syncToClient(boolean forceUpdate) {
        boolean change;
        boolean bl = change = forceUpdate || this.getDiscreteFluidLevel() != this.lastDiscreteFluidLevel;
        if (change) {
            this.lastDiscreteFluidLevel = this.getDiscreteFluidLevel();
            this.markForUpdate();
        }
    }

    public boolean isWood() {
        return this.func_145832_p() == 0;
    }

    public boolean isMultiBlock() {
        return this.connectedTanks > 1;
    }

    public int getConnectedTanks() {
        return this.connectedTanks;
    }

    public boolean isSameTank(TileEntity tileEntity) {
        if (tileEntity != null && tileEntity instanceof TileEntityTank) {
            TileEntityTank tank = (TileEntityTank)tileEntity;
            return this.isSameMaterial(tank);
        }
        return false;
    }

    public boolean isMultiBlockPartner(TileEntity tileEntity) {
        return this.connectedTanks > 1 && this.isSameTank(tileEntity) && this.connectedTanks == ((TileEntityTank)tileEntity).connectedTanks;
    }

    public boolean updateMultiBlock() {
        boolean change = false;
        if (!this.isMultiBlock()) {
            change = this.checkForMultiBlock();
        }
        return change;
    }

    public boolean checkForMultiBlock() {
        if (!this.field_145850_b.field_72995_K) {
            TileEntityTank tank;
            int y;
            int x;
            TileEntityTank tank2;
            int z;
            int y2;
            int x2;
            int xPos = this.findArrayXPosition();
            int yPos = this.findArrayYPosition();
            int zPos = this.findArrayZPosition();
            int xSize = this.findArrayXSize();
            int ySize = this.findArrayYSize();
            int zSize = this.findArrayZSize();
            if (xSize == 1 && ySize == 1 && zSize == 1) {
                return false;
            }
            for (x2 = this.field_145851_c - xPos; x2 < this.field_145851_c - xPos + xSize; ++x2) {
                for (y2 = this.field_145848_d - yPos; y2 < this.field_145848_d - yPos + ySize; ++y2) {
                    for (z = this.field_145849_e - zPos; z < this.field_145849_e - zPos + zSize; ++z) {
                        if (this.isSameTank(this.field_145850_b.func_147438_o(x2, y2, z))) {
                            tank2 = (TileEntityTank)this.field_145850_b.func_147438_o(x2, y2, z);
                            int[] tankSize = tank2.findArrayDimensions();
                            if (xSize == tankSize[0] && ySize == tankSize[1] && zSize == tankSize[2]) continue;
                            return false;
                        }
                        return false;
                    }
                }
            }
            for (x2 = this.field_145851_c - xPos; x2 < this.field_145851_c - xPos + xSize; ++x2) {
                for (y2 = this.field_145848_d - yPos; y2 < this.field_145848_d - yPos + ySize; ++y2) {
                    for (z = this.field_145849_e - zPos; z < this.field_145849_e - zPos + zSize; ++z) {
                        tank2 = (TileEntityTank)this.field_145850_b.func_147438_o(x2, y2, z);
                        if (!tank2.isMultiBlock()) continue;
                        tank2.breakMultiBlock();
                    }
                }
            }
            int lvl = 0;
            for (x = this.field_145851_c - xPos; x < this.field_145851_c - xPos + xSize; ++x) {
                for (y = this.field_145848_d - yPos; y < this.field_145848_d - yPos + ySize; ++y) {
                    for (int z2 = this.field_145849_e - zPos; z2 < this.field_145849_e - zPos + zSize; ++z2) {
                        tank = (TileEntityTank)this.field_145850_b.func_147438_o(x, y, z2);
                        lvl = tank.fluidLevel + lvl;
                    }
                }
            }
            this.connectedTanks = xSize * ySize * zSize;
            for (x = this.field_145851_c - xPos; x < this.field_145851_c - xPos + xSize; ++x) {
                for (y = this.field_145848_d - yPos; y < this.field_145848_d - yPos + ySize; ++y) {
                    for (int z3 = this.field_145849_e - zPos; z3 < this.field_145849_e - zPos + zSize; ++z3) {
                        tank = (TileEntityTank)this.field_145850_b.func_147438_o(x, y, z3);
                        tank.connectedTanks = xSize * ySize * zSize;
                        tank.setFluidLevel(lvl);
                        tank.syncToClient(true);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public void breakMultiBlock() {
        int lvl = this.fluidLevel;
        int xPos = this.getXPosition();
        int yPos = this.getYPosition();
        int zPos = this.getZPosition();
        int xSize = this.getXSize();
        int ySize = this.getYSize();
        int zSize = this.getZSize();
        int[] levels = new int[ySize];
        int area = xSize * zSize;
        for (int i = 0; i < levels.length; ++i) {
            levels[i] = lvl / area >= this.getSingleCapacity() ? this.getSingleCapacity() : lvl / area;
            lvl = lvl - levels[i] * area < 0 ? 0 : lvl - levels[i] * area;
        }
        for (int x = 0; x < xSize; ++x) {
            for (int y = 0; y < ySize; ++y) {
                for (int z = 0; z < zSize; ++z) {
                    TileEntityTank tank = (TileEntityTank)this.field_145850_b.func_147438_o(this.field_145851_c - xPos + x, this.field_145848_d - yPos + y, this.field_145849_e - zPos + z);
                    tank.connectedTanks = 1;
                    tank.fluidLevel = levels[y];
                    tank.syncToClient(true);
                }
            }
        }
    }

    public void syncFluidLevels() {
        int zSize;
        int ySize;
        int lvl = this.fluidLevel;
        int xPos = this.getXPosition();
        int yPos = this.getYPosition();
        int zPos = this.getZPosition();
        int xSize = this.getXSize();
        if (xSize * (ySize = this.getYSize()) * (zSize = this.getZSize()) != 1) {
            for (int x = this.field_145851_c - xPos; x < this.field_145851_c - xPos + xSize; ++x) {
                for (int y = this.field_145848_d - yPos; y < this.field_145848_d - yPos + ySize; ++y) {
                    for (int z = this.field_145849_e - zPos; z < this.field_145849_e - zPos + zSize; ++z) {
                        if (this.field_145850_b.func_147438_o(x, y, z) == null || !(this.field_145850_b.func_147438_o(x, y, z) instanceof TileEntityTank)) continue;
                        TileEntityTank tank = (TileEntityTank)this.field_145850_b.func_147438_o(x, y, z);
                        tank.fluidLevel = lvl;
                        if (tank.getYPosition() != 0) continue;
                        tank.syncToClient(false);
                    }
                }
            }
        } else {
            this.syncToClient(false);
        }
    }

    private int findArrayXPosition() {
        if (this.isSameTank(this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e))) {
            return ((TileEntityTank)this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e)).findArrayXPosition() + 1;
        }
        return 0;
    }

    private int findArrayYPosition() {
        if (this.isSameTank(this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e))) {
            return ((TileEntityTank)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)).findArrayYPosition() + 1;
        }
        return 0;
    }

    private int findArrayZPosition() {
        if (this.isSameTank(this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1))) {
            return ((TileEntityTank)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1)).findArrayZPosition() + 1;
        }
        return 0;
    }

    private int findArrayXSize() {
        if (this.isSameTank(this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e))) {
            return ((TileEntityTank)this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e)).findArrayXSize();
        }
        return this.findArrayXPosition() + 1;
    }

    private int findArrayYSize() {
        if (this.isSameTank(this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e))) {
            return ((TileEntityTank)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)).findArrayYSize();
        }
        return this.findArrayYPosition() + 1;
    }

    private int findArrayZSize() {
        if (this.isSameTank(this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1))) {
            return ((TileEntityTank)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1)).findArrayZSize();
        }
        return this.findArrayZPosition() + 1;
    }

    private int[] findArrayDimensions() {
        int[] size = new int[]{this.findArrayXSize(), this.findArrayYSize(), this.findArrayZSize()};
        return size;
    }

    public int getXPosition() {
        if (this.isMultiBlockPartner(this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e))) {
            return ((TileEntityTank)this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e)).getXPosition() + 1;
        }
        return 0;
    }

    public int getYPosition() {
        if (this.isMultiBlockPartner(this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e))) {
            return ((TileEntityTank)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)).getYPosition() + 1;
        }
        return 0;
    }

    public int getZPosition() {
        if (this.isMultiBlockPartner(this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1))) {
            return ((TileEntityTank)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1)).getZPosition() + 1;
        }
        return 0;
    }

    public int getXSize() {
        if (this.isMultiBlockPartner(this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e))) {
            return ((TileEntityTank)this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e)).getXSize();
        }
        return this.getXPosition() + 1;
    }

    public int getYSize() {
        if (this.isMultiBlockPartner(this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e))) {
            return ((TileEntityTank)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)).getYSize();
        }
        return this.getYPosition() + 1;
    }

    public int getZSize() {
        if (this.isMultiBlockPartner(this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1))) {
            return ((TileEntityTank)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1)).getZSize();
        }
        return this.getZPosition() + 1;
    }

    public int[] getDimensions() {
        int[] size = new int[]{this.getXSize(), this.getYSize(), this.getZSize()};
        return size;
    }

    public FluidStack getContents() {
        return new FluidStack(FluidRegistry.WATER, this.fluidLevel);
    }

    public int getFluidLevel() {
        return this.fluidLevel;
    }

    public int getDiscreteFluidLevel() {
        float discreteFactor = 32.0f / (float)this.getSingleCapacity();
        int discreteFluidLevel = Math.round(discreteFactor * (float)this.fluidLevel);
        if (discreteFluidLevel == 0 && this.fluidLevel > 0) {
            discreteFluidLevel = 1;
        }
        return discreteFluidLevel;
    }

    public int getScaledDiscreteFluidLevel() {
        float scaleFactor = (float)this.getSingleCapacity() / 32.0f;
        int discreteFluidLevel = this.getDiscreteFluidLevel();
        return Math.round(scaleFactor * (float)discreteFluidLevel);
    }

    public float getScaledDiscreteFluidY() {
        return this.getFluidY(this.getScaledDiscreteFluidLevel());
    }

    public float getFluidY() {
        return this.getFluidY(this.fluidLevel);
    }

    public float getFluidY(int volume) {
        int totalHeight = 16 * this.getYSize() - 2;
        return (float)totalHeight * (float)volume / (float)this.getTotalCapacity() + 2.0f;
    }

    public void setFluidLevel(int lvl) {
        if (lvl != this.fluidLevel) {
            this.fluidLevel = lvl > this.getTotalCapacity() ? this.getTotalCapacity() : lvl;
            this.syncFluidLevels();
        }
    }

    public int getSingleCapacity() {
        return (this.func_145832_p() + 1) * 8 * 1000;
    }

    public int getTotalCapacity() {
        return this.getSingleCapacity() * this.connectedTanks;
    }

    public boolean isFull() {
        return this.fluidLevel == this.getTotalCapacity();
    }

    public boolean isEmpty() {
        return this.fluidLevel == 0;
    }

    public int fill(ForgeDirection from, int amount, boolean doFill) {
        return this.fill(from, new FluidStack(FluidRegistry.WATER, amount), doFill);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null || !this.canFill(from, resource.getFluid())) {
            return 0;
        }
        int filled = Math.min(resource.amount, this.getTotalCapacity() - this.getFluidLevel());
        if (doFill) {
            this.setFluidLevel(this.getFluidLevel() + filled);
        }
        return filled;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !this.canDrain(from, resource.getFluid())) {
            return null;
        }
        int drained = Math.min(resource.amount, this.getFluidLevel());
        if (doDrain) {
            this.setFluidLevel(this.fluidLevel - drained);
        }
        return new FluidStack(FluidRegistry.WATER, drained);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(from, new FluidStack(FluidRegistry.WATER, maxDrain), doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == FluidRegistry.WATER && !this.isFull();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return fluid == FluidRegistry.WATER && !this.isEmpty();
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] info = new FluidTankInfo[]{new FluidTankInfo(this.getContents(), this.getTotalCapacity())};
        return info;
    }

    @Override
    public void addDebugInfo(List<String> list) {
        list.add("TANK:");
        list.add("Tank: " + (this.isWood() ? "wood" : "iron") + " (single capacity: " + this.getSingleCapacity() + ")");
        list.add("  - MultiBlock: " + this.isMultiBlock());
        list.add("  - Connected tanks: " + this.getConnectedTanks());
        int[] size = this.getDimensions();
        list.add("  - MultiBlock Size: " + size[0] + "x" + size[1] + "x" + size[2]);
        list.add("  - FluidLevel: " + this.getFluidLevel() + "/" + this.getTotalCapacity());
        list.add("  - FluidHeight: " + this.getFluidY());
        boolean left = this.isMultiBlockPartner(this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e));
        boolean right = this.isMultiBlockPartner(this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e));
        boolean back = this.isMultiBlockPartner(this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1));
        boolean front = this.isMultiBlockPartner(this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1));
        boolean top = this.isMultiBlockPartner(this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e));
        boolean below = this.isMultiBlockPartner(this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e));
        list.add("  - Found multiblock partners on: " + (left ? "left, " : "") + (right ? "right, " : "") + (back ? "back, " : "") + (front ? "front, " : "") + (top ? "top, " : "") + (below ? "below" : ""));
        list.add("Water level is on layer " + (int)Math.floor(((float)this.getFluidLevel() - 0.1f) / (float)(this.getSingleCapacity() * this.getXSize() * this.getZSize())) + ".");
        list.add("this clicked is on  layer " + this.getYPosition() + ".");
        list.add("Water height is " + this.getFluidY());
    }
}

