/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.utility;

import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public abstract class NBTHelper {
    public static NBTTagCompound getMaterialTag(ItemStack stack) {
        String name;
        NBTTagCompound tag = null;
        if (stack != null && stack.func_77973_b() != null && (name = Block.field_149771_c.func_148750_c((Object)((ItemBlock)stack.func_77973_b()).field_150939_a)) != null && !name.equals("")) {
            tag = new NBTTagCompound();
            tag.func_74778_a("material", name);
            tag.func_74768_a("matMeta", stack.func_77960_j());
        }
        return tag;
    }

    public static boolean listContainsStack(NBTTagList list, ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return true;
        }
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tagAtIndex = list.func_150305_b(i);
            ItemStack stackAtIndex = ItemStack.func_77949_a((NBTTagCompound)tagAtIndex);
            if (stack.func_77973_b() != stackAtIndex.func_77973_b() || stack.func_77960_j() != stackAtIndex.func_77960_j()) continue;
            return true;
        }
        return false;
    }

    public static void addCoordsToNBT(int[] coords, NBTTagCompound tag) {
        if (coords != null && coords.length == 3) {
            NBTHelper.addCoordsToNBT(coords[0], coords[1], coords[2], tag);
        }
    }

    public static void addCoordsToNBT(int x, int y, int z, NBTTagCompound tag) {
        tag.func_74768_a("agricraftX", x);
        tag.func_74768_a("agricraftY", y);
        tag.func_74768_a("agricraftZ", z);
    }

    public static int[] getCoordsFromNBT(NBTTagCompound tag) {
        int[] coords = null;
        if (tag.func_74764_b("agricraftX") && tag.func_74764_b("agricraftY") && tag.func_74764_b("agricraftZ")) {
            coords = new int[]{tag.func_74762_e("agricraftX"), tag.func_74762_e("agricraftY"), tag.func_74762_e("agricraftZ")};
        }
        return coords;
    }

    public static void sortStacks(NBTTagList list) {
        NBTHelper.clearEmptyStacksFromNBT(list);
        if (list.func_74745_c() < 2) {
            return;
        }
        ItemStack[] array = new ItemStack[list.func_74745_c()];
        for (int i = 0; i < array.length; ++i) {
            int index = 0;
            ItemStack first = ItemStack.func_77949_a((NBTTagCompound)list.func_150305_b(index));
            for (int j = 0; j < list.func_74745_c(); ++j) {
                String stackAtIndexName;
                ItemStack stackAtIndex = ItemStack.func_77949_a((NBTTagCompound)list.func_150305_b(j));
                String firstName = first.func_82833_r().equalsIgnoreCase("Seeds") ? "Wheat Seeds" : first.func_82833_r();
                String string = stackAtIndexName = stackAtIndex.func_82833_r().equalsIgnoreCase("Seeds") ? "Wheat Seeds" : stackAtIndex.func_82833_r();
                if (firstName.compareToIgnoreCase(stackAtIndexName) <= 0) continue;
                first = stackAtIndex;
                index = j;
            }
            array[i] = first;
            list.func_74744_a(index);
        }
        for (ItemStack stack : array) {
            NBTTagCompound tag = new NBTTagCompound();
            stack.func_77955_b(tag);
            list.func_74742_a((NBTBase)tag);
        }
    }

    public static void clearEmptyStacksFromNBT(NBTTagList list) {
        for (int i = list.func_74745_c() - 1; i >= 0; --i) {
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)list.func_150305_b(i));
            if (stack != null && stack.func_77973_b() != null) continue;
            list.func_74744_a(i);
        }
    }
}

