/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.utility;

import com.InfinityRaider.AgriCraft.init.Items;
import com.InfinityRaider.AgriCraft.utility.BlockWithMeta;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public abstract class OreDictHelper {
    private static final Map<String, Block> oreBlocks = new HashMap<String, Block>();
    private static final Map<String, Item> oreItems = new HashMap<String, Item>();
    private static final Map<String, Integer> oreMetaData = new HashMap<String, Integer>();
    private static final List<String> oreNames = Arrays.asList("oreCopper", "oreTin", "oreLead", "oreSilver", "oreAluminum", "oreNickel", "orePlatinum", "oreOsmium");
    private static final List<String> nuggetNames = Arrays.asList("nuggetDiamond", "nuggetEmerald", "nuggetIron", "nuggetCopper", "nuggetTin", "nuggetLead", "nuggetSilver", "nuggetAluminum", "nuggetNickel", "nuggetPlatinum", "nuggetOsmium");
    public static Block oreCopper;
    public static Block oreTin;
    public static Block oreLead;
    public static Block oreSilver;
    public static Block oreAluminum;
    public static Block oreNickel;
    public static Block orePlatinum;
    public static Block oreOsmium;
    public static int oreCopperMeta;
    public static int oreTinMeta;
    public static int oreLeadMeta;
    public static int oreSilverMeta;
    public static int oreAluminumMeta;
    public static int oreNickelMeta;
    public static int orePlatinumMeta;
    public static int oreOsmiumMeta;

    public static Block getOreBlockForName(String name) {
        return oreBlocks.get(name);
    }

    public static int getOreMetaDataForName(String name) {
        return oreMetaData.get(name);
    }

    public static boolean hasOreId(ItemStack stack, String tag) {
        int[] ids;
        for (int id : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
            if (!OreDictionary.getOreName((int)id).equals(tag)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSameOre(BlockWithMeta block1, Block block2, int meta2) {
        return OreDictHelper.isSameOre(block1.getBlock(), block1.getMeta(), block2, meta2);
    }

    public static boolean isSameOre(Block block1, int meta1, Block block2, int meta2) {
        if (block1 == block2 && meta1 == meta2) {
            return true;
        }
        if (block1 == null || block2 == null) {
            return false;
        }
        int[] ids1 = OreDictionary.getOreIDs((ItemStack)new ItemStack(block1, 1, meta1));
        int[] ids2 = OreDictionary.getOreIDs((ItemStack)new ItemStack(block2, 1, meta2));
        for (int id1 : ids1) {
            for (int id2 : ids2) {
                if (id1 != id2) continue;
                return true;
            }
        }
        return false;
    }

    public static ItemStack getIngot(String nugget) {
        ArrayList entries;
        ItemStack ingot = null;
        if (nugget.length() > 6 && (entries = OreDictionary.getOres((String)("ingot." + nugget.substring(6)))).size() > 0 && ((ItemStack)entries.get(0)).func_77973_b() != null) {
            ingot = (ItemStack)entries.get(0);
        }
        return ingot;
    }

    public static void getRegisteredOres() {
        OreDictHelper.registerOres();
        OreDictHelper.registerNuggets();
        OreDictHelper.initializeOreBlockFields();
        OreDictHelper.initializeNuggetFields();
    }

    private static void registerOres() {
        block0: for (String oreName : oreNames) {
            for (ItemStack itemStack : OreDictionary.getOres((String)oreName)) {
                if (!(itemStack.func_77973_b() instanceof ItemBlock)) continue;
                ItemBlock block = (ItemBlock)itemStack.func_77973_b();
                oreBlocks.put(oreName, block.field_150939_a);
                oreMetaData.put(oreName, itemStack.func_77960_j());
                continue block0;
            }
        }
    }

    private static void registerNuggets() {
        for (String nuggetName : nuggetNames) {
            ArrayList nuggets = OreDictionary.getOres((String)nuggetName);
            if (nuggets.isEmpty()) continue;
            Item nugget = ((ItemStack)nuggets.get(0)).func_77973_b();
            oreItems.put(nuggetName, nugget);
            oreMetaData.put(nuggetName, ((ItemStack)nuggets.get(0)).func_77960_j());
        }
    }

    private static void initializeOreBlockFields() {
        oreCopper = oreBlocks.get("oreCopper");
        if (oreCopper != null) {
            oreCopperMeta = oreMetaData.get("oreCopper");
        }
        if ((oreTin = oreBlocks.get("oreTin")) != null) {
            oreTinMeta = oreMetaData.get("oreTin");
        }
        if ((oreLead = oreBlocks.get("oreLead")) != null) {
            oreLeadMeta = oreMetaData.get("oreLead");
        }
        if ((oreSilver = oreBlocks.get("oreSilver")) != null) {
            oreSilverMeta = oreMetaData.get("oreSilver");
        }
        if ((oreAluminum = oreBlocks.get("oreAluminum")) != null) {
            oreAluminumMeta = oreMetaData.get("oreAluminum");
        }
        if ((oreNickel = oreBlocks.get("oreNickel")) != null) {
            oreNickelMeta = oreMetaData.get("oreNickel");
        }
        if ((orePlatinum = oreBlocks.get("orePlatinum")) != null) {
            orePlatinumMeta = oreMetaData.get("orePlatinum");
        }
        if ((oreOsmium = oreBlocks.get("oreOsmium")) != null) {
            oreOsmiumMeta = oreMetaData.get("oreOsmium");
        }
    }

    private static void initializeNuggetFields() {
        Items.nuggetDiamond = oreItems.get("nuggetDiamond");
        if (Items.nuggetDiamond != null) {
            Items.nuggetDiamondMeta = oreMetaData.get("nuggetDiamond");
        }
        if ((Items.nuggetEmerald = oreItems.get("nuggetEmerald")) != null) {
            Items.nuggetEmeraldMeta = oreMetaData.get("nuggetEmerald");
        }
        if ((Items.nuggetIron = oreItems.get("nuggetIron")) != null) {
            Items.nuggetIronMeta = oreMetaData.get("nuggetIron");
        }
        if ((Items.nuggetCopper = oreItems.get("nuggetCopper")) != null) {
            Items.nuggetCopperMeta = oreMetaData.get("nuggetCopper");
        }
        if ((Items.nuggetTin = oreItems.get("nuggetTin")) != null) {
            Items.nuggetTinMeta = oreMetaData.get("nuggetTin");
        }
        if ((Items.nuggetLead = oreItems.get("nuggetLead")) != null) {
            Items.nuggetLeadMeta = oreMetaData.get("nuggetLead");
        }
        if ((Items.nuggetSilver = oreItems.get("nuggetSilver")) != null) {
            Items.nuggetSilverMeta = oreMetaData.get("nuggetSilver");
        }
        if ((Items.nuggetAluminum = oreItems.get("nuggetAluminum")) != null) {
            Items.nuggetAluminumMeta = oreMetaData.get("nuggetAluminum");
        }
        if ((Items.nuggetNickel = oreItems.get("nuggetNickel")) != null) {
            Items.nuggetNickelMeta = oreMetaData.get("nuggetNickel");
        }
        Items.nuggetEmerald = oreItems.get("nuggetEmerald");
        if (Items.nuggetPlatinum != null) {
            Items.nuggetEmeraldMeta = oreMetaData.get("nuggetEmerald");
        }
        if ((Items.nuggetOsmium = oreItems.get("nuggetOsmium")) != null) {
            Items.nuggetOsmiumMeta = oreMetaData.get("nuggetOsmium");
        }
    }
}

