/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.utility;

import chococraft.common.items.seeds.ItemGysahlSeeds;
import com.InfinityRaider.AgriCraft.compatibility.ModIntegration;
import com.InfinityRaider.AgriCraft.compatibility.chococraft.ChococraftHelper;
import com.InfinityRaider.AgriCraft.compatibility.natura.NaturaHelper;
import com.InfinityRaider.AgriCraft.compatibility.plantmegapack.PlantMegaPackHelper;
import com.InfinityRaider.AgriCraft.compatibility.psychedelicraft.PsychedelicraftHelper;
import com.InfinityRaider.AgriCraft.items.ItemModSeed;
import com.InfinityRaider.AgriCraft.utility.LogHelper;
import com.InfinityRaider.AgriCraft.utility.SeedHelper;
import ivorius.psychedelicraft.blocks.IvTilledFieldPlant;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemSeeds;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;

public abstract class RenderHelper {
    public static ResourceLocation getResource(Block block, int meta) {
        return RenderHelper.getBlockResource(RenderHelper.getIcon(block, meta));
    }

    public static ResourceLocation getResource(Item item, int meta) {
        return RenderHelper.getItemResource(RenderHelper.getIcon(item, meta));
    }

    public static IIcon getIcon(Item item, int meta) {
        if (item instanceof ItemBlock) {
            return ((ItemBlock)item).field_150939_a.func_149691_a(3, meta);
        }
        return item.func_77617_a(meta);
    }

    public static IIcon getIcon(Block block, int meta) {
        return block.func_149691_a(0, meta);
    }

    public static ResourceLocation getBlockResource(IIcon icon) {
        String path = icon.func_94215_i();
        String domain = path.substring(0, path.indexOf(":") + 1);
        String file = path.substring(path.indexOf(58) + 1);
        return new ResourceLocation(domain + "textures/blocks/" + file + ".png");
    }

    public static ResourceLocation getItemResource(IIcon icon) {
        String path = icon.func_94215_i();
        String domain = path.substring(0, path.indexOf(":") + 1);
        String file = path.substring(path.indexOf(58) + 1);
        return new ResourceLocation(domain + "textures/items/" + file + ".png");
    }

    public static int getRenderType(ItemSeeds seed, int meta) {
        String name;
        Block plant = SeedHelper.getPlant(seed);
        int renderType = plant.func_149645_b();
        if (ModIntegration.LoadedMods.natura && (name = Item.field_150901_e.func_148750_c((Object)seed)).indexOf(58) >= 0 && name.substring(0, name.indexOf(58)).equalsIgnoreCase("Natura")) {
            renderType = meta == 0 ? 6 : 1;
        }
        return renderType;
    }

    public static int plantIconIndex(ItemSeeds seed, int seedMeta, int growthMeta) {
        Block plant = null;
        try {
            plant = seed.getPlant(null, 0, 0, 0);
        }
        catch (Exception e) {
            LogHelper.debug("Couldn't grab plant");
        }
        if (seed instanceof ItemModSeed) {
            return growthMeta;
        }
        if (ModIntegration.LoadedMods.natura && SeedHelper.getPlantDomain(seed).equalsIgnoreCase("natura")) {
            return NaturaHelper.getTextureIndex(growthMeta, seedMeta);
        }
        if (ModIntegration.LoadedMods.plantMegaPack && SeedHelper.getPlantDomain(seed).equalsIgnoreCase("plantmegapack")) {
            return PlantMegaPackHelper.getTextureIndex(seed, growthMeta);
        }
        if (ModIntegration.LoadedMods.chococraft && seed instanceof ItemGysahlSeeds) {
            return ChococraftHelper.transformMeta(growthMeta);
        }
        if (ModIntegration.LoadedMods.psychedelicraft && plant != null && plant instanceof IvTilledFieldPlant) {
            return PsychedelicraftHelper.transformMeta(growthMeta);
        }
        if (seed == Items.field_151075_bm) {
            return (int)Math.ceil(((float)growthMeta - 2.0f) / 2.0f);
        }
        return growthMeta;
    }

    public static boolean isLeverFacingBlock(int leverMeta, char axis, int direction) {
        if (axis == 'x') {
            if (direction > 0) {
                return leverMeta % 8 == 1;
            }
            return leverMeta % 8 == 2;
        }
        if (axis == 'z') {
            if (direction > 0) {
                return leverMeta % 8 == 3;
            }
            return leverMeta % 8 == 4;
        }
        return false;
    }

    public static void addScaledVertexWithUV(Tessellator tessellator, float x, float y, float z, float u, float v) {
        float unit = 0.0625f;
        tessellator.func_78374_a((double)(x * unit), (double)(y * unit), (double)(z * unit), (double)(u * unit), (double)(v * unit));
    }

    public static void addScaledVertexWithUV(Tessellator tessellator, float x, float y, float z, float u, float v, IIcon icon) {
        float unit = 0.0625f;
        tessellator.func_78374_a((double)(x * unit), (double)(y * unit), (double)(z * unit), (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)v));
    }

    public static void drawScaledPrism(Tessellator tessellator, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, IIcon icon) {
        RenderHelper.addScaledVertexWithUV(tessellator, maxX, maxY, minZ, maxX, 16.0f - maxY, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, maxX, minY, minZ, maxX, 16.0f - minY, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, minX, minY, minZ, minX, 16.0f - minY, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, minX, maxY, minZ, minX, 16.0f - maxY, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, maxX, maxY, maxZ, maxX, 16.0f - maxY, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, minX, maxY, maxZ, minX, 16.0f - maxY, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, minX, minY, maxZ, minX, 16.0f - minY, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, maxX, minY, maxZ, maxX, 16.0f - minY, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, maxX, maxY, maxZ, maxZ, 16.0f - maxY, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, maxX, minY, maxZ, maxZ, 16.0f - minY, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, maxX, minY, minZ, minZ, 16.0f - minY, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, maxX, maxY, minZ, minZ, 16.0f - maxY, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, minX, maxY, maxZ, maxZ, 16.0f - maxY, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, minX, maxY, minZ, minZ, 16.0f - maxY, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, minX, minY, minZ, minZ, 16.0f - minY, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, minX, minY, maxZ, maxZ, 16.0f - minY, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, maxX, maxY, maxZ, maxX, maxZ, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, maxX, maxY, minZ, maxX, minZ, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, minX, maxY, minZ, minX, minZ, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, minX, maxY, maxZ, minX, maxZ, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, maxX, minY, maxZ, maxX, maxZ, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, minX, minY, maxZ, minX, maxZ, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, minX, minY, minZ, minX, minZ, icon);
        RenderHelper.addScaledVertexWithUV(tessellator, maxX, minY, minZ, maxX, minZ, icon);
    }

    public static void drawPrism(Tessellator tessellator, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, IIcon icon) {
        RenderHelper.drawScaledPrism(tessellator, minX * 16.0f, minY * 16.0f, minZ * 16.0f, maxX * 16.0f, maxY * 16.0f, maxZ * 16.0f, icon);
    }
}

