/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.utility;

import chococraft.common.items.seeds.ItemGysahlSeeds;
import com.InfinityRaider.AgriCraft.blocks.BlockModPlant;
import com.InfinityRaider.AgriCraft.compatibility.ModIntegration;
import com.InfinityRaider.AgriCraft.compatibility.chococraft.ChococraftHelper;
import com.InfinityRaider.AgriCraft.compatibility.plantmegapack.PlantMegaPackHelper;
import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import com.InfinityRaider.AgriCraft.init.Crops;
import com.InfinityRaider.AgriCraft.items.ItemModSeed;
import com.InfinityRaider.AgriCraft.reference.SeedInformation;
import com.InfinityRaider.AgriCraft.utility.IOHelper;
import com.InfinityRaider.AgriCraft.utility.LogHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mods.natura.common.NContent;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public abstract class SeedHelper {
    private static List<ItemStack> seedBlackList;
    private static HashMap<ItemSeeds, Integer[]> spreadChances;
    private static HashMap<ItemSeeds, Integer[]> seedTiers;

    public static void init() {
        SeedHelper.initSeedBlackList();
        SeedHelper.initSpreadChancesOverrides();
        SeedHelper.initTiers();
    }

    private static void initSeedBlackList() {
        String[] data = IOHelper.getLinesArrayFromData(ConfigurationHandler.readSeedBlackList());
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (String line : data) {
            LogHelper.debug(new StringBuffer("parsing ").append(line));
            ItemStack seedStack = IOHelper.getStack(line);
            Item seed = seedStack != null ? seedStack.func_77973_b() : null;
            boolean success = seed != null && seed instanceof ItemSeeds;
            String errorMsg = "Invalid seed";
            if (success) {
                list.add(seedStack);
                continue;
            }
            LogHelper.info(new StringBuffer("Error when adding seed to blacklist: ").append(errorMsg).append(" (line: ").append(line).append(")"));
        }
        seedBlackList = list;
        LogHelper.info("Registered seeds blacklist:");
        for (ItemStack seed : seedBlackList) {
            LogHelper.info(new StringBuffer(" - ").append(Item.field_150901_e.func_148750_c((Object)seed.func_77973_b())).append(":").append(seed.func_77960_j()));
        }
    }

    private static void initSpreadChancesOverrides() {
        SeedHelper.setMutationChances(IOHelper.getLinesArrayFromData(ConfigurationHandler.readSpreadChances()));
        LogHelper.info("Registered Mutations Chances overrides:");
        for (Map.Entry<ItemSeeds, Integer[]> entry : spreadChances.entrySet()) {
            for (int i = 0; i < entry.getValue().length; ++i) {
                Integer chance = entry.getValue()[i];
                if (chance == null) continue;
                StringBuffer override = new StringBuffer(" - ").append(Item.field_150901_e.func_148750_c((Object)entry.getKey())).append(':').append(i).append(" - ").append(chance).append(" percent");
                LogHelper.info(override);
            }
        }
    }

    private static void initTiers() {
        SeedHelper.setSeedTiers(IOHelper.getLinesArrayFromData(ConfigurationHandler.readSeedTiers()));
        LogHelper.info("Registered seed tiers:");
        for (Map.Entry<ItemSeeds, Integer[]> entry : seedTiers.entrySet()) {
            for (int i = 0; i < entry.getValue().length; ++i) {
                Integer tier = entry.getValue()[i];
                if (tier == null) continue;
                StringBuffer override = new StringBuffer(" - ").append(Item.field_150901_e.func_148750_c((Object)entry.getKey())).append(':').append(i).append(" - tier:").append(tier);
                LogHelper.info(override);
            }
        }
    }

    private static void setMutationChances(String[] input) {
        spreadChances = new HashMap();
        LogHelper.debug("reading mutation chance overrides");
        for (String line : input) {
            String[] data = IOHelper.getData(line);
            boolean success = data.length == 2;
            String errorMsg = "Incorrect amount of arguments";
            LogHelper.debug("parsing " + line);
            if (success) {
                ItemStack seedStack = IOHelper.getStack(data[0]);
                Item seedItem = seedStack != null ? seedStack.func_77973_b() : null;
                success = seedItem != null && seedItem instanceof ItemSeeds;
                errorMsg = "Invalid seed";
                if (success) {
                    int chance = Integer.parseInt(data[1]);
                    success = chance >= 0 && chance <= 100;
                    errorMsg = "Chance should be between 0 and 100";
                    if (success) {
                        ItemSeeds seed = (ItemSeeds)seedStack.func_77973_b();
                        if (spreadChances.get(seed) == null) {
                            spreadChances.put(seed, new Integer[16]);
                        }
                        SeedHelper.spreadChances.get((Object)seed)[seedStack.func_77960_j()] = chance;
                    }
                }
            }
            if (success) continue;
            LogHelper.info(new StringBuffer("Error when adding mutation chance override: ").append(errorMsg).append(" (line: ").append(line).append(")"));
        }
    }

    private static void setSeedTiers(String[] input) {
        seedTiers = new HashMap();
        LogHelper.debug("reading seed tier overrides");
        for (String line : input) {
            String[] data = IOHelper.getData(line);
            boolean success = data.length == 2;
            String errorMsg = "Incorrect amount of arguments";
            LogHelper.debug("parsing " + line);
            if (success) {
                ItemStack seedStack = IOHelper.getStack(data[0]);
                Item seedItem = seedStack != null ? seedStack.func_77973_b() : null;
                success = seedItem != null && seedItem instanceof ItemSeeds;
                errorMsg = "Invalid seed";
                if (success) {
                    int tier = Integer.parseInt(data[1]);
                    success = tier >= 1 && tier <= 5;
                    errorMsg = "Chance should be between 1 and 5";
                    if (success) {
                        ItemSeeds seed = (ItemSeeds)seedStack.func_77973_b();
                        if (seedTiers.get(seed) == null) {
                            seedTiers.put(seed, new Integer[16]);
                        }
                        SeedHelper.seedTiers.get((Object)seed)[seedStack.func_77960_j()] = tier;
                    }
                }
            }
            if (success) continue;
            LogHelper.info(new StringBuffer("Error when adding seed tier override: ").append(errorMsg).append(" (line: ").append(line).append(")"));
        }
    }

    public static double getSpreadChance(ItemSeeds seed, int meta) {
        Integer[] value = spreadChances.get(seed);
        if (value != null && value.length > meta && value[meta] != null) {
            return (double)value[meta].intValue() / 100.0;
        }
        return 1.0 / (double)SeedHelper.getSeedTier(seed, meta);
    }

    public static int getSeedTier(ItemSeeds seed, int meta) {
        Integer tier;
        if (seed == null) {
            return 0;
        }
        Integer[] tierArray = seedTiers.get(seed);
        if (tierArray != null && tierArray.length > meta && (tier = seedTiers.get(seed)[meta]) != null) {
            return tier;
        }
        if (seed instanceof ItemModSeed) {
            return ((ItemModSeed)seed).getPlant().tier;
        }
        String domain = Item.field_150901_e.func_148750_c((Object)seed).substring(0, Item.field_150901_e.func_148750_c((Object)seed).indexOf(58));
        if (domain.equalsIgnoreCase("harvestcraft")) {
            return 2;
        }
        if (domain.equalsIgnoreCase("natura")) {
            return 2;
        }
        if (domain.equalsIgnoreCase("magicalcrops")) {
            return 4;
        }
        if (domain.equalsIgnoreCase("plantmegapack")) {
            return 2;
        }
        if (domain.equalsIgnoreCase("weeeflowers")) {
            return 2;
        }
        return 1;
    }

    public static int getBaseGrowth(int tier) {
        switch (tier) {
            case 1: {
                return 50;
            }
            case 2: {
                return 45;
            }
            case 3: {
                return 30;
            }
            case 4: {
                return 25;
            }
            case 5: {
                return 20;
            }
        }
        return 0;
    }

    public static Block getPlant(ItemSeeds seed) {
        if (seed == null) {
            return null;
        }
        if (seed == Items.field_151081_bc) {
            return Crops.melon;
        }
        if (seed == Items.field_151080_bb) {
            return Crops.pumpkin;
        }
        return seed.getPlant(null, 0, 0, 0);
    }

    public static boolean isAnalyzedSeed(ItemStack seedStack) {
        return seedStack != null && seedStack.func_77973_b() != null && seedStack.func_77973_b() instanceof ItemSeeds && seedStack.func_77942_o() && seedStack.field_77990_d.func_74764_b("analyzed") && seedStack.field_77990_d.func_74767_n("analyzed");
    }

    public static String getPlantDomain(ItemSeeds seed) {
        String name = Item.field_150901_e.func_148750_c((Object)seed);
        return name.substring(0, name.indexOf(":")).toLowerCase();
    }

    public static ArrayList<ItemStack> getPlantFruits(ItemSeeds seed, World world, int x, int y, int z, int gain, int meta) {
        Random rand;
        int nr = (int)Math.ceil(((double)gain + 0.0) / 3.0);
        Block plant = SeedHelper.getPlant(seed);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        Random random = rand = world != null ? world.field_73012_v : new Random();
        if (plant == Blocks.field_150388_bm) {
            LogHelper.debug("Getting fruit for nether wart");
            items.add(new ItemStack((Item)seed, nr, 0));
        } else if (plant instanceof BlockModPlant) {
            LogHelper.debug("Getting fruit for agricraft plant");
            items.addAll(((BlockModPlant)plant).getFruit(nr, rand));
        } else if (ModIntegration.LoadedMods.natura && SeedHelper.getPlantDomain(seed).equalsIgnoreCase("natura")) {
            LogHelper.debug("Getting fruit for natura plant");
            items.add(new ItemStack(NContent.plantItem, nr, meta * 3));
        } else if (ModIntegration.LoadedMods.chococraft && seed instanceof ItemGysahlSeeds) {
            LogHelper.debug("Getting fruit for gyshahls");
            items.add(ChococraftHelper.getFruit(gain, nr));
        } else {
            LogHelper.debug("Getting fruit from ore dictionary");
            SeedHelper.addFruitsFromOreDict(items, seed, meta, rand, nr);
        }
        if (items.size() == 0) {
            LogHelper.debug("Getting fruit from plant");
            int harvestMeta = 7;
            if (ModIntegration.LoadedMods.plantMegaPack && SeedHelper.getPlantDomain(seed).equalsIgnoreCase("plantmegapack")) {
                harvestMeta = PlantMegaPackHelper.getTextureIndex(seed, harvestMeta);
            }
            SeedHelper.addFruitsFromPlant(items, plant, world, x, y, z, harvestMeta, nr);
        }
        return items;
    }

    public static void addFruitsFromPlant(List<ItemStack> items, Block plant, World world, int x, int y, int z, int harvestMeta, int nr) {
        ArrayList defaultDrops = plant.getDrops(world, x, y, z, harvestMeta, 0);
        for (ItemStack drop : defaultDrops) {
            if (drop.func_77973_b() instanceof ItemSeeds || drop.func_77973_b() == null) continue;
            boolean add = true;
            for (ItemStack item : items) {
                if (item.func_77973_b() != drop.func_77973_b() || item.func_77960_j() != drop.func_77960_j()) continue;
                add = false;
            }
            if (!add) continue;
            items.add(new ItemStack(drop.func_77973_b(), nr, drop.func_77960_j()));
        }
    }

    public static ArrayList<ItemStack> getAllPlantFruits(ItemSeeds seed, World world, int x, int y, int z, int gain, int meta) {
        Block plant = SeedHelper.getPlant(seed);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (plant instanceof BlockModPlant) {
            items.addAll(((BlockModPlant)plant).getFruits());
        } else if (ModIntegration.LoadedMods.chococraft && seed instanceof ItemGysahlSeeds) {
            items.addAll(ChococraftHelper.getFruits());
        } else {
            items = (ArrayList<ItemStack>)SeedHelper.getFruitsFromOreDict(seed, meta);
        }
        if (items == null || items.size() == 0) {
            items = SeedHelper.getPlantFruits(seed, world, x, y, z, gain, meta);
        }
        return items;
    }

    public static void addFruitsFromOreDict(List<ItemStack> list, ItemSeeds seed, int meta, Random rand, int nr) {
        List<ItemStack> fruits = SeedHelper.getFruitsFromOreDict(seed, meta);
        if (fruits != null && fruits.size() > 0) {
            for (int counter = 0; counter < nr; ++counter) {
                ItemStack newFruit = fruits.get(rand.nextInt(fruits.size())).func_77946_l();
                newFruit.field_77994_a = 1;
                list.add(newFruit);
            }
        }
    }

    public static List<ItemStack> getFruitsFromOreDict(ItemSeeds seed, int meta) {
        for (int id : OreDictionary.getOreIDs((ItemStack)new ItemStack((Item)seed, 1, meta))) {
            if (!OreDictionary.getOreName((int)id).substring(0, 4).equalsIgnoreCase("seed")) continue;
            return OreDictionary.getOres((String)("crop" + OreDictionary.getOreName((int)id).substring(4)));
        }
        return null;
    }

    public static boolean isValidSeed(ItemSeeds seed, int meta) {
        if (ModIntegration.LoadedMods.thaumicTinkerer && SeedHelper.getPlantDomain(seed).equalsIgnoreCase("ThaumicTinkerer")) {
            LogHelper.debug("Thaumic Tinkerer infused seeds are not supported, sorry");
            return false;
        }
        for (ItemStack blacklistedSeed : seedBlackList) {
            if (blacklistedSeed.func_77973_b() != seed || blacklistedSeed.func_77960_j() != meta) continue;
            return false;
        }
        return true;
    }

    public static int getBaseGrowth(ItemSeeds seed, int meta) {
        return SeedHelper.getBaseGrowth(SeedHelper.getSeedTier(seed, meta));
    }

    public static void setNBT(NBTTagCompound tag, short growth, short gain, short strength, boolean analyzed) {
        tag.func_74777_a("growth", (short)(growth == 0 ? 1 : (growth > 10 ? 10 : (int)growth)));
        tag.func_74777_a("gain", (short)(gain == 0 ? 1 : (gain > 10 ? 10 : (int)gain)));
        tag.func_74777_a("strength", (short)(strength == 0 ? 1 : (strength > 10 ? 10 : (int)strength)));
        tag.func_74757_a("analyzed", analyzed);
    }

    public static String getSeedInformation(ItemStack seedStack) {
        if (!(seedStack.func_77973_b() instanceof ItemSeeds)) {
            return null;
        }
        return SeedInformation.getSeedInformation(seedStack);
    }

    public static ItemStack getRandomSeed(boolean setTag) {
        ArrayList seeds = OreDictionary.getOres((String)"listAllseed");
        ItemStack seed = null;
        while (seed == null || !(seed.func_77973_b() instanceof ItemSeeds) || !SeedHelper.isValidSeed((ItemSeeds)seed.func_77973_b(), seed.func_77960_j())) {
            seed = (ItemStack)seeds.get((int)Math.floor(Math.random() * (double)seeds.size()));
        }
        if (setTag) {
            int gain = (int)Math.ceil(Math.random() * 7.0);
            int growth = (int)Math.ceil(Math.random() * 7.0);
            int strength = (int)Math.ceil(Math.random() * 7.0);
            NBTTagCompound tag = new NBTTagCompound();
            SeedHelper.setNBT(tag, (short)growth, (short)gain, (short)strength, false);
            seed.field_77990_d = tag;
        }
        return seed;
    }

    public static void addAllToSeedBlacklist(Collection<? extends ItemStack> seeds) {
        seedBlackList.addAll(seeds);
    }

    public static void removeAllFromSeedBlacklist(Collection<? extends ItemStack> seeds) {
        seedBlackList.removeAll(seeds);
    }

    public static int overrideSpreadChance(ItemSeeds seed, int meta, int chance) {
        int oldChance = (int)(SeedHelper.getSpreadChance(seed, meta) * 100.0);
        Integer[] chances = spreadChances.get(seed);
        if (chances == null) {
            chances = new Integer[16];
            spreadChances.put(seed, chances);
        }
        chances[meta] = chance;
        return oldChance;
    }

    public static boolean isValidSeedStack(ItemStack stack) {
        return stack != null && stack.func_77973_b() != null && stack.func_77973_b() instanceof ItemSeeds && SeedHelper.isValidSeed((ItemSeeds)stack.func_77973_b(), stack.func_77960_j());
    }
}

