/*
 * Decompiled with CFR 0.152.
 */
package com.temportalist.weepingangels.common.lib;

import com.temportalist.origin.api.client.utility.Rendering$;
import com.temportalist.origin.api.common.lib.LogHelper$;
import com.temportalist.origin.api.common.lib.V3O;
import com.temportalist.origin.api.common.utility.WorldHelper$;
import com.temportalist.weepingangels.common.WAOptions$;
import com.temportalist.weepingangels.common.entity.EntityAngel;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import org.apache.commons.io.IOUtils;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.FloatRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class AngelUtility$ {
    public static final AngelUtility$ MODULE$;

    static {
        new AngelUtility$();
    }

    public boolean canBeSeen_Multiplayer(World world, EntityLivingBase entity, AxisAlignedBB boundingBox, double radius) {
        if (WorldHelper$.MODULE$.getLightLevel((Entity)entity) <= 1) {
            return false;
        }
        if (boundingBox == null) {
            LogHelper$.MODULE$.warn("weepingangels", (Object)new StringBuilder().append((Object)"Error: null bounding box on ").append((Object)entity.func_70005_c_()).toString());
            return true;
        }
        return this.canBeSeen(world, entity, boundingBox, radius, EntityPlayer.class) || this.canBeSeen(world, entity, boundingBox, radius, EntityAngel.class);
    }

    public boolean canBeSeen(World world, EntityLivingBase entity, AxisAlignedBB boundingBox, double radius, Class<? extends EntityLivingBase> clazz) {
        return !this.getLookingList(world, entity, boundingBox, radius, clazz).isEmpty();
    }

    public List<EntityLivingBase> getLookingList(World world, EntityLivingBase entity, AxisAlignedBB boundingBox, double radius, Class<? extends EntityLivingBase> clazz) {
        List entityList = world.func_72872_a(clazz, boundingBox.func_72314_b(radius, radius, radius));
        ArrayList<EntityLivingBase> lookingList = new ArrayList<EntityLivingBase>();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), entityList.size()).foreach((Function1)new Serializable(entity, entityList, lookingList){
            private final EntityLivingBase entity$2;
            private final List entityList$1;
            private final List lookingList$1;

            public final Object apply(int i) {
                Object object;
                EntityLivingBase e = (EntityLivingBase)this.entityList$1.get(i);
                if (AngelUtility$.MODULE$.isInFieldOfViewOf(e, this.entity$2)) {
                    EntityAngel entityAngel;
                    EntityLivingBase entityLivingBase = e;
                    Boolean bl = entityLivingBase instanceof EntityAngel ? ((entityAngel = (EntityAngel)entityLivingBase).getArmState() > 0 ? BoxesRunTime.boxToBoolean((boolean)this.lookingList$1.add(entityAngel)) : BoxedUnit.UNIT) : BoxesRunTime.boxToBoolean((boolean)this.lookingList$1.add(e));
                    object = bl;
                } else {
                    object = BoxedUnit.UNIT;
                }
                return object;
            }
            {
                this.entity$2 = entity$2;
                this.entityList$1 = entityList$1;
                this.lookingList$1 = lookingList$1;
            }
        });
        return lookingList;
    }

    public EntityLivingBase getEntityLooking(World world, EntityLivingBase entity, AxisAlignedBB boundingBox, double radius, Class<? extends EntityLivingBase> clazz) {
        EntityLivingBase entityLivingBase;
        if (boundingBox == null) {
            return null;
        }
        List<EntityLivingBase> lookingList = this.getLookingList(world, entity, boundingBox, radius, clazz);
        if (lookingList.isEmpty()) {
            entityLivingBase = null;
        } else {
            ObjectRef retEntity = ObjectRef.create(null);
            FloatRef retDistance = FloatRef.create((float)((float)radius));
            FloatRef lookingDistance = FloatRef.create((float)0.0f);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), lookingList.size()).foreach$mVc$sp((Function1)new Serializable(entity, lookingList, retEntity, retDistance, lookingDistance){
                private final EntityLivingBase entity$1;
                private final List lookingList$2;
                private final ObjectRef retEntity$1;
                private final FloatRef retDistance$1;
                private final FloatRef lookingDistance$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    EntityLivingBase entityLivingBase = (EntityLivingBase)this.lookingList$2.get(i);
                    if (entityLivingBase instanceof EntityPlayer) {
                        BoxedUnit boxedUnit;
                        this.lookingDistance$1.elem = this.entity$1.func_70032_d((Entity)this.lookingList$2.get(i));
                        if (this.lookingDistance$1.elem < this.retDistance$1.elem) {
                            this.retDistance$1.elem = this.lookingDistance$1.elem;
                            this.retEntity$1.elem = (EntityLivingBase)this.lookingList$2.get(i);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                    } else {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
                {
                    this.entity$1 = entity$1;
                    this.lookingList$2 = lookingList$2;
                    this.retEntity$1 = retEntity$1;
                    this.retDistance$1 = retDistance$1;
                    this.lookingDistance$1 = lookingDistance$1;
                }
            });
            entityLivingBase = (EntityLivingBase)retEntity.elem;
        }
        return entityLivingBase;
    }

    @Deprecated
    public boolean isInFieldOfViewOf(EntityLivingBase viewer, EntityLivingBase viewed) {
        V3O entityLookVec = new V3O(viewer.func_70676_i(1.0f));
        V3O thisEntityPos = new V3O((Entity)viewed).$plus(new V3O(0.0, (double)viewed.field_70131_O, 0.0));
        V3O entityPos = new V3O((Entity)viewer).$plus(new V3O(0.0, (double)viewer.func_70047_e(), 0.0));
        V3O differenceVec = thisEntityPos.$minus(entityPos);
        double lengthVec = differenceVec.magnitude();
        V3O differenceVec_normal = differenceVec.normalize();
        double d1 = entityLookVec.dotProduct(differenceVec_normal);
        return d1 > 0.975 / lengthVec && viewed.func_70685_l((Entity)viewer);
    }

    public List<?> getNearbyAngels(EntityLivingBase entity) {
        return entity.field_70170_p.func_72872_a(EntityAngel.class, entity.func_70046_E().func_72314_b(20.0, 20.0, 20.0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canAttackEntityFrom(World world, DamageSource source, float damage) {
        if (source == null) {
            return false;
        }
        DamageSource damageSource = source;
        DamageSource damageSource2 = DamageSource.field_76377_j;
        if (damageSource == null ? damageSource2 != null : !damageSource.equals(damageSource2)) {
            DamageSource damageSource3 = source;
            DamageSource damageSource4 = DamageSource.field_76376_m;
            if (damageSource3 == null ? damageSource4 != null : !damageSource3.equals(damageSource4)) {
                if (!source.field_76373_n.equals("player")) return false;
            }
        }
        boolean bl = true;
        boolean validSources = bl;
        if (!validSources) return false;
        Entity entity = source.func_76364_f();
        if (!(entity instanceof EntityPlayer)) return true;
        EntityPlayer entityPlayer = (EntityPlayer)entity;
        boolean canDamage = false;
        ItemStack heldStack = entityPlayer.field_71071_by.func_70448_g();
        if (!WAOptions$.MODULE$.angelsOnlyHurtWithPickaxe()) return true;
        if (heldStack != null) {
            Block blockLevel = Blocks.field_150346_d;
            EnumDifficulty enumDifficulty = world.field_73013_u;
            EnumDifficulty enumDifficulty2 = EnumDifficulty.PEACEFUL;
            if (!(enumDifficulty != null ? !enumDifficulty.equals(enumDifficulty2) : enumDifficulty2 != null)) {
                blockLevel = Blocks.field_150346_d;
            } else {
                EnumDifficulty enumDifficulty3 = world.field_73013_u;
                EnumDifficulty enumDifficulty4 = EnumDifficulty.EASY;
                if (!(enumDifficulty3 != null ? !enumDifficulty3.equals(enumDifficulty4) : enumDifficulty4 != null)) {
                    blockLevel = Blocks.field_150366_p;
                } else {
                    EnumDifficulty enumDifficulty5 = world.field_73013_u;
                    EnumDifficulty enumDifficulty6 = EnumDifficulty.NORMAL;
                    if (!(enumDifficulty5 != null ? !enumDifficulty5.equals(enumDifficulty6) : enumDifficulty6 != null)) {
                        blockLevel = Blocks.field_150482_ag;
                    } else {
                        EnumDifficulty enumDifficulty7 = world.field_73013_u;
                        EnumDifficulty enumDifficulty8 = EnumDifficulty.HARD;
                        if (!(enumDifficulty7 != null ? !enumDifficulty7.equals(enumDifficulty8) : enumDifficulty8 != null)) {
                            blockLevel = Blocks.field_150343_Z;
                        }
                    }
                }
            }
            if (heldStack.func_77973_b().canHarvestBlock(blockLevel, heldStack)) return true;
            if (!heldStack.func_77973_b().canHarvestBlock(blockLevel, heldStack)) return false;
            return true;
        }
        if (!canDamage) return false;
        return true;
    }

    public int getDecrepitation(int age) {
        if (age <= 0) {
            return 0;
        }
        return WAOptions$.MODULE$.maxDecrepitation_amount() - age / WAOptions$.MODULE$.ticksPerDecrepitation();
    }

    @SideOnly(value=Side.CLIENT)
    public int getTextureIDFromCorruption(boolean isAngry, int corruption, int hash2) {
        int n;
        BufferedImage image = this.decrepitize(isAngry ? WAOptions$.MODULE$.weepingAngel2() : WAOptions$.MODULE$.weepingAngel1(), corruption, hash2);
        try {
            SimpleTexture obj = new SimpleTexture(null);
            obj.func_147631_c();
            TextureUtil.func_110989_a((int)obj.func_110552_b(), (BufferedImage)image, (boolean)false, (boolean)false);
            n = obj.func_110552_b();
        }
        catch (Exception exception) {
            n = -1;
        }
        return n;
    }

    @SideOnly(value=Side.CLIENT)
    public BufferedImage decrepitize(ResourceLocation angelTex, int corruption, int hash2) {
        InputStream stream = Rendering$.MODULE$.mc().func_110442_L().func_110536_a(angelTex).func_110527_b();
        BufferedImage image = ImageIO.read(stream);
        IOUtils.closeQuietly((InputStream)stream);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), corruption).foreach$mVc$sp((Function1)new Serializable(hash2, image){
            private final int hash$1;
            private final BufferedImage image$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Random rand = new Random(this.hash$1 * i);
                int x = rand.nextInt(this.image$1.getWidth());
                int y = rand.nextInt(this.image$1.getHeight());
                this.image$1.setRGB(x, y, new Color(this.image$1.getRGB(x, y)).darker().getRGB());
            }
            {
                this.hash$1 = hash$1;
                this.image$1 = image$1;
            }
        });
        return image;
    }

    private AngelUtility$() {
        MODULE$ = this;
    }
}

