/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.render;

import com.enderio.core.api.client.render.VertexTransform;
import com.enderio.core.common.vecmath.Vector3d;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.model.TexturedQuad;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.obj.Face;
import net.minecraftforge.client.model.obj.GroupObject;
import net.minecraftforge.client.model.obj.TextureCoordinate;
import net.minecraftforge.client.model.obj.Vertex;
import net.minecraftforge.client.model.obj.WavefrontObject;
import net.minecraftforge.client.model.techne.TechneModel;
import net.minecraftforge.client.model.techne.TechneModelLoader;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;
import org.lwjgl.util.vector.Vector4f;

public class TechneUtil {
    public static VertexTransform vt = null;
    private static final TechneModelLoader modelLoader = new TechneModelLoader();
    private static final Tessellator tes = Tessellator.field_78398_a;

    public static List<GroupObject> bakeModel(ModelRenderer model, TechneModel supermodel) {
        return TechneUtil.bakeModel(model, supermodel, 1.0f);
    }

    public static List<GroupObject> bakeModel(ModelRenderer model, TechneModel supermodel, float scale) {
        return TechneUtil.bakeModel(model, supermodel, scale, new Matrix4f());
    }

    public static List<GroupObject> bakeModel(ModelRenderer model, TechneModel supermodel, float scale, Matrix4f matrix) {
        return TechneUtil.bakeModel(model, supermodel, scale, matrix, false);
    }

    public static List<GroupObject> bakeModel(ModelRenderer model, TechneModel supermodel, float scale, Matrix4f matrix, boolean rotateYFirst) {
        float uCorrection = (int)model.field_78801_a / supermodel.field_78090_t;
        float vCorrection = (int)model.field_78799_b / supermodel.field_78089_u;
        Matrix4f m = new Matrix4f(matrix);
        m.translate(new Vector3f(model.field_82906_o + model.field_78800_c * scale, model.field_82908_p + model.field_78797_d * scale, model.field_82907_q + model.field_78798_e * scale));
        if (!rotateYFirst) {
            m.rotate(model.field_78808_h, new Vector3f(0.0f, 0.0f, 1.0f));
        }
        m.rotate(model.field_78796_g, new Vector3f(0.0f, 1.0f, 0.0f));
        m.rotate(model.field_78795_f, new Vector3f(1.0f, 0.0f, 0.0f));
        if (rotateYFirst) {
            m.rotate(model.field_78808_h, new Vector3f(0.0f, 0.0f, 1.0f));
        }
        Vector4f vec = new Vector4f();
        ArrayList<GroupObject> res = new ArrayList<GroupObject>();
        for (ModelBox box : model.field_78804_l) {
            GroupObject obj = new GroupObject("", 7);
            TexturedQuad[] quads = (TexturedQuad[])ObfuscationReflectionHelper.getPrivateValue(ModelBox.class, (Object)box, (String[])new String[]{"quadList", "field_78254_i"});
            for (int i = 0; i < quads.length; ++i) {
                PositionTextureVertex pv;
                int j;
                Face face = new Face();
                face.vertices = new Vertex[4];
                face.textureCoordinates = new TextureCoordinate[4];
                float minU = -1.0f;
                float minV = -1.0f;
                for (j = 0; j < 4; ++j) {
                    pv = quads[i].field_78239_a[j];
                    if (minU < 0.0f || minU > pv.field_78241_b) {
                        minU = pv.field_78241_b;
                    }
                    if (!(minV < 0.0f) && !(minV > pv.field_78242_c)) continue;
                    minV = pv.field_78242_c;
                }
                for (j = 0; j < 4; ++j) {
                    pv = quads[i].field_78239_a[j];
                    vec.x = (float)pv.field_78243_a.field_72450_a * scale;
                    vec.y = (float)pv.field_78243_a.field_72448_b * scale;
                    vec.z = (float)pv.field_78243_a.field_72449_c * scale;
                    vec.w = 1.0f;
                    Matrix4f.transform((Matrix4f)m, (Vector4f)vec, (Vector4f)vec);
                    face.vertices[j] = new Vertex(vec.x / vec.w, vec.y / vec.w, vec.z / vec.w);
                    float u = pv.field_78241_b == minU ? pv.field_78241_b / uCorrection + 1.0E-4f : pv.field_78241_b / uCorrection - 1.0E-4f;
                    float v = pv.field_78242_c == minV ? pv.field_78242_c / vCorrection + 1.0E-4f : pv.field_78242_c / vCorrection - 1.0E-4f;
                    face.textureCoordinates[j] = new TextureCoordinate(u, v);
                }
                face.faceNormal = face.calculateFaceNormal();
                obj.faces.add(face);
            }
            res.add(obj);
        }
        return res;
    }

    public static Map<String, GroupObject> bakeModel(TechneModel model) {
        return TechneUtil.bakeModel(model, 1.0f);
    }

    public static Map<String, GroupObject> bakeModel(TechneModel model, float scale) {
        return TechneUtil.bakeModel(model, scale, new Matrix4f());
    }

    public static Map<String, GroupObject> bakeModel(TechneModel model, float scale, Matrix4f m) {
        return TechneUtil.bakeModel(model, scale, m, false);
    }

    public static Map<String, GroupObject> bakeModel(TechneModel model, float scale, Matrix4f m, boolean rotateYFirst) {
        Map parts = (Map)ObfuscationReflectionHelper.getPrivateValue(TechneModel.class, (Object)model, (String[])new String[]{"parts"});
        HashMap res = Maps.newHashMap();
        for (Map.Entry e : parts.entrySet()) {
            GroupObject obj = TechneUtil.bakeModel((ModelRenderer)e.getValue(), model, scale, m, rotateYFirst).get(0);
            res.put(e.getKey(), obj);
        }
        return res;
    }

    public static Map<String, GroupObject> getModel(String modid, String modelPath) {
        TechneModel tm = (TechneModel)modelLoader.loadInstance(new ResourceLocation(modid.toLowerCase(), modelPath + ".tcn"));
        return TechneUtil.bakeModel(tm, 0.0625f, new Matrix4f().scale(new Vector3f(-1.0f, -1.0f, 1.0f)));
    }

    public static Collection<GroupObject> getModelAll(String modid, String modelPath) {
        TechneModel tm = (TechneModel)modelLoader.loadInstance(new ResourceLocation(modid.toLowerCase(), modelPath + ".tcn"));
        return TechneUtil.bakeModel(tm, 0.0625f, new Matrix4f().scale(new Vector3f(-1.0f, -1.0f, 1.0f))).values();
    }

    public static void renderWithIcon(WavefrontObject model, IIcon icon, Tessellator tes) {
        TechneUtil.renderWithIcon(model.groupObjects, icon, null, tes);
    }

    public static void renderWithIcon(Collection<GroupObject> model, IIcon icon, IIcon override, Tessellator tes) {
        TechneUtil.renderWithIcon(model, icon, override, tes, null);
    }

    public static void renderWithIcon(Collection<GroupObject> model, IIcon icon, IIcon override, Tessellator tes, VertexTransform vt) {
        TechneUtil.renderWithIcon(model, icon, override, tes, null, 0, 0, 0, vt);
    }

    public static void renderWithIcon(Collection<GroupObject> model, IIcon icon, IIcon override, Tessellator tes, IBlockAccess world, int x, int y, int z) {
        TechneUtil.renderWithIcon(model, icon, override, tes, world, x, y, z, null);
    }

    public static void renderWithIcon(Collection<GroupObject> model, IIcon icon, IIcon override, Tessellator tes, IBlockAccess world, int x, int y, int z, VertexTransform vt) {
        TechneUtil.renderWithIcon(model, icon, override, tes, world, x, y, z, vt, true);
    }

    public static void renderWithIcon(Collection<GroupObject> model, IIcon icon, IIcon override, Tessellator tes, IBlockAccess world, int x, int y, int z, VertexTransform vt, boolean isbrh) {
        for (GroupObject go : model) {
            TechneUtil.renderWithIcon(go, icon, override, tes, world, x, y, z, vt, isbrh);
        }
    }

    public static void renderWithIcon(GroupObject go, IIcon icon, IIcon override, Tessellator tes, IBlockAccess world, int x, int y, int z, VertexTransform vt, boolean isbrh) {
        for (Face f : go.faces) {
            Vertex n = f.faceNormal;
            tes.func_78375_b(n.x, n.y, n.z);
            ForgeDirection normal = TechneUtil.getNormalFor(n);
            ForgeDirection right = normal.getRotation(ForgeDirection.DOWN);
            if (normal == right) {
                right = ForgeDirection.EAST;
            }
            ForgeDirection down = normal.getRotation(right.getOpposite());
            if (isbrh && world != null && world.func_147439_a(x, y, z).func_149717_k() > 0) {
                int bx = x + normal.offsetX;
                int by = y + normal.offsetY;
                int bz = z + normal.offsetZ;
                tes.func_78380_c(world.func_147439_a(bx, by, bz).func_149677_c(world, bx, by, bz));
            }
            for (int i = 0; i < f.vertices.length; ++i) {
                Vertex vert = f.vertices[i];
                Vector3d v = new Vector3d(vert);
                Vector3d tv = new Vector3d(v);
                tv.add(0.5, 0.0, 0.5);
                if (vt != null) {
                    vt.apply(v);
                }
                if (isbrh) {
                    float factor = normal.offsetX != 0 ? 0.8f : (normal.offsetZ != 0 ? 0.6f : (normal.offsetY < 0 ? 0.5f : 1.0f));
                    int c = (int)(255.0f * factor);
                    tes.func_78376_a(c, c, c);
                }
                if (override != null) {
                    double interpX;
                    double interpY = Math.abs(tv.x * (double)down.offsetX + tv.y * (double)down.offsetY + tv.z * (double)down.offsetZ);
                    for (interpX = Math.abs(tv.x * (double)right.offsetX + tv.y * (double)right.offsetY + tv.z * (double)right.offsetZ); interpX > 1.0; interpX -= 1.0) {
                    }
                    while (interpY > 1.0) {
                        interpY -= 1.0;
                    }
                    if (normal == ForgeDirection.SOUTH || normal == ForgeDirection.WEST) {
                        interpX = 1.0 - interpX;
                    }
                    if (normal != ForgeDirection.UP && normal != ForgeDirection.DOWN) {
                        interpY = 1.0 - interpY;
                    }
                    tes.func_78374_a(v.x, v.y, v.z, (double)override.func_94214_a(interpX * 16.0), (double)override.func_94207_b(interpY * 16.0));
                    continue;
                }
                TextureCoordinate t = f.textureCoordinates[i];
                tes.func_78374_a(v.x, v.y, v.z, TechneUtil.getInterpolatedU(icon, t.u), TechneUtil.getInterpolatedV(icon, t.v));
            }
        }
    }

    public static double getInterpolatedV(IIcon icon, double offset) {
        return (double)icon.func_94206_g() + (double)(icon.func_94210_h() - icon.func_94206_g()) * offset;
    }

    public static double getInterpolatedU(IIcon icon, double offset) {
        return (double)icon.func_94209_e() + (double)(icon.func_94212_f() - icon.func_94209_e()) * offset;
    }

    private static ForgeDirection getNormalFor(Vertex n) {
        if (n.x != 0.0f) {
            return n.x > 0.0f ? ForgeDirection.EAST : ForgeDirection.WEST;
        }
        if (n.y != 0.0f) {
            return n.y > 0.0f ? ForgeDirection.UP : ForgeDirection.DOWN;
        }
        return n.z > 0.0f ? ForgeDirection.SOUTH : ForgeDirection.NORTH;
    }

    public static void renderInventoryBlock(Collection<GroupObject> model, Block block, int metadata, RenderBlocks rb) {
        TechneUtil.renderInventoryBlock(model, TechneUtil.getIconFor(block, metadata), block, metadata, rb);
    }

    public static void renderInventoryBlock(Collection<GroupObject> model, IIcon icon, Block block, int metadata, RenderBlocks rb) {
        tes.func_78382_b();
        tes.func_78386_a(1.0f, 1.0f, 1.0f);
        tes.func_78372_c(0.0f, -0.47f, 0.0f);
        TechneUtil.renderWithIcon(model, icon, rb.field_147840_d, tes, vt);
        tes.func_78372_c(0.0f, 0.47f, 0.0f);
        tes.func_78381_a();
        TechneUtil.resetVT();
    }

    public static void renderInventoryBlock(GroupObject model, Block block, int metadata, RenderBlocks rb) {
        IIcon icon = TechneUtil.getIconFor(block, metadata);
        tes.func_78382_b();
        tes.func_78386_a(1.0f, 1.0f, 1.0f);
        tes.func_78372_c(0.0f, -0.47f, 0.0f);
        TechneUtil.renderWithIcon(model, icon, rb.field_147840_d, tes, null, 0, 0, 0, vt, true);
        tes.func_78372_c(0.0f, 0.47f, 0.0f);
        tes.func_78381_a();
        TechneUtil.resetVT();
    }

    public static boolean renderWorldBlock(Collection<GroupObject> model, IBlockAccess world, int x, int y, int z, Block block, RenderBlocks rb) {
        IIcon icon = TechneUtil.getIconFor(block, world, x, y, z);
        return TechneUtil.renderWorldBlock(model, icon, world, x, y, z, block, rb);
    }

    public static boolean renderWorldBlock(Collection<GroupObject> model, IIcon icon, IBlockAccess world, int x, int y, int z, Block block, RenderBlocks rb) {
        if (icon == null) {
            return false;
        }
        tes.func_78380_c(block.func_149677_c(world, x, y, z));
        tes.func_78386_a(1.0f, 1.0f, 1.0f);
        tes.func_78372_c((float)x + 0.5f, (float)y + 0.0375f, (float)z + 0.5f);
        TechneUtil.renderWithIcon(model, icon, rb.field_147840_d, tes, world, x, y, z, vt);
        tes.func_78372_c((float)(-x) - 0.5f, (float)(-y) - 0.0375f, (float)(-z) - 0.5f);
        TechneUtil.resetVT();
        return true;
    }

    public static boolean renderWorldBlock(GroupObject model, IBlockAccess world, int x, int y, int z, Block block, RenderBlocks rb) {
        IIcon icon = TechneUtil.getIconFor(block, world, x, y, z);
        tes.func_78380_c(block.func_149677_c(world, x, y, z));
        tes.func_78386_a(1.0f, 1.0f, 1.0f);
        tes.func_78372_c((float)x + 0.5f, (float)y + 0.0375f, (float)z + 0.5f);
        TechneUtil.renderWithIcon(model, icon, rb.field_147840_d, tes, world, x, y, z, vt, true);
        tes.func_78372_c((float)(-x) - 0.5f, (float)(-y) - 0.0375f, (float)(-z) - 0.5f);
        TechneUtil.resetVT();
        return true;
    }

    private static void resetVT() {
        vt = null;
    }

    private static IIcon getIconFor(Block block, IBlockAccess world, int x, int y, int z) {
        return block.func_149673_e(world, x, y, z, 0);
    }

    private static IIcon getIconFor(Block block, int metadata) {
        return block.func_149691_a(0, metadata);
    }
}

