/*
 * Decompiled with CFR 0.152.
 */
package openmods.events.network;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import openmods.network.DimCoord;
import openmods.network.event.NetworkEvent;
import openmods.network.event.NetworkEventManager;
import openmods.utils.WorldUtils;

public abstract class BlockEventPacket
extends NetworkEvent {
    public int dimension;
    public int xCoord;
    public int yCoord;
    public int zCoord;

    public BlockEventPacket() {
    }

    public BlockEventPacket(int dimension, int xCoord, int yCoord, int zCoord) {
        this.dimension = dimension;
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.zCoord = zCoord;
    }

    public BlockEventPacket(TileEntity tile) {
        this(tile.func_145831_w().field_73011_w.field_76574_g, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
    }

    @Override
    protected void readFromStream(DataInput input) throws IOException {
        this.dimension = input.readInt();
        this.xCoord = input.readInt();
        this.yCoord = input.readInt();
        this.zCoord = input.readInt();
    }

    @Override
    protected void writeToStream(DataOutput output) throws IOException {
        output.writeInt(this.dimension);
        output.writeInt(this.xCoord);
        output.writeInt(this.yCoord);
        output.writeInt(this.zCoord);
    }

    @Override
    protected void appendLogInfo(List<String> info) {
        info.add(String.format("%d -> %d,%d,%d", this.dimension, this.xCoord, this.yCoord, this.zCoord));
    }

    public void sendToWatchers() {
        NetworkEventManager.INSTANCE.dispatcher().senders.block.sendMessage((Object)this, this.getDimCoords());
    }

    public DimCoord getDimCoords() {
        return new DimCoord(this.dimension, this.xCoord, this.yCoord, this.zCoord);
    }

    public World getWorld() {
        return WorldUtils.getWorld(this.dimension);
    }
}

