/*
 * Decompiled with CFR 0.152.
 */
package openmods.structured;

import com.google.common.base.Throwables;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Sets;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import java.io.DataInput;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeSet;
import openmods.structured.Command;
import openmods.structured.IStructureContainer;
import openmods.structured.IStructureContainerFactory;
import openmods.structured.IStructureElement;
import openmods.structured.StructuredData;

public abstract class StructuredDataSlave<C extends IStructureContainer<E>, E extends IStructureElement>
extends StructuredData<C, E> {
    public final IStructureContainerFactory<C> factory;

    protected StructuredDataSlave(IStructureContainerFactory<C> factory) {
        this.factory = factory;
    }

    protected abstract void onConsistencyCheckFail();

    protected void onElementUpdated(E element) {
    }

    protected void onUpdate() {
    }

    public void interpretCommandList(List<Command> commands) {
        HashMultimap updatedContainers = HashMultimap.create();
        for (Command command : commands) {
            try {
                Command msg;
                if (command.isEnd()) break;
                if (command instanceof Command.ConsistencyCheck) {
                    int maxElementId;
                    msg = (Command.ConsistencyCheck)command;
                    NavigableSet containers = this.containerToElement.keySet();
                    int containerCount = containers.size();
                    int minContainerId = containerCount == 0 ? 0 : (Integer)containers.first();
                    int maxContainerId = containerCount == 0 ? 0 : (Integer)containers.last();
                    int elementCount = this.elements.size();
                    int minElementId = elementCount == 0 ? 0 : (Integer)this.elements.firstKey();
                    int n = maxElementId = elementCount == 0 ? 0 : (Integer)this.elements.lastKey();
                    if (msg.containerCount == containerCount && msg.minContainerId == minContainerId && msg.maxContainerId == maxContainerId && msg.elementCount == elementCount && msg.minElementId == minElementId && msg.maxElementId == maxElementId) continue;
                    throw new ConsistencyCheckFailed("Validation packet not matched");
                }
                if (command instanceof Command.Reset) {
                    this.reset();
                    continue;
                }
                if (command instanceof Command.Create) {
                    msg = (Command.Create)command;
                    TreeSet elements = Sets.newTreeSet();
                    for (Command.ContainerInfo info : ((Command.Create)msg).containers) {
                        SortedSet<Integer> newElementsId = this.addReplaceContainer(info.type, info.id, info.start);
                        elements.addAll(newElementsId);
                        updatedContainers.putAll((Object)info.id, newElementsId);
                    }
                    this.readPayload(elements, ((Command.Create)msg).payload);
                    continue;
                }
                if (command instanceof Command.Delete) {
                    msg = (Command.Delete)command;
                    Iterator i$ = ((Command.Delete)msg).idList.iterator();
                    while (i$.hasNext()) {
                        int i = (Integer)i$.next();
                        this.removeContainer(i);
                    }
                    continue;
                }
                if (!(command instanceof Command.Update)) continue;
                msg = (Command.Update)command;
                this.readPayload(((Command.Update)msg).idList, ((Command.Update)msg).payload);
                for (Integer elementId : ((Command.Update)msg).idList) {
                    Integer containerId = (Integer)this.elementToContainer.get(elementId);
                    if (containerId == null) {
                        throw new ConsistencyCheckFailed("Orphaned element %d", elementId);
                    }
                    updatedContainers.put((Object)containerId, (Object)elementId);
                }
            }
            catch (ConsistencyCheckFailed e) {
                this.onConsistencyCheckFail();
                break;
            }
        }
        if (!updatedContainers.isEmpty()) {
            this.onUpdate();
        }
        for (Map.Entry entry : updatedContainers.asMap().entrySet()) {
            IStructureContainer container = (IStructureContainer)this.containers.get(entry.getKey());
            container.onUpdate();
            for (Integer elementId : (Collection)entry.getValue()) {
                IStructureElement element = (IStructureElement)this.elements.get(elementId);
                this.onElementUpdated(element);
                container.onElementUpdated(element);
            }
        }
    }

    private SortedSet<Integer> addReplaceContainer(int type, int containerId, int start) {
        C container = this.factory.createContainer(containerId, type);
        if (this.containerToElement.containsEntry((Object)containerId, (Object)start)) {
            throw new ConsistencyCheckFailed("Container %d already exists", containerId);
        }
        this.addContainer(containerId, container, start);
        return this.containerToElement.get((Object)containerId);
    }

    private void readPayload(SortedSet<Integer> ids, byte[] payload) {
        try {
            ByteArrayDataInput input = ByteStreams.newDataInput((byte[])payload);
            for (Integer id : ids) {
                IStructureElement element = (IStructureElement)this.elements.get(id);
                if (element == null) {
                    throw new ConsistencyCheckFailed("Element %d not found", id);
                }
                element.readFromStream((DataInput)input);
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static class ConsistencyCheckFailed
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ConsistencyCheckFailed(String message) {
            super(message);
        }

        public ConsistencyCheckFailed(String format, Object ... args) {
            super(String.format(format, args));
        }
    }
}

