/*
 * Decompiled with CFR 0.152.
 */
package neresources.api.utils.restrictions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import neresources.api.utils.restrictions.Type;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeRestriction {
    public static final BiomeRestriction NONE = new BiomeRestriction();
    public static final BiomeRestriction OCEAN = new BiomeRestriction(BiomeDictionary.Type.OCEAN, new BiomeDictionary.Type[0]);
    public static final BiomeRestriction PLAINS = new BiomeRestriction(BiomeDictionary.Type.PLAINS, new BiomeDictionary.Type[0]);
    public static final BiomeRestriction FOREST = new BiomeRestriction(BiomeDictionary.Type.FOREST, new BiomeDictionary.Type[0]);
    public static final BiomeRestriction SANDY = new BiomeRestriction(BiomeDictionary.Type.FOREST, new BiomeDictionary.Type[0]);
    public static final BiomeRestriction SNOWY = new BiomeRestriction(BiomeDictionary.Type.FOREST, new BiomeDictionary.Type[0]);
    public static final BiomeRestriction HILLS = new BiomeRestriction(BiomeDictionary.Type.HILLS, new BiomeDictionary.Type[0]);
    public static final BiomeRestriction MUSHROOM = new BiomeRestriction(BiomeDictionary.Type.MUSHROOM, new BiomeDictionary.Type[0]);
    public static final BiomeRestriction HOT = new BiomeRestriction(BiomeDictionary.Type.HOT, new BiomeDictionary.Type[0]);
    public static final BiomeRestriction COLD = new BiomeRestriction(BiomeDictionary.Type.COLD, new BiomeDictionary.Type[0]);
    public static final BiomeRestriction TEMPERATE = new BiomeRestriction(Type.BLACKLIST, BiomeDictionary.Type.HOT, BiomeDictionary.Type.COLD);
    public static final BiomeRestriction EXTREME_HILLS = new BiomeRestriction(Type.WHITELIST, BiomeGenBase.field_76770_e, BiomeGenBase.field_76783_v);
    private ArrayList<BiomeGenBase> biomes = new ArrayList();
    private Type type;

    public BiomeRestriction() {
        this.type = Type.NONE;
    }

    public BiomeRestriction(BiomeGenBase biome) {
        this(Type.WHITELIST, biome);
    }

    public BiomeRestriction(Type type, BiomeGenBase biome) {
        this(type, biome, new BiomeGenBase[0]);
    }

    public BiomeRestriction(BiomeGenBase biome, BiomeGenBase ... moreBiomes) {
        this(Type.WHITELIST, biome, moreBiomes);
    }

    public BiomeRestriction(Type type, BiomeGenBase biome, BiomeGenBase ... moreBiomes) {
        this.type = type;
        switch (type) {
            case NONE: {
                break;
            }
            case WHITELIST: {
                this.biomes.add(biome);
                this.biomes.addAll(Arrays.asList(moreBiomes));
                break;
            }
            default: {
                this.biomes = new ArrayList<BiomeGenBase>(Arrays.asList(BiomeGenBase.func_150565_n()));
                this.biomes.remove(biome);
                this.biomes.removeAll(Arrays.asList(moreBiomes));
            }
        }
    }

    public BiomeRestriction(BiomeDictionary.Type type, BiomeDictionary.Type ... biomeTypes) {
        this(Type.WHITELIST, type, biomeTypes);
    }

    public BiomeRestriction(Type type, BiomeDictionary.Type biomeType, BiomeDictionary.Type ... biomeTypes) {
        this.type = type;
        switch (type) {
            case NONE: {
                break;
            }
            case WHITELIST: {
                this.biomes = this.getBiomes(biomeType, biomeTypes);
                break;
            }
            default: {
                this.biomes = new ArrayList<BiomeGenBase>(Arrays.asList(BiomeGenBase.func_150565_n()));
                this.biomes.removeAll(this.getBiomes(biomeType, biomeTypes));
            }
        }
    }

    private ArrayList<BiomeGenBase> getBiomes(BiomeDictionary.Type biomeType, BiomeDictionary.Type ... biomeTypes) {
        ArrayList<Object> biomes = new ArrayList<BiomeGenBase>();
        biomes.addAll(Arrays.asList(BiomeDictionary.getBiomesForType((BiomeDictionary.Type)biomeType)));
        for (int i = 1; i < biomeTypes.length; ++i) {
            ArrayList<BiomeGenBase> newBiomes = new ArrayList<BiomeGenBase>();
            for (BiomeGenBase biome : BiomeDictionary.getBiomesForType((BiomeDictionary.Type)biomeTypes[i])) {
                if (!biomes.remove(biome)) continue;
                newBiomes.add(biome);
            }
            biomes = newBiomes;
        }
        return biomes;
    }

    public BiomeRestriction(NBTTagCompound tagCompound) {
        int[] ids;
        for (int id : ids = tagCompound.func_74759_k("biomeArray")) {
            this.biomes.add(BiomeGenBase.func_150568_d((int)id));
        }
        this.type = Type.values()[tagCompound.func_74771_c("type")];
    }

    public List<String> toStringList() {
        ArrayList<String> result = new ArrayList<String>();
        for (BiomeGenBase biome : this.biomes) {
            if (biome.field_76791_y.equals("")) continue;
            result.add("  " + biome.field_76791_y);
        }
        return result;
    }

    public NBTTagCompound writeToNBT() {
        return this.writeToNBT(new NBTTagCompound());
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        int[] ids = new int[this.biomes.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = this.biomes.get((int)i).field_76756_M;
        }
        tagCompound.func_74783_a("biomeArray", ids);
        tagCompound.func_74774_a("type", (byte)this.type.ordinal());
        return tagCompound;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BiomeRestriction) {
            BiomeRestriction other = (BiomeRestriction)obj;
            return other.biomes.size() == this.biomes.size() && other.biomes.containsAll(this.biomes);
        }
        return false;
    }

    public boolean isMergeable(BiomeRestriction other) {
        return other.type == Type.NONE || this.type != Type.NONE && !this.biomes.isEmpty() && other.biomes.containsAll(this.biomes);
    }

    public String toString() {
        return "Biomes: " + (Object)((Object)this.type) + (this.type != Type.NONE ? " - " + this.biomes.size() : "");
    }
}

