/*
 * Decompiled with CFR 0.152.
 */
package neresources.api.utils.restrictions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import neresources.api.utils.restrictions.BlockRestriction;
import neresources.api.utils.restrictions.DimensionRegistry;
import neresources.api.utils.restrictions.Type;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;

public class DimensionRestriction {
    public static final DimensionRestriction OVERWORLD = new DimensionRestriction(0);
    public static final DimensionRestriction NETHER = new DimensionRestriction(-1);
    public static final DimensionRestriction END = new DimensionRestriction(1);
    public static final DimensionRestriction NONE = new DimensionRestriction();
    private int min;
    private int max;
    private Type type;

    public DimensionRestriction() {
        this.type = Type.NONE;
    }

    public DimensionRestriction(int dim) {
        this(dim, dim);
    }

    public DimensionRestriction(Type type, int dim) {
        this(type, dim, dim);
    }

    public DimensionRestriction(int minDim, int maxDim) {
        this(Type.WHITELIST, minDim, maxDim);
    }

    public DimensionRestriction(Type type, int minDim, int maxDim) {
        this.type = type;
        this.min = Math.min(minDim, maxDim);
        this.max = Math.max(maxDim, minDim);
    }

    public DimensionRestriction(NBTTagCompound tagCompound) {
        this.type = Type.values()[tagCompound.func_74771_c("type")];
        int minDim = tagCompound.func_74762_e("min");
        int maxDim = tagCompound.func_74762_e("max");
        this.min = Math.min(minDim, maxDim);
        this.max = Math.max(maxDim, minDim);
    }

    public List<String> getValidDimensions(BlockRestriction blockRestriction, boolean getNames) {
        Set<Integer> dimensions = DimensionRegistry.getDimensions(blockRestriction);
        if (dimensions != null) {
            return this.getDimensionString(dimensions, getNames);
        }
        return this.getAltDimensionString(DimensionRegistry.getAltDimensions(), getNames);
    }

    private Set<Integer> getValidDimensions(Set<Integer> dimensions) {
        if (this.type == Type.NONE) {
            return dimensions;
        }
        TreeSet<Integer> result = new TreeSet<Integer>();
        for (int dimension : dimensions) {
            if (dimension >= this.min == (this.type == Type.WHITELIST) != dimension <= this.max) continue;
            result.add(dimension);
        }
        return result;
    }

    private List<String> getDimensionString(Set<Integer> dimensions, boolean getNames) {
        return this.getStringList(this.getValidDimensions(dimensions), getNames);
    }

    private List<String> getStringList(Set<Integer> set, boolean getNames) {
        ArrayList<String> result = new ArrayList<String>();
        int lastParsed = Integer.MIN_VALUE;
        if (getNames) {
            for (Integer i : set) {
                String dimName = DimensionRegistry.getDimensionName(i);
                if (dimName == null) continue;
                result.add("  " + dimName);
            }
        } else {
            String sResult = "";
            Iterator<Integer> itr = set.iterator();
            while (itr.hasNext()) {
                int dimension = itr.next();
                if (dimension == lastParsed + 1) {
                    if (!sResult.endsWith("-")) {
                        sResult = sResult + "-";
                    }
                    if (!itr.hasNext()) {
                        sResult = sResult + dimension;
                    }
                } else {
                    if (sResult.endsWith("-")) {
                        sResult = sResult + lastParsed;
                    }
                    sResult = sResult + (sResult.length() > 0 ? "," : "") + dimension;
                }
                lastParsed = dimension;
            }
            result.add(sResult);
        }
        return result;
    }

    private List<String> getAltDimensionString(Set<Integer> dimensions, boolean getNames) {
        TreeSet<Integer> validDimensions = new TreeSet<Integer>();
        int dimMin = Integer.MAX_VALUE;
        int dimMax = Integer.MIN_VALUE;
        for (Integer dim : dimensions) {
            if (dim < dimMin) {
                dimMin = dim;
            }
            if (dim <= dimMax) continue;
            dimMax = dim;
        }
        for (int i = Math.min(this.min, dimMin) - 1; i <= Math.max(this.max, dimMax) + 1; ++i) {
            if (dimensions.contains(i)) continue;
            validDimensions.add(i);
        }
        List<String> result = this.getStringList(this.getValidDimensions(this.type != Type.NONE ? validDimensions : dimensions), getNames);
        if (result.isEmpty()) {
            result.add(StatCollector.func_74838_a((String)"ner.dim.no"));
        }
        switch (this.type) {
            default: {
                break;
            }
            case NONE: {
                result.add(0, StatCollector.func_74838_a((String)"ner.not"));
                break;
            }
            case BLACKLIST: {
                result.add(0, "<=");
                result.add(result.size(), "=<");
            }
        }
        return result;
    }

    public NBTTagCompound writeToNBT() {
        return this.writeToNBT(new NBTTagCompound());
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("max", this.max);
        tagCompound.func_74768_a("min", this.min);
        tagCompound.func_74774_a("type", (byte)this.type.ordinal());
        return tagCompound;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DimensionRestriction) {
            DimensionRestriction other = (DimensionRestriction)obj;
            return other.min == this.min && other.max == this.max && other.type == this.type;
        }
        return false;
    }

    public boolean isMergeable(DimensionRestriction other) {
        if (other.type == Type.NONE) {
            return true;
        }
        int dimMin = Math.min(this.min, other.min) - 1;
        int dimMax = Math.max(this.max, other.max) + 1;
        TreeSet<Integer> testDimensions = new TreeSet<Integer>();
        for (int dim = dimMin; dim <= dimMax; ++dim) {
            testDimensions.add(dim);
        }
        Set<Integer> thisValidDimensions = this.getValidDimensions(testDimensions);
        Set<Integer> otherValidDimensions = other.getValidDimensions(testDimensions);
        return otherValidDimensions.containsAll(thisValidDimensions);
    }

    public String toString() {
        return "Dimension: " + (Object)((Object)this.type) + (this.type != Type.NONE ? " " + this.min + "-" + this.max : "");
    }
}

