/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.appeng.handlers;

import appeng.api.AEApi;
import appeng.api.features.IGrinderEntry;
import appeng.core.features.registries.entries.AppEngGrinderRecipe;
import java.util.LinkedList;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.appeng.AppliedEnergisticsHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.appeng.Grinder")
public class Grind {
    protected static final String name = "Applied Energistics 2 Grinder";

    @ZenMethod
    public static void addRecipe(IItemStack input, IItemStack output, int energy, @Optional IItemStack output2, @Optional float chance2, @Optional IItemStack output3, @Optional float chance3) {
        if (input == null || output == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        AppEngGrinderRecipe recipe = output2 != null && output3 != null ? new AppEngGrinderRecipe(InputHelper.toStack(input), InputHelper.toStack(output), InputHelper.toStack(output2), InputHelper.toStack(output3), chance2, chance3, energy) : (output2 != null ? new AppEngGrinderRecipe(InputHelper.toStack(input), InputHelper.toStack(output), InputHelper.toStack(output2), chance2, energy) : new AppEngGrinderRecipe(InputHelper.toStack(input), InputHelper.toStack(output), energy));
        for (IGrinderEntry r : AEApi.instance().registries().grinder().getRecipes()) {
            if (r == null || !AppliedEnergisticsHelper.equals(r, (IGrinderEntry)recipe)) continue;
            LogHelper.logWarning(String.format("Duplicate %s Recipe found for %s. Command ignored!", name, LogHelper.getStackDescription(InputHelper.toStack(input))));
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new Add((IGrinderEntry)recipe));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        if (output == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        LinkedList<IGrinderEntry> result = new LinkedList<IGrinderEntry>();
        for (IGrinderEntry entry : AEApi.instance().registries().grinder().getRecipes()) {
            if (entry == null || entry.getOutput() == null || !StackHelper.matches(output, InputHelper.toIItemStack(entry.getOutput()))) continue;
            result.add(entry);
        }
        if (!result.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(result));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", name, output.toString()));
        }
    }

    private static class Remove
    extends BaseListRemoval<IGrinderEntry> {
        public Remove(LinkedList<IGrinderEntry> recipes) {
            super(Grind.name, AEApi.instance().registries().grinder().getRecipes(), recipes);
        }

        @Override
        public String getRecipeInfo(IGrinderEntry recipe) {
            return LogHelper.getStackDescription(recipe.getInput());
        }
    }

    private static class Add
    extends BaseListAddition<IGrinderEntry> {
        public Add(IGrinderEntry recipe) {
            super(Grind.name, AEApi.instance().registries().grinder().getRecipes());
            this.recipes.add(recipe);
        }

        @Override
        public String getRecipeInfo(IGrinderEntry recipe) {
            return LogHelper.getStackDescription(recipe.getInput());
        }

        @Override
        protected boolean equals(IGrinderEntry recipe, IGrinderEntry otherRecipe) {
            return AppliedEnergisticsHelper.equals(recipe, otherRecipe);
        }
    }
}

