/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.factorization.commands;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import minetweaker.MineTweakerAPI;
import minetweaker.MineTweakerImplementationAPI;
import minetweaker.api.player.IPlayer;
import minetweaker.api.server.ICommandFunction;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.ReflectionHelper;
import modtweaker2.helpers.StringHelper;
import modtweaker2.mods.factorization.FactorizationHelper;

public class FactorizationLogger
implements ICommandFunction {
    private static final List<String> validArguments = new LinkedList<String>();

    public void execute(String[] arguments, IPlayer player) {
        List<String> args = StringHelper.toLowerCase(Arrays.asList(arguments));
        if (!validArguments.containsAll(args)) {
            if (player != null) {
                player.sendChat(MineTweakerImplementationAPI.platform.getMessage("Invalid arguments for command. Valid arguments: " + StringHelper.join(validArguments, ", ")));
            }
        } else {
            if (args.isEmpty() || args.contains("crystallizer")) {
                for (Object recipe : FactorizationHelper.crystallizer) {
                    MineTweakerAPI.logCommand((String)String.format("mods.factorization.Crystallizer.addRecipe(%s, %s, %s, %s);", LogHelper.getStackDescription(ReflectionHelper.getObject(recipe, "input")), LogHelper.getStackDescription(ReflectionHelper.getObject(recipe, "output")), LogHelper.getStackDescription(ReflectionHelper.getObject(recipe, "solution")), ReflectionHelper.getObject(recipe, "output_count")));
                }
            }
            if (args.isEmpty() || args.contains("lacerator")) {
                for (Object recipe : FactorizationHelper.lacerator) {
                    MineTweakerAPI.logCommand((String)String.format("mods.factorization.Lacerator.addRecipe(%s, %s, %s);", ReflectionHelper.getObject(recipe, "oreName") != null ? LogHelper.getStackDescription(ReflectionHelper.getObject(recipe, "oreName")) : LogHelper.getStackDescription(ReflectionHelper.getObject(recipe, "itemstack")), LogHelper.getStackDescription(ReflectionHelper.getObject(recipe, "output")), ReflectionHelper.getObject(recipe, "probability")));
                }
            }
            if (args.isEmpty() || args.contains("slagfurnace")) {
                for (Object recipe : FactorizationHelper.slag) {
                    MineTweakerAPI.logCommand((String)String.format("mods.factorization.SlagFurnace.addRecipe(%s, %s, %s, %s, %s);", LogHelper.getStackDescription(ReflectionHelper.getObject(recipe, "input")), LogHelper.getStackDescription(ReflectionHelper.getObject(recipe, "output2")), ReflectionHelper.getObject(recipe, "prob2"), LogHelper.getStackDescription(ReflectionHelper.getObject(recipe, "output1")), ReflectionHelper.getObject(recipe, "prob1")));
                }
            }
            if (player != null) {
                player.sendChat(MineTweakerImplementationAPI.platform.getMessage("List generated; see minetweaker.log in your minecraft dir"));
            }
        }
    }

    static {
        validArguments.add("crystallizer");
        validArguments.add("lacerator");
        validArguments.add("slagfurnace");
    }
}

