/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.railcraft.handlers;

import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import mods.railcraft.api.crafting.IBlastFurnaceRecipe;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.railcraft.RailcraftHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.railcraft.BlastFurnace")
public class BlastFurnace {
    public static final String name = "Railcraft Blast Furnace";
    public static final String nameFuel = "Railcraft Blast Furnace (Fuel)";

    @ZenMethod
    public static void addRecipe(IItemStack input, boolean matchDamage, boolean matchNBT, int cookTime, IItemStack output) {
        if (input == null || output == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new Add(RailcraftHelper.getBlastFurnaceRecipe(InputHelper.toStack(input), matchDamage, matchNBT, cookTime, InputHelper.toStack(output))));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        if (output == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        LinkedList<IBlastFurnaceRecipe> recipes = new LinkedList<IBlastFurnaceRecipe>();
        for (IBlastFurnaceRecipe iBlastFurnaceRecipe : RailcraftHelper.furnace) {
            if (iBlastFurnaceRecipe == null || iBlastFurnaceRecipe.getOutput() == null || !StackHelper.matches(output, InputHelper.toIItemStack(iBlastFurnaceRecipe.getOutput()))) continue;
            recipes.add(iBlastFurnaceRecipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", name, output.toString()));
        }
    }

    @ZenMethod
    public static void addFuel(IIngredient itemInput) {
        if (itemInput == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        LinkedList<ItemStack> fuels = new LinkedList<ItemStack>();
        for (IItemStack item : itemInput.getItems()) {
            boolean match = false;
            for (ItemStack fuel : RailcraftHelper.fuels) {
                if (!StackHelper.matches((IIngredient)item, InputHelper.toIItemStack(fuel))) continue;
                match = true;
                break;
            }
            if (match || !TileEntityFurnace.func_145954_b((ItemStack)InputHelper.toStack(item))) continue;
            fuels.add(InputHelper.toStack(item));
        }
        if (!fuels.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new AddFuels(fuels));
        } else {
            LogHelper.logWarning(String.format("No %s added.", nameFuel));
        }
    }

    @ZenMethod
    private static void removeFuel(IIngredient itemInput) {
        LinkedList<ItemStack> fuels = new LinkedList<ItemStack>();
        for (ItemStack fuel : RailcraftHelper.fuels) {
            if (!StackHelper.matches(itemInput, InputHelper.toIItemStack(fuel))) continue;
            fuels.add(fuel);
        }
        if (!fuels.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveFuels(fuels));
        } else {
            LogHelper.logWarning(String.format("No %s found for argument %s.", nameFuel, itemInput.toString()));
        }
    }

    private static class RemoveFuels
    extends BaseListRemoval<ItemStack> {
        public RemoveFuels(List<ItemStack> fuels) {
            super(BlastFurnace.nameFuel, RailcraftHelper.fuels, fuels);
        }

        @Override
        protected String getRecipeInfo(ItemStack recipe) {
            return LogHelper.getStackDescription(recipe);
        }
    }

    private static class AddFuels
    extends BaseListAddition<ItemStack> {
        public AddFuels(List<ItemStack> fuels) {
            super(BlastFurnace.nameFuel, RailcraftHelper.fuels, fuels);
        }

        @Override
        protected String getRecipeInfo(ItemStack recipe) {
            return LogHelper.getStackDescription(recipe);
        }
    }

    private static class Remove
    extends BaseListRemoval<IBlastFurnaceRecipe> {
        public Remove(List<IBlastFurnaceRecipe> recipes) {
            super(BlastFurnace.name, RailcraftHelper.furnace, recipes);
        }

        @Override
        public String getRecipeInfo(IBlastFurnaceRecipe recipe) {
            return LogHelper.getStackDescription(recipe.getOutput());
        }
    }

    private static class Add
    extends BaseListAddition<IBlastFurnaceRecipe> {
        public Add(IBlastFurnaceRecipe recipe) {
            super(BlastFurnace.name, RailcraftHelper.furnace);
            this.recipes.add(recipe);
        }

        @Override
        public String getRecipeInfo(IBlastFurnaceRecipe recipe) {
            return LogHelper.getStackDescription(recipe.getOutput());
        }
    }
}

