/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.particle;

import com.brandon3055.draconicevolution.client.handler.ResourceHandler;
import com.brandon3055.draconicevolution.common.blocks.multiblock.IIsSlave;
import com.brandon3055.draconicevolution.common.blocks.multiblock.MultiblockHelper;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.reactor.TileReactorCore;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.reactor.TileReactorEnergyInjector;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.reactor.TileReactorStabilizer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;

public class ParticleReactorBeam
extends EntityFX {
    private boolean renderParticle = true;
    private TileEntity tile;
    private boolean isInjectorBeam = false;

    public ParticleReactorBeam(TileEntity tile) {
        super(tile.func_145831_w(), (double)tile.field_145851_c + 0.5, (double)tile.field_145848_d + 0.5, (double)tile.field_145849_e + 0.5, 0.0, 0.0, 0.0);
        this.tile = tile;
        this.field_70552_h = 1.0f;
        this.field_70553_i = 1.0f;
        this.field_70551_j = 1.0f;
        this.field_70145_X = true;
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70547_e = 4;
        this.func_70105_a(1.0f, 1.0f);
        this.isInjectorBeam = tile instanceof TileReactorEnergyInjector;
    }

    public void update(boolean render) {
        this.renderParticle = render;
        while (this.field_70547_e - this.field_70546_d < 4) {
            ++this.field_70547_e;
        }
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_70106_y();
        }
    }

    public void func_70539_a(Tessellator tessellator, float partialTick, float rotX, float rotXZ, float rotZ, float rotYZ, float rotXY) {
        TileReactorCore reactor;
        if (!((IIsSlave)this.tile).isActive()) {
            return;
        }
        tessellator.func_78381_a();
        GL11.glPushMatrix();
        GL11.glDisable((int)2884);
        GL11.glAlphaFunc((int)516, (float)0.0f);
        float xx = (float)(this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)partialTick - field_70556_an);
        float yy = (float)(this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)partialTick - field_70554_ao);
        float zz = (float)(this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)partialTick - field_70555_ap);
        GL11.glTranslated((double)xx, (double)yy, (double)zz);
        MultiblockHelper.TileLocation master = ((IIsSlave)this.tile).getMaster();
        float offsetX = master.field_71574_a - this.tile.field_145851_c;
        float offsetY = (float)((double)master.field_71572_b - (double)this.tile.field_145848_d);
        float offsetZ = master.field_71573_c - this.tile.field_145849_e;
        float length = MathHelper.func_76129_c((float)(offsetX * offsetX + offsetY * offsetY + offsetZ * offsetZ));
        float f7 = MathHelper.func_76129_c((float)(offsetX * offsetX + offsetZ * offsetZ));
        GL11.glRotatef((float)((float)(-Math.atan2(offsetZ, offsetX)) * 180.0f / (float)Math.PI - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)((float)(-Math.atan2(f7, offsetY)) * 180.0f / (float)Math.PI - 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        TileReactorCore tileReactorCore = reactor = ((IIsSlave)this.tile).getMaster().getTileEntity(this.field_70170_p) instanceof TileReactorCore ? (TileReactorCore)((IIsSlave)this.tile).getMaster().getTileEntity(this.field_70170_p) : null;
        if (this.tile instanceof TileReactorStabilizer && reactor != null) {
            this.renderStabilizerEffect(tessellator, reactor, offsetX, offsetY, offsetZ, length, partialTick);
        } else if (reactor != null) {
            float texU;
            float verY;
            float verX;
            int i;
            GL11.glShadeModel((int)7425);
            GL11.glTranslated((double)0.0, (double)0.0, (double)0.3);
            GL11.glRotatef((float)(((float)this.field_70546_d + partialTick) * 20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            ResourceHandler.bindResource("textures/particle/reactorEnergyBeam.png");
            float sizeOrigin = 0.5f;
            int color = 0xFF2200;
            int alpha = 200;
            float speed = 20.0f;
            float texV2 = 0.0f + ((float)this.field_70546_d + partialTick) * 0.01f * speed;
            float texV1 = MathHelper.func_76129_c((float)(offsetX * offsetX + offsetY * offsetY + offsetZ * offsetZ)) + ((float)this.field_70546_d + partialTick) * 0.01f * speed;
            tessellator.func_78371_b(5);
            tessellator.func_78380_c(200);
            float sizeTarget = 0.1f;
            int b0 = 16;
            length = 0.0f;
            for (i = 0; i <= b0; ++i) {
                verX = MathHelper.func_76126_a((float)((float)(i % b0) * (float)Math.PI * 2.3f / (float)b0)) * sizeTarget;
                verY = MathHelper.func_76134_b((float)((float)(i % b0) * (float)Math.PI * 2.3f / (float)b0)) * sizeTarget;
                texU = (float)(i % b0) * 1.0f / (float)b0;
                tessellator.func_78370_a((color & 0xFF0000) >> 16, (color & 0xFF00) >> 8, color & 0xFF, 0);
                tessellator.func_78374_a((double)(verX * sizeOrigin), (double)(verY * sizeOrigin), -0.55, (double)texU, (double)texV1);
                tessellator.func_78370_a((color & 0xFF0000) >> 16, (color & 0xFF00) >> 8, color & 0xFF, alpha);
                tessellator.func_78374_a((double)verX, (double)verY, (double)length, (double)texU, (double)texV2);
            }
            length = MathHelper.func_76129_c((float)(offsetX * offsetX + offsetY * offsetY + offsetZ * offsetZ)) - (float)(reactor.getCoreDiameter() / 2.0) - 0.3f;
            sizeTarget = (float)(reactor.getCoreDiameter() / 2.0 * 0.2);
            sizeOrigin = 0.1f / sizeTarget;
            for (i = 0; i <= b0; ++i) {
                verX = MathHelper.func_76126_a((float)((float)(i % b0) * (float)Math.PI * 2.13f / (float)b0)) * sizeTarget;
                verY = MathHelper.func_76134_b((float)((float)(i % b0) * (float)Math.PI * 2.13f / (float)b0)) * sizeTarget;
                texU = (float)(i % b0) * 1.0f / (float)b0;
                tessellator.func_78370_a((color & 0xFF0000) >> 16, (color & 0xFF00) >> 8, color & 0xFF, alpha);
                tessellator.func_78374_a((double)(verX * sizeOrigin), (double)(verY * sizeOrigin), 0.0, (double)texU, (double)texV1);
                tessellator.func_78370_a((color & 0xFF0000) >> 16, (color & 0xFF00) >> 8, color & 0xFF, 0);
                tessellator.func_78374_a((double)verX, (double)verY, (double)length, (double)texU, (double)texV2);
            }
            tessellator.func_78381_a();
            GL11.glRotatef((float)(((float)this.field_70546_d + partialTick) * -30.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            tessellator.func_78371_b(5);
            tessellator.func_78380_c(200);
            color = 0xFF4400;
            sizeTarget = (float)(reactor.getCoreDiameter() / 2.0 * 0.6);
            sizeOrigin = 0.1f / sizeTarget;
            length += 0.4f;
            GL11.glTranslated((double)0.0, (double)0.0, (double)-0.1);
            for (i = 0; i <= b0; ++i) {
                verX = MathHelper.func_76126_a((float)((float)(i % b0) * (float)Math.PI * 2.13f / (float)b0)) * sizeTarget;
                verY = MathHelper.func_76134_b((float)((float)(i % b0) * (float)Math.PI * 2.13f / (float)b0)) * sizeTarget;
                texU = (float)(i % b0) * 1.0f / (float)b0;
                tessellator.func_78370_a((color & 0xFF0000) >> 16, (color & 0xFF00) >> 8, color & 0xFF, alpha / 2);
                tessellator.func_78374_a((double)(verX * sizeOrigin), (double)(verY * sizeOrigin), 0.0, (double)texU, (double)texV1);
                tessellator.func_78370_a((color & 0xFF0000) >> 16, (color & 0xFF00) >> 8, color & 0xFF, 0);
                tessellator.func_78374_a((double)verX, (double)verY, (double)length, (double)texU, (double)texV2);
            }
            tessellator.func_78381_a();
            GL11.glShadeModel((int)7424);
        }
        GL11.glPopMatrix();
        GL11.glEnable((int)2884);
        ResourceHandler.bindDefaultParticles();
        tessellator.func_78382_b();
    }

    private void renderStabilizerEffect(Tessellator tessellator, TileReactorCore reactor, float offsetX, float offsetY, float offsetZ, float length, float partialTick) {
        GL11.glShadeModel((int)7425);
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)-0.35);
        ResourceHandler.bindResource("textures/particle/reactorBeam.png");
        this.drawBeam(tessellator, reactor, 1.0f, 0.355f, 0.8f, offsetX, offsetY, offsetZ, this.field_70546_d, partialTick, true, false, 65535);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)0.45);
        float coreSize = (float)(reactor.getCoreDiameter() / 2.0) * 0.9f;
        float s = 0.355f;
        this.drawBeam(tessellator, reactor, s / coreSize, coreSize, length - (float)(reactor.getCoreDiameter() / 2.5), offsetX, offsetY, offsetZ, this.field_70546_d, partialTick, false, false, 65535);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)-0.35);
        this.drawBeam(tessellator, reactor, 1.0f, 0.263f, 0.8f, offsetX, offsetY, offsetZ, this.field_70546_d, partialTick, true, true, 0xFF6600);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)0.45);
        coreSize = (float)(reactor.getCoreDiameter() / 2.0) * 0.4f;
        s = 0.263f;
        this.drawBeam(tessellator, reactor, s / coreSize, coreSize, length - 0.5f, offsetX, offsetY, offsetZ, this.field_70546_d, partialTick, false, true, 0xFF6600);
        GL11.glPopMatrix();
        GL11.glShadeModel((int)7424);
    }

    private void drawBeam(Tessellator tessellator, TileReactorCore reactor, float sizeOrigin, float sizeTarget, float length, float offsetX, float offsetY, float offsetZ, int tick, float partialTick, boolean reverseTransparency, boolean reverseDirection, int color) {
        float speed = 3.0f;
        float texV2 = -0.1f + ((float)tick + partialTick) * (reverseDirection ? -0.01f : 0.01f) * speed;
        float texV1 = MathHelper.func_76129_c((float)(offsetX * offsetX + offsetY * offsetY + offsetZ * offsetZ)) / 32.0f + ((float)tick + partialTick) * (reverseDirection ? -0.01f : 0.01f) * speed;
        tessellator.func_78371_b(5);
        tessellator.func_78380_c(200);
        int b0 = 16;
        for (int i = 0; i <= b0; ++i) {
            float verX = MathHelper.func_76126_a((float)((float)(i % b0) * (float)Math.PI * 2.13325f / (float)b0)) * sizeTarget;
            float verY = MathHelper.func_76134_b((float)((float)(i % b0) * (float)Math.PI * 2.13325f / (float)b0)) * sizeTarget;
            float texU = (float)(i % b0) * 1.0f / (float)b0;
            tessellator.func_78370_a((color & 0xFF0000) >> 16, (color & 0xFF00) >> 8, color & 0xFF, reverseTransparency ? 0 : (int)(255.0 * (double)reactor.renderSpeed));
            tessellator.func_78374_a((double)(verX * sizeOrigin), (double)(verY * sizeOrigin), 0.0, (double)texU, (double)texV1);
            tessellator.func_78370_a((color & 0xFF0000) >> 16, (color & 0xFF00) >> 8, color & 0xFF, reverseTransparency ? (int)(255.0 * (double)reactor.renderSpeed) : 0);
            tessellator.func_78374_a((double)verX, (double)verY, (double)length, (double)texU, (double)texV2);
        }
        tessellator.func_78381_a();
    }
}

