/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.particle;

import com.brandon3055.brandonscore.common.utills.Utills;
import com.brandon3055.draconicevolution.client.handler.ResourceHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class Particles {

    public static class ReactorExplosionParticle
    extends EntityFX {
        public static IModelCustom uvSphere;
        public double size = 0.0;
        public double maxSize;

        public ReactorExplosionParticle(World world, double x, double y, double z, double maxSize) {
            super(world, x, y, z, 0.0, 0.0, 0.0);
            uvSphere = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("DraconicEvolution".toLowerCase(), "models/reactorCoreModel.obj"));
            this.maxSize = maxSize;
        }

        public void func_70071_h_() {
            if (this.field_70546_d == 3) {
                this.field_70170_p.func_72980_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, "DraconicEvolution:fusionExplosion", 100.0f, 1.0f, false);
            }
            ++this.field_70546_d;
            this.size += 1.0;
            if (this.size > this.maxSize * 1.2) {
                this.func_70106_y();
            }
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
        }

        @SideOnly(value=Side.CLIENT)
        public void func_70539_a(Tessellator tessellator, float partialTick, float par3, float par4, float par5, float par6, float par7) {
            tessellator.func_78381_a();
            GL11.glPushMatrix();
            float xx = (float)(this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)partialTick - field_70556_an);
            float yy = (float)(this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)partialTick - field_70554_ao);
            float zz = (float)(this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)partialTick - field_70555_ap);
            GL11.glTranslated((double)((double)xx + 0.5), (double)((double)yy + 0.5), (double)((double)zz + 0.5));
            GL11.glDisable((int)2884);
            GL11.glAlphaFunc((int)516, (float)0.0f);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)200.0f, (float)200.0f);
            ResourceHandler.bindResource("textures/models/white.png");
            double s = this.size + (double)(partialTick * 1.0f);
            GL11.glScaled((double)s, (double)(s / 4.0), (double)s);
            GL11.glPushMatrix();
            float a = (float)Math.max(0.0, 0.3 - this.size / this.maxSize);
            GL11.glColor4f((float)1.0f, (float)0.4f, (float)0.0f, (float)a);
            GL11.glScaled((double)5.0, (double)10.0, (double)5.0);
            if (a > 0.0f) {
                uvSphere.renderAll();
            }
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            a = (float)Math.max(0.0, 0.5 - this.size / this.maxSize * 0.5);
            GL11.glColor4f((float)1.0f, (float)0.4f, (float)0.0f, (float)a);
            GL11.glScaled((double)2.0, (double)0.2, (double)2.0);
            if (a > 0.0f) {
                uvSphere.renderAll();
            }
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            a = (float)Math.max(0.0, 0.5 - this.size / this.maxSize * 0.5);
            GL11.glColor4f((float)1.0f, (float)0.4f, (float)0.0f, (float)a);
            if (a > 0.0f) {
                uvSphere.renderAll();
            }
            GL11.glPopMatrix();
            GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
            GL11.glPushMatrix();
            a = (float)Math.max(0.0, 0.5 - this.size / this.maxSize * 0.5);
            GL11.glColor4f((float)1.0f, (float)0.4f, (float)0.0f, (float)a);
            GL11.glScaled((double)0.8, (double)0.6, (double)0.8);
            if (a > 0.0f) {
                uvSphere.renderAll();
            }
            GL11.glColor4f((float)1.0f, (float)0.5f, (float)0.1f, (float)a);
            GL11.glScaled((double)0.8, (double)0.7, (double)0.8);
            if (a > 0.0f) {
                uvSphere.renderAll();
            }
            GL11.glColor4f((float)1.0f, (float)0.6f, (float)0.25f, (float)a);
            GL11.glScaled((double)0.7, (double)0.9, (double)0.7);
            if (a > 0.0f) {
                uvSphere.renderAll();
            }
            GL11.glColor4f((float)1.0f, (float)0.7f, (float)0.4f, (float)a);
            GL11.glScaled((double)0.6, (double)0.9, (double)0.6);
            if (a > 0.0f) {
                uvSphere.renderAll();
            }
            GL11.glColor4f((float)1.0f, (float)0.8f, (float)0.55f, (float)a);
            GL11.glScaled((double)0.5, (double)0.9, (double)0.5);
            if (a > 0.0f) {
                uvSphere.renderAll();
            }
            GL11.glPopMatrix();
            for (int i = 0; i < 10; ++i) {
                GL11.glScalef((float)0.95f, (float)0.95f, (float)0.95f);
                GL11.glPushMatrix();
                a = (float)Math.max(0.0, 0.5 - this.size / this.maxSize * 0.5);
                GL11.glColor4f((float)1.0f, (float)0.4f, (float)0.0f, (float)a);
                GL11.glScaled((double)0.8, (double)0.6, (double)0.8);
                if (a > 0.0f) {
                    uvSphere.renderAll();
                }
                GL11.glColor4f((float)1.0f, (float)0.5f, (float)0.1f, (float)a);
                GL11.glScaled((double)0.8, (double)0.7, (double)0.8);
                if (a > 0.0f) {
                    uvSphere.renderAll();
                }
                GL11.glColor4f((float)1.0f, (float)0.6f, (float)0.25f, (float)a);
                GL11.glScaled((double)0.7, (double)0.9, (double)0.7);
                if (a > 0.0f) {
                    uvSphere.renderAll();
                }
                GL11.glColor4f((float)1.0f, (float)0.7f, (float)0.4f, (float)a);
                GL11.glScaled((double)0.6, (double)0.9, (double)0.6);
                if (a > 0.0f) {
                    uvSphere.renderAll();
                }
                GL11.glColor4f((float)1.0f, (float)0.8f, (float)0.55f, (float)a);
                GL11.glScaled((double)0.5, (double)0.9, (double)0.5);
                if (a > 0.0f) {
                    uvSphere.renderAll();
                }
                GL11.glPopMatrix();
            }
            GL11.glEnable((int)2884);
            GL11.glPopMatrix();
            ResourceHandler.bindDefaultParticles();
            tessellator.func_78382_b();
        }
    }

    public static class PortalParticle
    extends EntityFX {
        public double targetX;
        public double targetY;
        public double targetZ;
        public double startX;
        public double startY;
        public double startZ;
        public float baseScale;

        public PortalParticle(World world, double x, double y, double z, double tx, double ty, double tz) {
            super(world, x, y, z, 0.0, 0.0, 0.0);
            this.startX = x;
            this.startY = y;
            this.startZ = z;
            this.targetX = tx;
            this.targetY = ty;
            this.targetZ = tz;
            float speed = 0.12f + this.field_70146_Z.nextFloat() * 0.2f;
            this.field_70159_w = (this.targetX - this.startX) * (double)speed;
            this.field_70181_x = (this.targetY - this.startY) * (double)speed;
            this.field_70179_y = (this.targetZ - this.startZ) * (double)speed;
            this.field_70547_e = 100;
            this.field_70145_X = true;
            this.field_70551_j = 1.0f;
            this.field_70553_i = 1.0f;
            this.field_70552_h = 1.0f;
            float baseSize = 0.05f + (float)RenderManager.field_78727_a.field_78734_h.func_70011_f(x, y, z) * 0.007f;
            if (RenderManager.field_78727_a.field_78734_h != null) {
                this.baseScale = baseSize + this.field_70146_Z.nextFloat() * (baseSize * 2.0f);
            }
        }

        public void func_70071_h_() {
            if (this.field_70546_d >= this.field_70547_e || this.func_70092_e(this.targetX, this.targetY, this.targetZ) < 0.05) {
                this.func_70106_y();
            }
            double d1 = Utills.getDistanceAtoB((double)this.startX, (double)this.startY, (double)this.startZ, (double)this.targetX, (double)this.targetY, (double)this.targetZ);
            double d2 = Utills.getDistanceAtoB((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)this.targetX, (double)this.targetY, (double)this.targetZ);
            this.field_70544_f = (float)(d2 / d1) * this.baseScale;
            ++this.field_70546_d;
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }

        @SideOnly(value=Side.CLIENT)
        public void func_70539_a(Tessellator tesselator, float par2, float par3, float par4, float par5, float par6, float par7) {
            tesselator.func_78381_a();
            ResourceHandler.bindParticles();
            tesselator.func_78382_b();
            tesselator.func_78380_c(200);
            int uIndex = 6;
            int vIndex = 0;
            float minU = (float)uIndex * 0.125f;
            float maxU = (float)(uIndex + 1) * 0.125f;
            float minV = (float)vIndex * 0.125f;
            float maxV = (float)(vIndex + 1) * 0.125f;
            float drawScale = 0.1f * this.field_70544_f;
            if (this.field_70550_a != null) {
                minU = this.field_70550_a.func_94209_e();
                maxU = this.field_70550_a.func_94212_f();
                minV = this.field_70550_a.func_94206_g();
                maxV = this.field_70550_a.func_94210_h();
            }
            float drawX = (float)(this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)par2 - field_70556_an);
            float drawY = (float)(this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)par2 - field_70554_ao);
            float drawZ = (float)(this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)par2 - field_70555_ap);
            tesselator.func_78369_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as);
            tesselator.func_78374_a((double)(drawX - par3 * drawScale - par6 * drawScale), (double)(drawY - par4 * drawScale), (double)(drawZ - par5 * drawScale - par7 * drawScale), (double)maxU, (double)maxV);
            tesselator.func_78374_a((double)(drawX - par3 * drawScale + par6 * drawScale), (double)(drawY + par4 * drawScale), (double)(drawZ - par5 * drawScale + par7 * drawScale), (double)maxU, (double)minV);
            tesselator.func_78374_a((double)(drawX + par3 * drawScale + par6 * drawScale), (double)(drawY + par4 * drawScale), (double)(drawZ + par5 * drawScale + par7 * drawScale), (double)minU, (double)minV);
            tesselator.func_78374_a((double)(drawX + par3 * drawScale - par6 * drawScale), (double)(drawY - par4 * drawScale), (double)(drawZ + par5 * drawScale - par7 * drawScale), (double)minU, (double)maxV);
            tesselator.func_78381_a();
            ResourceHandler.bindDefaultParticles();
            tesselator.func_78382_b();
        }
    }

    public static class TransceiverParticle
    extends EntityFX {
        public double targetX;
        public double targetY;
        public double targetZ;
        private int textureIndex = 0;

        public TransceiverParticle(World world, double x, double y, double z, double tx, double ty, double tz) {
            super(world, x, y, z, 0.0, 0.0, 0.0);
            this.targetX = tx;
            this.targetY = ty;
            this.targetZ = tz;
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.field_70547_e = 1000;
            this.field_70145_X = true;
            this.field_70551_j = 1.0f;
            this.field_70553_i = 1.0f;
            this.field_70552_h = 1.0f;
        }

        public void func_70071_h_() {
            if (this.field_70546_d > this.field_70547_e) {
                this.func_70106_y();
            }
            if (this.field_70546_d > this.field_70547_e || this.func_70092_e(this.targetX, this.targetY, this.targetZ) < 0.05) {
                this.func_70106_y();
            }
            ++this.field_70546_d;
            float speed = (float)this.field_70546_d * 2.0E-5f;
            this.field_70159_w += (this.targetX - this.field_70165_t) * (double)speed;
            this.field_70181_x += (this.targetY - this.field_70163_u) * (double)speed;
            this.field_70179_y += (this.targetZ - this.field_70161_v) * (double)speed;
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.textureIndex = this.field_70170_p.field_73012_v.nextInt(5);
        }

        @SideOnly(value=Side.CLIENT)
        public void func_70539_a(Tessellator tesselator, float par2, float par3, float par4, float par5, float par6, float par7) {
            tesselator.func_78381_a();
            ResourceHandler.bindParticles();
            tesselator.func_78382_b();
            tesselator.func_78380_c(200);
            int uIndex = this.textureIndex;
            int vIndex = 1;
            float minU = (float)uIndex * 0.125f;
            float maxU = (float)(uIndex + 1) * 0.125f;
            float minV = (float)vIndex * 0.125f;
            float maxV = (float)(vIndex + 1) * 0.125f;
            float drawScale = 0.1f * this.field_70544_f;
            if (this.field_70550_a != null) {
                minU = this.field_70550_a.func_94209_e();
                maxU = this.field_70550_a.func_94212_f();
                minV = this.field_70550_a.func_94206_g();
                maxV = this.field_70550_a.func_94210_h();
            }
            float drawX = (float)(this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)par2 - field_70556_an);
            float drawY = (float)(this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)par2 - field_70554_ao);
            float drawZ = (float)(this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)par2 - field_70555_ap);
            tesselator.func_78369_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as);
            tesselator.func_78374_a((double)(drawX - par3 * drawScale - par6 * drawScale), (double)(drawY - par4 * drawScale), (double)(drawZ - par5 * drawScale - par7 * drawScale), (double)maxU, (double)maxV);
            tesselator.func_78374_a((double)(drawX - par3 * drawScale + par6 * drawScale), (double)(drawY + par4 * drawScale), (double)(drawZ - par5 * drawScale + par7 * drawScale), (double)maxU, (double)minV);
            tesselator.func_78374_a((double)(drawX + par3 * drawScale + par6 * drawScale), (double)(drawY + par4 * drawScale), (double)(drawZ + par5 * drawScale + par7 * drawScale), (double)minU, (double)minV);
            tesselator.func_78374_a((double)(drawX + par3 * drawScale - par6 * drawScale), (double)(drawY - par4 * drawScale), (double)(drawZ + par5 * drawScale - par7 * drawScale), (double)minU, (double)maxV);
            tesselator.func_78381_a();
            ResourceHandler.bindDefaultParticles();
            tesselator.func_78382_b();
        }
    }

    public static class AdvancedSeekerParticle
    extends EntityFX {
        public double targetX;
        public double targetY;
        public double targetZ;
        public double startDist = 0.0;
        public int behaviour;
        public int timer = 0;

        public AdvancedSeekerParticle(World world, double x, double y, double z, double tX, double tY, double tZ, int type, int maxAge) {
            super(world, x, y, z, 0.0, 0.0, 0.0);
            this.targetX = tX;
            this.targetY = tY;
            this.targetZ = tZ;
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.field_94054_b = 0;
            this.field_94055_c = 0;
            this.field_70544_f = world.field_73012_v.nextFloat() + 0.5f;
            this.field_70547_e = 100;
            this.field_70145_X = true;
            this.behaviour = type;
            this.startDist = this.func_70011_f(this.targetX, this.targetY, this.targetZ);
            this.field_70547_e = maxAge;
        }

        public AdvancedSeekerParticle(World world, double x, double y, double z, double tX, double tY, double tZ, int type, float red, float green, float blue, int maxAge) {
            this(world, x, y, z, tX, tY, tZ, type, maxAge);
            this.field_70552_h = red;
            this.field_70553_i = green;
            this.field_70551_j = blue;
        }

        public AdvancedSeekerParticle(World world, double x, double y, double z, double tX, double tY, double tZ, int type, float red, float green, float blue, int maxAge, int timer) {
            this(world, x, y, z, tX, tY, tZ, type, maxAge);
            this.field_70552_h = red;
            this.field_70553_i = green;
            this.field_70551_j = blue;
            this.timer = timer;
        }

        public void func_70071_h_() {
            switch (this.behaviour) {
                case 1: {
                    this.behaviour1();
                    break;
                }
                case 2: {
                    this.behaviour2();
                    break;
                }
                case 3: {
                    this.behaviour3();
                    break;
                }
                case 4: {
                    this.behaviour4();
                }
            }
        }

        private void behaviour1() {
            if (this.field_70546_d > this.field_70547_e) {
                this.func_70106_y();
            }
            if (this.field_70546_d + 10 >= this.field_70547_e) {
                this.field_82339_as = ((float)this.field_70547_e - (float)this.field_70546_d) / 10.0f;
            }
            ++this.field_70546_d;
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            ++this.timer;
        }

        private void behaviour2() {
            if (this.field_70546_d > this.field_70547_e) {
                this.func_70106_y();
            }
            ++this.field_70546_d;
            if (this.field_70544_f > 0.0f) {
                this.field_70544_f -= 0.02f;
            }
            if (this.field_70546_d > this.field_70547_e - 10) {
                this.field_70544_f += 1.0f;
                this.field_82339_as -= 0.1f;
            }
            float motionMod = 0.001f * Math.max(1.0f - (float)(this.field_70546_d / 50), 0.0f);
            this.field_70159_w += (this.targetX - this.field_70165_t) * (double)motionMod;
            this.field_70181_x += (this.targetY - this.field_70163_u) * (double)motionMod;
            this.field_70179_y += (this.targetZ - this.field_70161_v) * (double)motionMod;
            float directMotMod = 0.05f;
            float directMotT = Math.max(1.0f - (float)this.field_70546_d / 50.0f, 0.0f);
            this.field_70159_w = this.field_70159_w * (double)directMotT + (this.targetX - this.field_70165_t) * (double)(directMotMod *= 1.0f - directMotT);
            this.field_70181_x = this.field_70181_x * (double)directMotT + (this.targetY - this.field_70163_u) * (double)directMotMod;
            this.field_70179_y = this.field_70179_y * (double)directMotT + (this.targetZ - this.field_70161_v) * (double)directMotMod;
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            ++this.timer;
        }

        private void behaviour3() {
            int t;
            if (this.func_70092_e(this.targetX, this.targetY, this.targetZ) < 0.1 && this.field_70546_d < this.field_70547_e - 40) {
                this.field_70546_d = this.field_70547_e - 40;
            }
            if (this.field_70546_d > this.field_70547_e) {
                this.func_70106_y();
            }
            ++this.field_70546_d;
            if (this.field_70544_f > 0.0f) {
                this.field_70544_f -= 0.02f;
            }
            if ((this.field_70552_h == 1.0f || this.field_70553_i == 1.0f && this.field_70551_j == 0.0f) && this.field_70546_d > this.field_70547_e - 10) {
                t = this.timer - 300;
                if (this.timer > 0) {
                    this.field_70544_f = (float)t / (1.0f - (float)this.field_70546_d / ((float)this.field_70547_e - 10.0f) * 100.0f);
                }
            } else if (this.field_70551_j == 1.0f && this.field_70546_d > this.field_70547_e - 15) {
                t = this.timer - 700;
                if (this.timer > 0) {
                    this.field_70544_f = (float)t / (1.0f - (float)this.field_70546_d / ((float)this.field_70547_e - 10.0f) * 100.0f);
                }
            }
            float motionMod = 0.001f * Math.max(1.0f - (float)(this.field_70546_d / 50), 0.0f);
            this.field_70159_w += (this.targetX - this.field_70165_t) * (double)motionMod;
            this.field_70181_x += (this.targetY - this.field_70163_u) * (double)motionMod;
            this.field_70179_y += (this.targetZ - this.field_70161_v) * (double)motionMod;
            float directMotMod = 0.05f;
            float directMotT = Math.max(1.0f - (float)this.field_70546_d / 50.0f, 0.0f);
            this.field_70159_w = this.field_70159_w * (double)directMotT + (this.targetX - this.field_70165_t) * (double)(directMotMod *= 1.0f - directMotT);
            this.field_70181_x = this.field_70181_x * (double)directMotT + (this.targetY - this.field_70163_u) * (double)directMotMod;
            this.field_70179_y = this.field_70179_y * (double)directMotT + (this.targetZ - this.field_70161_v) * (double)directMotMod;
            if (this.field_70547_e - this.field_70546_d < 40 && this.timer > 2300 && (this.field_70552_h == 1.0f || this.field_70553_i == 1.0f && this.field_70551_j == 1.0f)) {
                double yChange = this.timer - 2300;
                if (this.field_70163_u < this.targetY + 60.0) {
                    this.field_70181_x = yChange * (double)0.05f;
                }
            }
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            ++this.timer;
        }

        private void behaviour4() {
        }

        @SideOnly(value=Side.CLIENT)
        public void func_70539_a(Tessellator tesselator, float par2, float par3, float par4, float par5, float par6, float par7) {
            tesselator.func_78381_a();
            ResourceHandler.bindParticles();
            tesselator.func_78382_b();
            tesselator.func_78380_c(200);
            float minU = 0.0f;
            float maxU = 0.1245f;
            float minV = 0.0f;
            float maxV = 0.1245f;
            float drawScale = 0.1f * this.field_70544_f;
            if (this.field_70550_a != null) {
                minU = this.field_70550_a.func_94209_e();
                maxU = this.field_70550_a.func_94212_f();
                minV = this.field_70550_a.func_94206_g();
                maxV = this.field_70550_a.func_94210_h();
            }
            float drawX = (float)(this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)par2 - field_70556_an);
            float drawY = (float)(this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)par2 - field_70554_ao);
            float drawZ = (float)(this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)par2 - field_70555_ap);
            tesselator.func_78369_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as);
            tesselator.func_78374_a((double)(drawX - par3 * drawScale - par6 * drawScale), (double)(drawY - par4 * drawScale), (double)(drawZ - par5 * drawScale - par7 * drawScale), (double)maxU, (double)maxV);
            tesselator.func_78374_a((double)(drawX - par3 * drawScale + par6 * drawScale), (double)(drawY + par4 * drawScale), (double)(drawZ - par5 * drawScale + par7 * drawScale), (double)maxU, (double)minV);
            tesselator.func_78374_a((double)(drawX + par3 * drawScale + par6 * drawScale), (double)(drawY + par4 * drawScale), (double)(drawZ + par5 * drawScale + par7 * drawScale), (double)minU, (double)minV);
            tesselator.func_78374_a((double)(drawX + par3 * drawScale - par6 * drawScale), (double)(drawY - par4 * drawScale), (double)(drawZ + par5 * drawScale - par7 * drawScale), (double)minU, (double)maxV);
            tesselator.func_78381_a();
            ResourceHandler.bindDefaultParticles();
            tesselator.func_78382_b();
        }
    }

    public static class EnergyTransferParticle
    extends EntityFX {
        private double targetX;
        private double targetY;
        private double targetZ;
        private boolean passive;

        public EnergyTransferParticle(World world, double x, double y, double z, double tX, double tY, double tZ, boolean passive) {
            super(world, x, y, z, 0.0, 0.0, 0.0);
            this.passive = passive;
            this.targetX = tX;
            this.targetY = tY;
            this.targetZ = tZ;
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.field_94054_b = 0;
            this.field_94055_c = 0;
            this.field_70544_f = world.field_73012_v.nextFloat() + 0.5f;
            this.field_70547_e = 100;
            this.field_70145_X = true;
            if (!passive) {
                this.field_70552_h = 0.0f;
                this.field_70553_i = 0.36862746f;
                this.field_70551_j = 0.98039216f;
            }
        }

        public void func_70071_h_() {
            if (this.field_70546_d > this.field_70547_e) {
                this.func_70106_y();
            }
            if (this.field_70546_d > this.field_70547_e || this.func_70092_e(this.targetX, this.targetY, this.targetZ) < 0.05) {
                this.func_70106_y();
            }
            ++this.field_70546_d;
            this.field_70159_w += (this.targetX - this.field_70165_t) * (double)0.001f;
            this.field_70181_x += (this.targetY - this.field_70163_u) * (double)0.001f;
            this.field_70179_y += (this.targetZ - this.field_70161_v) * (double)0.001f;
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }

        @SideOnly(value=Side.CLIENT)
        public void func_70539_a(Tessellator tesselator, float par2, float par3, float par4, float par5, float par6, float par7) {
            tesselator.func_78381_a();
            ResourceHandler.bindParticles();
            tesselator.func_78382_b();
            tesselator.func_78380_c(200);
            float minU = 0.0f;
            float maxU = 0.1245f;
            float minV = 0.0f;
            float maxV = 0.1245f;
            float drawScale = 0.1f * this.field_70544_f;
            if (this.field_70550_a != null) {
                minU = this.field_70550_a.func_94209_e();
                maxU = this.field_70550_a.func_94212_f();
                minV = this.field_70550_a.func_94206_g();
                maxV = this.field_70550_a.func_94210_h();
            }
            float drawX = (float)(this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)par2 - field_70556_an);
            float drawY = (float)(this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)par2 - field_70554_ao);
            float drawZ = (float)(this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)par2 - field_70555_ap);
            if (this.passive) {
                tesselator.func_78369_a((float)this.func_70092_e(this.targetX, this.targetY, this.targetZ) * 5.0f * this.field_70552_h, (float)this.func_70092_e(this.targetX, this.targetY, this.targetZ) * 5.0f * this.field_70553_i, this.field_70551_j, this.field_82339_as);
            } else {
                tesselator.func_78369_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, (float)this.func_70092_e(this.targetX, this.targetY, this.targetZ) * 5.0f);
            }
            tesselator.func_78374_a((double)(drawX - par3 * drawScale - par6 * drawScale), (double)(drawY - par4 * drawScale), (double)(drawZ - par5 * drawScale - par7 * drawScale), (double)maxU, (double)maxV);
            tesselator.func_78374_a((double)(drawX - par3 * drawScale + par6 * drawScale), (double)(drawY + par4 * drawScale), (double)(drawZ - par5 * drawScale + par7 * drawScale), (double)maxU, (double)minV);
            tesselator.func_78374_a((double)(drawX + par3 * drawScale + par6 * drawScale), (double)(drawY + par4 * drawScale), (double)(drawZ + par5 * drawScale + par7 * drawScale), (double)minU, (double)minV);
            tesselator.func_78374_a((double)(drawX + par3 * drawScale - par6 * drawScale), (double)(drawY - par4 * drawScale), (double)(drawZ + par5 * drawScale - par7 * drawScale), (double)minU, (double)maxV);
            tesselator.func_78381_a();
            ResourceHandler.bindDefaultParticles();
            tesselator.func_78382_b();
        }
    }

    public static class EnergyBeamParticle
    extends EntityFX {
        private int direction = 0;
        private double masterX = 0.0;
        private double masterZ = 0.0;
        private float rotation = 0.0f;
        private boolean mirror = false;
        private double[] trailX = new double[15];
        private double[] trailY = new double[15];
        private double[] trailZ = new double[15];

        public EnergyBeamParticle(World world, double x, double y, double z, double x1, double z1, int direction, boolean mirror) {
            super(world, x, y, z, 0.0, 0.0, 0.0);
            float speed = 0.04f;
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.masterX = x1;
            this.masterZ = z1;
            this.direction = direction;
            this.mirror = mirror;
            switch (direction) {
                case 0: {
                    this.field_70159_w = speed;
                    break;
                }
                case 1: {
                    this.field_70159_w = -speed;
                    break;
                }
                case 2: {
                    this.field_70179_y = speed;
                    break;
                }
                case 3: {
                    this.field_70179_y = -speed;
                }
            }
            this.field_94054_b = 0;
            this.field_94055_c = 0;
            this.field_70544_f = 1.0f;
            this.field_70145_X = true;
            this.field_70547_e = 300;
        }

        public void func_70071_h_() {
            if (this.field_70546_d > this.field_70547_e || this.func_70092_e(this.masterX, this.field_70163_u, this.masterZ) < 0.02) {
                this.func_70106_y();
            }
            if (this.func_70092_e(this.masterX, this.field_70163_u, this.masterZ) < 0.1) {
                this.field_70159_w = (this.masterX - this.field_70165_t) * (double)0.1f;
                this.field_70181_x = (Math.floor(this.field_70163_u) + 0.5 - this.field_70163_u) * (double)0.1f;
                this.field_70179_y = (this.masterZ - this.field_70161_v) * (double)0.1f;
                this.field_70169_q = this.field_70165_t;
                this.field_70167_r = this.field_70163_u;
                this.field_70166_s = this.field_70161_v;
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                return;
            }
            this.trailX[0] = this.field_70165_t;
            this.trailY[0] = this.field_70163_u;
            this.trailZ[0] = this.field_70161_v;
            for (int i = 14; i >= 0; --i) {
                if (i <= 0) continue;
                this.trailX[i] = this.trailX[i - 1];
                this.trailY[i] = this.trailY[i - 1];
                this.trailZ[i] = this.trailZ[i - 1];
            }
            float multiplier = 0.27f;
            double masterY = Math.floor(this.field_70163_u) + 0.5;
            if (this.direction == 0 || this.direction == 1) {
                this.field_70161_v = this.masterZ + Math.sin(this.rotation) * (double)multiplier;
                this.field_70163_u = masterY + Math.cos(this.rotation) * (double)multiplier;
            } else {
                this.field_70165_t = this.masterX + Math.sin(this.rotation) * (double)multiplier;
                this.field_70163_u = masterY + Math.cos(this.rotation) * (double)multiplier;
            }
            if (this.mirror) {
                float modifier = 3.0f;
                if (this.direction == 0 || this.direction == 1) {
                    this.field_70161_v = this.masterZ + Math.sin(this.rotation + modifier) * (double)multiplier;
                    this.field_70163_u = masterY + Math.cos(this.rotation + modifier) * (double)multiplier;
                } else {
                    this.field_70165_t = this.masterX + Math.sin(this.rotation + modifier) * (double)multiplier;
                    this.field_70163_u = masterY + Math.cos(this.rotation + modifier) * (double)multiplier;
                }
            }
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            if (this.direction == 0 || this.direction == 1) {
                this.func_70091_d(this.field_70159_w, 0.0, 0.0);
            } else {
                this.func_70091_d(0.0, 0.0, this.field_70179_y);
            }
            ++this.field_70546_d;
            this.rotation = this.direction == 0 || this.direction == 3 ? (float)((double)this.rotation - 0.15) : (float)((double)this.rotation + 0.15);
        }

        @SideOnly(value=Side.CLIENT)
        public void func_70539_a(Tessellator tesselator, float par2, float par3, float par4, float par5, float par6, float par7) {
            tesselator.func_78381_a();
            ResourceHandler.bindParticles();
            tesselator.func_78382_b();
            tesselator.func_78380_c(200);
            float minU = 0.0f;
            float maxU = 0.1245f;
            float minV = 0.0f;
            float maxV = 0.1245f;
            float drawScale = 0.1f * this.field_70544_f;
            if (this.field_70550_a != null) {
                minU = this.field_70550_a.func_94209_e();
                maxU = this.field_70550_a.func_94212_f();
                minV = this.field_70550_a.func_94206_g();
                maxV = this.field_70550_a.func_94210_h();
            }
            float drawX = (float)(this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)par2 - field_70556_an);
            float drawY = (float)(this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)par2 - field_70554_ao);
            float drawZ = (float)(this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)par2 - field_70555_ap);
            tesselator.func_78369_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as);
            tesselator.func_78374_a((double)(drawX - par3 * drawScale - par6 * drawScale), (double)(drawY - par4 * drawScale), (double)(drawZ - par5 * drawScale - par7 * drawScale), (double)maxU, (double)maxV);
            tesselator.func_78374_a((double)(drawX - par3 * drawScale + par6 * drawScale), (double)(drawY + par4 * drawScale), (double)(drawZ - par5 * drawScale + par7 * drawScale), (double)maxU, (double)minV);
            tesselator.func_78374_a((double)(drawX + par3 * drawScale + par6 * drawScale), (double)(drawY + par4 * drawScale), (double)(drawZ + par5 * drawScale + par7 * drawScale), (double)minU, (double)minV);
            tesselator.func_78374_a((double)(drawX + par3 * drawScale - par6 * drawScale), (double)(drawY - par4 * drawScale), (double)(drawZ + par5 * drawScale - par7 * drawScale), (double)minU, (double)maxV);
            for (int i = 0; i <= 14; ++i) {
                GL11.glPushMatrix();
                drawX = (float)(this.trailX[i] + (this.trailX[i] - this.trailX[i]) * (double)par2 - field_70556_an);
                drawY = (float)(this.trailY[i] + (this.trailY[i] - this.trailY[i]) * (double)par2 - field_70554_ao);
                drawZ = (float)(this.trailZ[i] + (this.trailZ[i] - this.trailZ[i]) * (double)par2 - field_70555_ap);
                float scale = 0.1f * (1.0f - (float)i / 14.0f);
                float scale2 = 1.0f - (float)i / 14.0f;
                if (!this.mirror) {
                    tesselator.func_78369_a(1.0f, scale2, scale2, scale2);
                } else {
                    tesselator.func_78369_a(scale2, 1.0f, scale2, scale2);
                }
                tesselator.func_78374_a((double)(drawX - par3 * scale - par6 * scale), (double)(drawY - par4 * scale), (double)(drawZ - par5 * scale - par7 * scale), (double)maxU, (double)maxV);
                tesselator.func_78374_a((double)(drawX - par3 * scale + par6 * scale), (double)(drawY + par4 * scale), (double)(drawZ - par5 * scale + par7 * scale), (double)maxU, (double)minV);
                tesselator.func_78374_a((double)(drawX + par3 * scale + par6 * scale), (double)(drawY + par4 * scale), (double)(drawZ + par5 * scale + par7 * scale), (double)minU, (double)minV);
                tesselator.func_78374_a((double)(drawX + par3 * scale - par6 * scale), (double)(drawY - par4 * scale), (double)(drawZ + par5 * scale - par7 * scale), (double)minU, (double)maxV);
                GL11.glPopMatrix();
            }
            tesselator.func_78381_a();
            ResourceHandler.bindDefaultParticles();
            tesselator.func_78382_b();
        }
    }
}

