/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.tileentities.energynet;

import com.brandon3055.draconicevolution.client.render.particle.ParticleEnergyBeam;
import com.brandon3055.draconicevolution.common.tileentities.energynet.IRemoteEnergyHandler;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class LinkedEnergyDevice {
    public ParticleEnergyBeam beam;
    public double energyFlow = 0.0;
    public double lastTickEnergyFlow = 0.0;
    public int xCoord;
    public int yCoord;
    public int zCoord;

    public LinkedEnergyDevice() {
    }

    public LinkedEnergyDevice(int xCoord, int yCoord, int zCoord, ParticleEnergyBeam beam) {
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.zCoord = zCoord;
        this.beam = beam;
    }

    public TileEntity getTile(World world) {
        return world.func_147438_o(this.xCoord, this.yCoord, this.zCoord);
    }

    public IRemoteEnergyHandler getEnergyTile(World world) {
        return this.getTile(world) instanceof IRemoteEnergyHandler ? (IRemoteEnergyHandler)this.getTile(world) : null;
    }

    public LinkedEnergyDevice writeToNBT(NBTTagCompound compound, String key) {
        compound.func_74768_a("X_" + key, this.xCoord);
        compound.func_74768_a("Y_" + key, this.yCoord);
        compound.func_74768_a("Z_" + key, this.zCoord);
        if (this.beam != null) {
            compound.func_74777_a("Flow_" + key, (short)this.beam.getFlow());
        }
        return this;
    }

    public LinkedEnergyDevice readFromNBT(NBTTagCompound compound, String key) {
        this.xCoord = compound.func_74762_e("X_" + key);
        this.yCoord = compound.func_74762_e("Y_" + key);
        this.zCoord = compound.func_74762_e("Z_" + key);
        if (this.beam != null) {
            this.beam.setFlow(compound.func_74765_d("Flow" + key));
        }
        return this;
    }

    public String toString() {
        return "[x: " + this.xCoord + " y: " + this.yCoord + " z: " + this.zCoord + "]";
    }

    public boolean isValid(World world) {
        return this.getEnergyTile(world) != null;
    }
}

