/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.api;

import com.google.common.base.CharMatcher;
import com.google.common.base.Optional;
import com.stek101.projectzulu.common.api.CustomMobData;
import java.util.EnumSet;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;

public enum CustomEntityList {
    CREEPERBLOSSOMPRIMED,
    ARMADILLO,
    SANDWORM,
    LIZARD,
    MUMMYPHARAOH,
    MUMMY,
    VULTURE,
    TREEENT,
    MAMMOTH,
    FOX,
    BOAR,
    MIMIC,
    ALLIGATOR,
    FROG,
    PENGUIN,
    BEAVER,
    BLACKBEAR,
    BROWNBEAR,
    POLARBEAR,
    OSTRICH,
    RHINO,
    RABBIT,
    REDFINCH,
    BLUEFINCH,
    GREENFINCH,
    GORILLA,
    GIRAFFE,
    ELEPHANT,
    HORSE,
    EAGLE,
    HORNBILL,
    PELICAN,
    MINOTAUR,
    HAUNTEDARMOR,
    CENTIPEDE,
    HORSERANDOM,
    LIZARDSPIT,
    FOLLOWER,
    YELLOWFINCH,
    GOAT,
    DUCK,
    DUCKEGG,
    DEER,
    SKELETONN,
    FISHA,
    RIPPERFIN,
    OSTRICHEGG,
    GIANTRAT,
    FISHB,
    CROW,
    CAMEL,
    MONKEY,
    THROWINGROCK,
    RAVAGERANT,
    BEETLEAS,
    BEETLEBS,
    BLOOMDOOM,
    PZBAT,
    ZEBRA;

    public Optional<? extends CustomMobData> modData = Optional.absent();
    private static final HashMap<String, CustomEntityList> lookupEnum;

    public static CustomEntityList getByName(String mobName) {
        if (mobName == null) {
            return null;
        }
        String[] nameParts = CharMatcher.anyOf((CharSequence)" ").removeFrom((CharSequence)mobName).toLowerCase().split("\\.");
        CustomEntityList result = nameParts.length > 1 ? lookupEnum.get(nameParts[nameParts.length - 1]) : lookupEnum.get(nameParts[0]);
        if (result == null) {
            // empty if block
        }
        return result;
    }

    public static CustomEntityList getByEntity(Entity entity) {
        String mobName = EntityList.func_75621_b((Entity)entity);
        if (mobName != null) {
            return CustomEntityList.getByName(mobName);
        }
        return null;
    }

    static {
        lookupEnum = new HashMap();
        for (CustomEntityList entry : EnumSet.allOf(CustomEntityList.class)) {
            lookupEnum.put(entry.toString().toLowerCase(), entry);
        }
    }
}

