/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.blocks;

import com.stek101.projectzulu.common.ProjectZulu_Core;
import com.stek101.projectzulu.common.api.BlockList;
import com.stek101.projectzulu.common.api.ItemList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class BlockPalmTreeLeaves
extends BlockLeavesBase
implements IShearable {
    public static final String[] imageSuffix = new String[]{"_opaque", ""};
    int[] adjacentTreeBlocks;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;
    private int iconIndex;
    private static final int METADATA_BITMASK = 3;
    private static final int METADATA_USERPLACEDBIT = 4;
    private static final int METADATA_DECAYBIT = 8;
    private static final int METADATA_CLEARDECAYBIT = -9;

    public BlockPalmTreeLeaves() {
        super(Material.field_151584_j, false);
        this.func_149675_a(true);
        this.func_149711_c(0.2f);
        this.func_149713_g(1);
        this.func_149672_a(Block.field_149779_h);
        this.func_149647_a(ProjectZulu_Core.projectZuluCreativeTab);
    }

    private static int clearDecayOnMetadata(int metadata) {
        return metadata & 0xFFFFFFF7;
    }

    private static boolean isDecaying(int metadata) {
        return (metadata & 8) != 0;
    }

    private static boolean isUserPlaced(int metadata) {
        return (metadata & 4) != 0;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int par1, int par2) {
        return this.icons[this.iconIndex];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.icons = new IIcon[imageSuffix.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = par1IconRegister.func_94245_a(this.func_149641_N() + imageSuffix[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149635_D() {
        double var1 = 0.5;
        double var3 = 1.0;
        return ColorizerFoliage.func_77470_a((double)var1, (double)var3);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int par1) {
        return ColorizerFoliage.func_77468_c();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess par1iBlockAccess, int par2, int par3, int par4, int par5) {
        this.setGraphicsLevel(Minecraft.func_71410_x().field_71474_y.field_74347_j);
        return super.func_149646_a(par1iBlockAccess, par2, par3, par4, par5);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        int var6 = 0;
        int var7 = 0;
        int var8 = 0;
        for (int var9 = -1; var9 <= 1; ++var9) {
            for (int var10 = -1; var10 <= 1; ++var10) {
                int var11 = par1IBlockAccess.func_72807_a(par2 + var10, par4 + var9).func_150571_c(par2 + var10, par3, par4 + var9);
                var6 += (var11 & 0xFF0000) >> 16;
                var7 += (var11 & 0xFF00) >> 8;
                var8 += var11 & 0xFF;
            }
        }
        return (var6 / 9 & 0xFF) << 16 | (var7 / 9 & 0xFF) << 8 | var8 / 9 & 0xFF;
    }

    public void func_149749_a(World par1World, int par2, int par3, int par4, Block par5, int par6) {
        int decayRadius = 1;
        int chunkCheckRadius = decayRadius + 1;
        if (par1World.func_72904_c(par2 - chunkCheckRadius, par3 - chunkCheckRadius, par4 - chunkCheckRadius, par2 + chunkCheckRadius, par3 + chunkCheckRadius, par4 + chunkCheckRadius)) {
            for (int var9 = -decayRadius; var9 <= decayRadius; ++var9) {
                for (int var10 = -decayRadius; var10 <= decayRadius; ++var10) {
                    for (int var11 = -decayRadius; var11 <= decayRadius; ++var11) {
                        Block nearBlockID = par1World.func_147439_a(par2 + var9, par3 + var10, par4 + var11);
                        if (nearBlockID == null) continue;
                        nearBlockID.beginLeavesDecay(par1World, par2 + var9, par3 + var10, par4 + var11);
                    }
                }
            }
        }
    }

    public void func_149674_a(World par1World, int par2, int par3, int par4, Random par5Random) {
        if (par1World.field_72995_K) {
            return;
        }
        int metadata = par1World.func_72805_g(par2, par3, par4);
        if (BlockPalmTreeLeaves.isUserPlaced(metadata) || !BlockPalmTreeLeaves.isDecaying(metadata)) {
            return;
        }
        int rangeWood = 4;
        int rangeCheckChunk = rangeWood + 1;
        int var9 = 32;
        int var10 = var9 * var9;
        int var11 = var9 / 2;
        if (this.adjacentTreeBlocks == null) {
            this.adjacentTreeBlocks = new int[var9 * var9 * var9];
        }
        if (par1World.func_72904_c(par2 - rangeCheckChunk, par3 - rangeCheckChunk, par4 - rangeCheckChunk, par2 + rangeCheckChunk, par3 + rangeCheckChunk, par4 + rangeCheckChunk)) {
            int var14;
            int var13;
            int var12;
            for (var12 = -rangeWood; var12 <= rangeWood; ++var12) {
                for (var13 = -rangeWood; var13 <= rangeWood; ++var13) {
                    for (var14 = -rangeWood; var14 <= rangeWood; ++var14) {
                        Block block = par1World.func_147439_a(par2 + var12, par3 + var13, par4 + var14);
                        this.adjacentTreeBlocks[(var12 + var11) * var10 + (var13 + var11) * var9 + var14 + var11] = block != null && block.canSustainLeaves((IBlockAccess)par1World, par2 + var12, par3 + var13, par4 + var14) ? 0 : (block != null && block.isLeaves((IBlockAccess)par1World, par2 + var12, par3 + var13, par4 + var14) ? -2 : -1);
                    }
                }
            }
            for (var12 = 1; var12 <= 4; ++var12) {
                for (var13 = -rangeWood; var13 <= rangeWood; ++var13) {
                    for (var14 = -rangeWood; var14 <= rangeWood; ++var14) {
                        for (int var15 = -rangeWood; var15 <= rangeWood; ++var15) {
                            if (this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11) * var9 + var15 + var11] != var12 - 1) continue;
                            if (this.adjacentTreeBlocks[(var13 + var11 - 1) * var10 + (var14 + var11) * var9 + var15 + var11] == -2) {
                                this.adjacentTreeBlocks[(var13 + var11 - 1) * var10 + (var14 + var11) * var9 + var15 + var11] = var12;
                            }
                            if (this.adjacentTreeBlocks[(var13 + var11 + 1) * var10 + (var14 + var11) * var9 + var15 + var11] == -2) {
                                this.adjacentTreeBlocks[(var13 + var11 + 1) * var10 + (var14 + var11) * var9 + var15 + var11] = var12;
                            }
                            if (this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11 - 1) * var9 + var15 + var11] == -2) {
                                this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11 - 1) * var9 + var15 + var11] = var12;
                            }
                            if (this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11 + 1) * var9 + var15 + var11] == -2) {
                                this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11 + 1) * var9 + var15 + var11] = var12;
                            }
                            if (this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11) * var9 + (var15 + var11 - 1)] == -2) {
                                this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11) * var9 + (var15 + var11 - 1)] = var12;
                            }
                            if (this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11) * var9 + var15 + var11 + 1] != -2) continue;
                            this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11) * var9 + var15 + var11 + 1] = var12;
                        }
                    }
                }
            }
        }
        if (this.adjacentTreeBlocks[var11 * var10 + var11 * var9 + var11] >= 0) {
            par1World.func_72921_c(par2, par3, par4, BlockPalmTreeLeaves.clearDecayOnMetadata(metadata), 3);
        } else {
            this.removeLeaves(par1World, par2, par3, par4);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World par1World, int par2, int par3, int par4, Random par5Random) {
        if (par1World.func_72951_B(par2, par3 + 1, par4) && !World.func_147466_a((IBlockAccess)par1World, (int)par2, (int)(par3 - 1), (int)par4) && par5Random.nextInt(15) == 1) {
            double var6 = (float)par2 + par5Random.nextFloat();
            double var8 = (double)par3 - 0.05;
            double var10 = (float)par4 + par5Random.nextFloat();
            par1World.func_72869_a("dripWater", var6, var8, var10, 0.0, 0.0, 0.0);
        }
    }

    private void removeLeaves(World par1World, int par2, int par3, int par4) {
        this.func_149697_b(par1World, par2, par3, par4, par1World.func_72805_g(par2, par3, par4), 0);
        par1World.func_147449_b(par2, par3, par4, Blocks.field_150350_a);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        int chance = world.field_73012_v.nextInt(100);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (10 - chance >= 0) {
            if (ItemList.coconutItem.isPresent()) {
                ret.add(new ItemStack((Item)ItemList.coconutItem.get()));
            }
            return ret;
        }
        if (30 - chance >= 0 && BlockList.palmTreeSapling.isPresent()) {
            ret.add(new ItemStack((Block)BlockList.palmTreeSapling.get()));
            return ret;
        }
        return ret;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void setGraphicsLevel(boolean par1) {
        this.field_150121_P = par1;
        this.iconIndex = par1 ? 0 : 1;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this, 1, world.func_72805_g(x, y, z) & 3));
        return ret;
    }

    public void beginLeavesDecay(World world, int x, int y, int z) {
        world.func_72921_c(x, y, z, world.func_72805_g(x, y, z) | 8, 3);
    }

    public boolean isLeaves(IBlockAccess world, int x, int y, int z) {
        return true;
    }
}

