/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.blocks.itemblockdeclarations;

import com.google.common.base.Optional;
import com.stek101.projectzulu.common.api.BlockList;
import com.stek101.projectzulu.common.blocks.spike.BlockSpikes;
import com.stek101.projectzulu.common.blocks.spike.RenderSpike;
import com.stek101.projectzulu.common.blocks.spike.TileEntitySpikes;
import com.stek101.projectzulu.common.core.ProjectZuluLog;
import com.stek101.projectzulu.common.core.itemblockdeclaration.BlockDeclaration;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraftforge.common.config.Configuration;

public class SpikesDeclaration
extends BlockDeclaration {
    private int renderID = -1;
    private String material;
    private boolean spikesInvulnerable = false;

    public SpikesDeclaration(String mat) {
        super("Spikes_" + mat);
        this.material = mat;
    }

    @Override
    protected void preCreateLoadConfig(Configuration config) {
        this.renderID = config.get("Do Not Touch", "Spike Render ID", this.renderID).getInt(this.renderID);
        this.renderID = this.renderID == -1 ? RenderingRegistry.getNextAvailableRenderId() : this.renderID;
        this.spikesInvulnerable = config.get("Misc Game Settings", "Spikes Invulnerable", this.spikesInvulnerable).getBoolean(this.spikesInvulnerable);
    }

    @Override
    protected boolean createBlock() {
        if (this.material == "Ivory") {
            BlockList.spike_ivory = Optional.of((Object)new BlockSpikes(this.renderID, this.spikesInvulnerable).func_149663_c(this.name.toLowerCase()).func_149658_d("projectzulublock:" + this.name.toLowerCase()));
        } else if (this.material == "Wood") {
            BlockList.spike_wood = Optional.of((Object)new BlockSpikes(this.renderID, Material.field_151575_d, 0, this.spikesInvulnerable).func_149663_c(this.name.toLowerCase()).func_149658_d("projectzulublock:" + this.name.toLowerCase()));
        } else if (this.material == "Stone") {
            BlockList.spike_stone = Optional.of((Object)new BlockSpikes(this.renderID, Material.field_151576_e, 0, this.spikesInvulnerable).func_149663_c(this.name.toLowerCase()).func_149658_d("projectzulublock:" + this.name.toLowerCase()));
        } else if (this.material == "Iron") {
            BlockList.spike_iron = Optional.of((Object)new BlockSpikes(this.renderID, Material.field_151573_f, 0, this.spikesInvulnerable).func_149663_c(this.name.toLowerCase()).func_149658_d("projectzulublock:" + this.name.toLowerCase()));
        }
        return true;
    }

    @Override
    protected void registerBlock() {
        if (this.material == "Ivory") {
            Block block = (Block)BlockList.spike_ivory.get();
            GameRegistry.registerBlock((Block)block, (String)this.name.toLowerCase());
            GameRegistry.registerTileEntity(TileEntitySpikes.class, (String)"PZTileEntitySpikes");
        } else if (this.material == "Wood") {
            Block block = (Block)BlockList.spike_wood.get();
            GameRegistry.registerBlock((Block)block, (String)this.name.toLowerCase());
            GameRegistry.registerTileEntity(TileEntitySpikes.class, (String)"PZTileEntitySpikesW");
        } else if (this.material == "Stone") {
            Block block = (Block)BlockList.spike_stone.get();
            GameRegistry.registerBlock((Block)block, (String)this.name.toLowerCase());
            GameRegistry.registerTileEntity(TileEntitySpikes.class, (String)"PZTileEntitySpikesS");
        } else if (this.material == "Iron") {
            Block block = (Block)BlockList.spike_iron.get();
            GameRegistry.registerBlock((Block)block, (String)this.name.toLowerCase());
            GameRegistry.registerTileEntity(TileEntitySpikes.class, (String)"PZTileEntitySpikesI");
        }
    }

    @Override
    protected void clientRegisterBlock() {
        RenderingRegistry.registerBlockHandler((int)this.renderID, (ISimpleBlockRenderingHandler)new RenderSpike());
        ProjectZuluLog.info("Spike Render ID Registed to %s", this.renderID);
    }
}

