/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.blocks.terrain;

import com.stek101.projectzulu.common.api.BlockList;
import com.stek101.projectzulu.common.core.ProjectZuluLog;
import com.stek101.projectzulu.common.core.terrain.BiomeFeature;
import com.stek101.projectzulu.common.core.terrain.FeatureConfiguration;
import com.stek101.projectzulu.common.core.terrain.TerrainFeature;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class PalmTreeFeature
extends BiomeFeature {
    private int density = 3;

    public PalmTreeFeature() {
        super("Palm Tree", TerrainFeature.Size.TINY);
    }

    @Override
    public boolean isEnabled() {
        return BlockList.aloeVera.isPresent() && super.isEnabled();
    }

    @Override
    protected void loadDefaultSettings() {
        this.minChunkDistance = 1;
        this.chunksPerSpawn = 10;
    }

    @Override
    protected void loadSettings(FeatureConfiguration config) {
        super.loadSettings(config);
        this.density = config.get("Feature." + (Object)((Object)this.getFeatureSize()) + "." + this.getFeatureName() + ".General", "Density", this.density).getInt(this.density);
    }

    @Override
    protected Collection<String> getDefaultBiomeList() {
        return Arrays.asList(BiomeGenBase.field_76787_r.field_76791_y, BiomeGenBase.field_76781_i.field_76791_y);
    }

    @Override
    public ChunkCoordinates[] getGenerationCoordinates(World world, int chunkX, int chunkZ) {
        Random random = new Random(world.func_72905_C());
        long randomFactor1 = random.nextLong() / 2L * 2L + 1L;
        long randomFactor2 = random.nextLong() / 2L * 2L + 1L;
        random.setSeed((long)(chunkX * 16) * randomFactor1 + (long)(chunkZ * 16) * randomFactor2 ^ world.func_72905_C());
        ChunkCoordinates[] coordinates = new ChunkCoordinates[this.density];
        for (int i = 0; i < this.density; ++i) {
            int xCoord = chunkX * 16 + random.nextInt(16);
            int zCoord = chunkZ * 16 + random.nextInt(16);
            coordinates[i] = new ChunkCoordinates(xCoord, world.func_72825_h(xCoord, zCoord), zCoord);
        }
        return coordinates;
    }

    @Override
    public boolean canGenerateHere(World world, int chunkX, int chunkZ, ChunkCoordinates genBlockCoords, Random random) {
        Block iDBelow;
        if (super.canGenerateHere(world, chunkX, chunkZ, genBlockCoords, random) && world.func_147437_c(genBlockCoords.field_71574_a, genBlockCoords.field_71572_b, genBlockCoords.field_71573_c) && ((iDBelow = world.func_147439_a(genBlockCoords.field_71574_a, genBlockCoords.field_71572_b - 1, genBlockCoords.field_71573_c)) == Blocks.field_150349_c || iDBelow == Blocks.field_150346_d || iDBelow == Blocks.field_150354_m)) {
            if (this.printToLog) {
                ProjectZuluLog.info("Generating %s at %s, %s, %s", this.getFeatureName(), genBlockCoords.field_71574_a, genBlockCoords.field_71572_b, genBlockCoords.field_71573_c);
            }
            return true;
        }
        return false;
    }

    @Override
    public void generateFeature(World world, int chunkX, int chunkZ, ChunkCoordinates genBlockCoords, Random random, TerrainFeature.FeatureDirection direction) {
        world.func_147449_b(genBlockCoords.field_71574_a, genBlockCoords.field_71572_b, genBlockCoords.field_71573_c, (Block)BlockList.palmTreeSapling.get());
    }
}

