/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.core;

import com.stek101.projectzulu.common.core.itemblockdeclaration.ItemBlockDeclaration;
import cpw.mods.fml.common.FMLCommonHandler;
import java.io.File;
import java.util.ArrayList;
import net.minecraftforge.common.config.Configuration;

public enum ItemBlockManager {
    INSTANCE;

    private ArrayList<ItemBlockDeclaration> itemBlocks = new ArrayList();

    public void addItemBlock(ItemBlockDeclaration ... itemBlock) {
        for (ItemBlockDeclaration declaration : itemBlock) {
            this.itemBlocks.add(declaration);
        }
    }

    public void createBlocks(File configDirectory) {
        Configuration config = new Configuration(new File(configDirectory, "/Project Zulu/ProjectZuluConfig.cfg"));
        config.load();
        this.createFromConfig(config, true);
        this.createFromConfig(config, false);
        config.save();
    }

    private void createFromConfig(Configuration config, boolean readOnly) {
        boolean hasNextPass;
        int currentRenderPass = 0;
        do {
            hasNextPass = false;
            for (ItemBlockDeclaration itemBlock : this.itemBlocks) {
                if (currentRenderPass == itemBlock.getRegisterPass()) {
                    itemBlock.createWithConfig(config, readOnly);
                    continue;
                }
                if (currentRenderPass >= itemBlock.getRegisterPass()) continue;
                hasNextPass = true;
            }
            ++currentRenderPass;
        } while (hasNextPass);
    }

    public void registerBlocks() {
        for (ItemBlockDeclaration itemBlock : this.itemBlocks) {
            itemBlock.register(FMLCommonHandler.instance().getEffectiveSide());
        }
    }
}

