/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.dungeon.spawner.tag.keys;

import com.stek101.projectzulu.common.core.ProjectZuluLog;
import com.stek101.projectzulu.common.dungeon.spawner.tag.ParsingHelper;
import com.stek101.projectzulu.common.dungeon.spawner.tag.TypeValuePair;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.Key;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParser;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParserBase;
import com.stek101.projectzulu.common.dungeon.spawner.tag.settings.OptionalSettings;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.EntityLiving;
import net.minecraft.world.World;

public class KeyParserRandom
extends KeyParserBase {
    public KeyParserRandom(Key key) {
        super(key, true, KeyParser.KeyType.CHAINABLE);
    }

    @Override
    public boolean parseChainable(String parseable, ArrayList<TypeValuePair> parsedChainable, ArrayList<OptionalSettings.Operand> operandvalue) {
        String[] pieces = parseable.split(",");
        OptionalSettings.Operand operand = this.parseOperand(pieces);
        if (pieces.length == 4) {
            int randInt = ParsingHelper.parseFilteredInteger(pieces[1], 16, "RandomRange " + this.key.key);
            int randOffset = ParsingHelper.parseFilteredInteger(pieces[2], 16, "RandomOffset " + this.key.key);
            int maximum = ParsingHelper.parseFilteredInteger(pieces[3], -1, "Maximum " + this.key.key);
            TypeValuePair typeValue = new TypeValuePair(this.key, new Object[]{this.isInverted(pieces[0]), randInt, randOffset, maximum});
            parsedChainable.add(typeValue);
            operandvalue.add(operand);
            return true;
        }
        ProjectZuluLog.severe("Error Parsing %s Parameter. Invalid Argument Length.", this.key.key);
        return false;
    }

    @Override
    public boolean parseValue(String parseable, HashMap<String, Object> valueCache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isValidLocation(World world, EntityLiving entity, int xCoord, int yCoord, int zCoord, TypeValuePair typeValuePair, HashMap<String, Object> valueCache) {
        boolean isValid;
        Object[] values = (Object[])typeValuePair.getValue();
        boolean isInverted = (Boolean)values[0];
        int randInt = (Integer)values[1];
        int randOffset = (Integer)values[2];
        int maximum = (Integer)values[3];
        boolean bl = isValid = world.field_73012_v.nextInt(randInt) + randOffset > maximum;
        return isInverted ? isValid : !isValid;
    }
}

