/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.dungeon.spawner.tag.settings;

import com.stek101.projectzulu.common.core.ProjectZuluLog;
import com.stek101.projectzulu.common.dungeon.spawner.tag.TypeValuePair;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.Key;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParser;
import com.stek101.projectzulu.common.dungeon.spawner.tag.settings.OptionalSettings;
import java.util.EnumSet;
import net.minecraft.entity.EntityLiving;
import net.minecraft.world.World;

public abstract class OptionalSettingsBase
extends OptionalSettings {
    public static int defaultBlockRange = 3;
    public static int defaultSpawnRate = 40;

    public OptionalSettingsBase(String parseableString, EnumSet<Key> validKeys) {
        super(parseableString, validKeys);
        this.parseString();
    }

    @Override
    public boolean isOptionalEnabled() {
        return this.isEnabled;
    }

    @Override
    public boolean isInverted() {
        return this.isInverted;
    }

    @Override
    protected final void parseString() {
        if (this.stringParsed || this.parseableString.equals("")) {
            return;
        }
        this.stringParsed = true;
        String[] masterParts = this.parseableString.split(":");
        for (int i = 0; i < masterParts.length; ++i) {
            if (i == 0) {
                for (Key key : this.validKeys) {
                    if (key.keyParser == null || key.keyParser.getKeyType() != KeyParser.KeyType.PARENT || !key.keyParser.isMatch(masterParts[i])) continue;
                    this.isEnabled = true;
                    this.isInverted = key.keyParser.isInvertable() && key.keyParser.isInverted(masterParts[i]);
                    this.operand = key.keyParser.parseOperand(masterParts[i]);
                }
                continue;
            }
            String[] childParts = masterParts[i].split(",", 2);
            boolean foundMatch = false;
            for (Key key : this.validKeys) {
                if (key.keyParser == null || !key.keyParser.isMatch(childParts[0])) continue;
                foundMatch = true;
                if (key.keyParser.getKeyType() == KeyParser.KeyType.CHAINABLE) {
                    if (key.keyParser.parseChainable(masterParts[i], this.parsedChainable, this.operandvalue)) break;
                    ProjectZuluLog.severe("Failed to Parse Chainable from %s", masterParts[i]);
                    break;
                }
                if (key.keyParser.getKeyType() != KeyParser.KeyType.VALUE || key.keyParser.parseValue(masterParts[i], this.valueCache)) break;
                ProjectZuluLog.severe("Failed to Parse Value from %s", masterParts[i]);
                break;
            }
            if (foundMatch) continue;
            ProjectZuluLog.severe("Could Not Recognize any valid %s properties from %s", this.getClass().getSimpleName(), masterParts[i]);
        }
    }

    public boolean isValidLocation(World world, EntityLiving entity, int xCoord, int yCoord, int zCoord) {
        boolean outcome = true;
        for (int i = 0; i < this.parsedChainable.size(); ++i) {
            TypeValuePair typeValuePair = (TypeValuePair)this.parsedChainable.get(i);
            if (i != 0) {
                if (this.operandvalue.get(i) == OptionalSettings.Operand.AND && outcome) continue;
                if (this.operandvalue.get(i) == OptionalSettings.Operand.OR && !outcome) {
                    return false;
                }
            }
            Key key = typeValuePair.getType();
            outcome = key.keyParser.isValidLocation(world, entity, xCoord, yCoord, zCoord, typeValuePair, this.valueCache);
        }
        return outcome;
    }

    public boolean isMidDistance(int playerDistance, int defaultCutoff) {
        this.parseString();
        Integer tempCutoff = (Integer)this.valueCache.get((Object)Key.spawnRange);
        defaultCutoff = tempCutoff == null ? defaultCutoff : tempCutoff;
        return playerDistance > defaultCutoff * defaultCutoff;
    }

    protected boolean canBlockSeeTheSky(World world, int xCoord, int yCoord, int zCoord) {
        int blockHeight = world.func_72825_h(xCoord, zCoord);
        return blockHeight <= yCoord;
    }
}

