/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.mobs;

import com.stek101.projectzulu.common.mobs.entity.EntityGenericAnimal;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class BossHealthDisplayTicker {
    public static final ResourceLocation icons = new ResourceLocation("textures/gui/icons.png");
    public static EntityGenericAnimal targetBoss;
    protected float zLevel = 0.0f;
    static EntityPlayer player;
    private Configuration config;
    private boolean displayBossHealth = true;
    private Minecraft mc;

    public BossHealthDisplayTicker(Minecraft mc) {
        this.mc = mc;
        this.config = new Configuration(new File("./config/", "/Project Zulu/ProjectZuluConfig.cfg"));
        this.config.load();
        this.displayBossHealth = this.config.get("mob controls", "Display PZBoss HealthBar", this.displayBossHealth).getBoolean(this.displayBossHealth);
        this.config.save();
    }

    public static void registerEntity(EntityGenericAnimal newTicker) {
        targetBoss = newTicker;
    }

    public static boolean validTargetPresent(EntityGenericAnimal targetBoss) {
        if (Minecraft.func_71410_x().field_71439_g != null) {
            return targetBoss != null && !targetBoss.field_70128_L && Minecraft.func_71410_x().field_71439_g.func_70685_l((Entity)targetBoss) && targetBoss.func_70032_d((Entity)Minecraft.func_71410_x().field_71439_g) <= 12.0f;
        }
        return false;
    }

    @SubscribeEvent
    public void TickEvent(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.displayBossHealth && BossHealthDisplayTicker.validTargetPresent(targetBoss) && Minecraft.func_71410_x().field_71439_g != null) {
            this.renderBossHealthBar(targetBoss, targetBoss.getDefaultEntityName() + " Health");
        }
    }

    public void renderBossHealthBar(EntityGenericAnimal boss, String healthBarTitle) {
        FontRenderer fontRenderer = this.mc.field_71466_p;
        ScaledResolution var3 = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
        int screenWidth = var3.func_78326_a();
        int healthBarHeight = 12;
        fontRenderer.func_78261_a(healthBarTitle, screenWidth / 2 - fontRenderer.func_78256_a(healthBarTitle) / 2, healthBarHeight - 10, 0xFF00FF);
        GL11.glBindTexture((int)3553, (int)this.mc.field_71446_o.func_110581_b(icons).func_110552_b());
        int fullHealthBarWidth = 182;
        int healthBarOffset = screenWidth / 2 - fullHealthBarWidth / 2;
        int currHealthBarWidth = (int)(boss.func_110143_aJ() / boss.func_110138_aP() * (float)(fullHealthBarWidth + 1));
        this.drawTexturedModalRect(healthBarOffset, healthBarHeight, 0, 74, fullHealthBarWidth, 5);
        if (currHealthBarWidth > 0) {
            this.drawTexturedModalRect(healthBarOffset, healthBarHeight, 0, 79, currHealthBarWidth, 5);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawTexturedModalRect(int p_73729_1_, int p_73729_2_, int p_73729_3_, int p_73729_4_, int p_73729_5_, int p_73729_6_) {
        float var7 = 0.00390625f;
        float var8 = 0.00390625f;
        Tessellator var9 = Tessellator.field_78398_a;
        var9.func_78382_b();
        var9.func_78374_a((double)(p_73729_1_ + 0), (double)(p_73729_2_ + p_73729_6_), (double)this.zLevel, (double)((float)(p_73729_3_ + 0) * var7), (double)((float)(p_73729_4_ + p_73729_6_) * var8));
        var9.func_78374_a((double)(p_73729_1_ + p_73729_5_), (double)(p_73729_2_ + p_73729_6_), (double)this.zLevel, (double)((float)(p_73729_3_ + p_73729_5_) * var7), (double)((float)(p_73729_4_ + p_73729_6_) * var8));
        var9.func_78374_a((double)(p_73729_1_ + p_73729_5_), (double)(p_73729_2_ + 0), (double)this.zLevel, (double)((float)(p_73729_3_ + p_73729_5_) * var7), (double)((float)(p_73729_4_ + 0) * var8));
        var9.func_78374_a((double)(p_73729_1_ + 0), (double)(p_73729_2_ + 0), (double)this.zLevel, (double)((float)(p_73729_3_ + 0) * var7), (double)((float)(p_73729_4_ + 0) * var8));
        var9.func_78381_a();
    }
}

