/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.mobs.packets;

import com.stek101.projectzulu.common.blocks.tombstone.TileEntityTombstone;
import com.stek101.projectzulu.common.core.ProjectZuluLog;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;

public class PZPacketTileText
implements IMessage,
IMessageHandler<PZPacketTileText, IMessage> {
    private int tileLocationX;
    private int tileLocationY;
    private int tileLocationZ;
    private String[] text;

    public PZPacketTileText setPacketData(int tileLocationX, int tileLocationY, int tileLocationZ, String[] text) {
        this.tileLocationX = tileLocationX;
        this.tileLocationY = tileLocationY;
        this.tileLocationZ = tileLocationZ;
        this.text = text;
        return this;
    }

    public void toBytes(ByteBuf buffer) {
        ByteBufOutputStream data = new ByteBufOutputStream(buffer);
        try {
            this.writeData(data);
        }
        catch (Exception e) {
            ProjectZuluLog.severe("Error writing packet %s to ByteBufOutputStream", this);
            e.printStackTrace();
        }
    }

    public void fromBytes(ByteBuf buffer) {
        ByteBufInputStream byteStream = new ByteBufInputStream(buffer);
        try {
            this.readData(byteStream);
        }
        catch (Exception e) {
            ProjectZuluLog.severe("Error reading packet %s from ByteBufInputStream", this);
            e.printStackTrace();
        }
    }

    protected void writeData(ByteBufOutputStream buffer) throws IOException {
        buffer.writeInt(this.tileLocationX);
        buffer.writeInt(this.tileLocationY);
        buffer.writeInt(this.tileLocationZ);
        buffer.writeInt(this.text.length);
        for (String string : this.text) {
            buffer.writeInt(string.length());
            buffer.writeChars(string);
        }
    }

    protected void readData(ByteBufInputStream buffer) throws IOException {
        this.tileLocationX = buffer.readInt();
        this.tileLocationY = buffer.readInt();
        this.tileLocationZ = buffer.readInt();
        int numTexts = buffer.readInt();
        this.text = new String[numTexts];
        for (int i = 0; i < numTexts; ++i) {
            int stringLength = buffer.readInt();
            char[] stringChars = new char[stringLength];
            for (int j = 0; j < stringLength; ++j) {
                stringChars[j] = buffer.readChar();
            }
            this.text[i] = new String(stringChars);
        }
    }

    public IMessage onMessage(PZPacketTileText message, MessageContext ctx) {
        TileEntity tile;
        if (ctx.side != Side.SERVER) {
            return null;
        }
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        if (player.field_70170_p.func_147438_o(message.tileLocationX, message.tileLocationY, message.tileLocationZ) instanceof TileEntityTombstone && (tile = player.field_70170_p.func_147438_o(message.tileLocationX, message.tileLocationY, message.tileLocationZ)) != null && tile instanceof TileEntityTombstone) {
            TileEntityTombstone tombstone = (TileEntityTombstone)tile;
            tombstone.signText = message.text;
            player.field_70170_p.func_147471_g(message.tileLocationX, message.tileLocationY, message.tileLocationZ);
        }
        return null;
    }
}

